/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.CommonBundle;
import com.intellij.debugger.ui.DebuggerView;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiBundle;
import com.intellij.ui.PlaceHolder;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.nio.charset.Charset;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteExternalSystemCommunicationManager
implements ExternalSystemCommunicationManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoteExternalSystemCommunicationManager.class.getName()));
    private static final String MAIN_CLASS_NAME = RemoteExternalSystemFacadeImpl.class.getName();
    private final AtomicReference<RemoteExternalSystemProgressNotificationManager> myExportedNotificationManager;
    @NotNull
    private final ThreadLocal<ProjectSystemId> myTargetExternalSystemId;
    @NotNull
    private final ExternalSystemProgressNotificationManagerImpl myProgressManager;
    @NotNull
    private final RemoteProcessSupport<Object, RemoteExternalSystemFacade, String> mySupport;

    public RemoteExternalSystemCommunicationManager(@NotNull ExternalSystemProgressNotificationManager notificationManager) {
        if (notificationManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager", "<init>"));
        }
        this.myExportedNotificationManager = new AtomicReference();
        this.myTargetExternalSystemId = new ThreadLocal();
        this.myProgressManager = (ExternalSystemProgressNotificationManagerImpl)notificationManager;
        this.mySupport = new RemoteProcessSupport<Object, RemoteExternalSystemFacade, String>(RemoteExternalSystemFacade.class){

            @Override
            protected void fireModificationCountChanged() {
            }

            @Override
            protected String getName(Object o) {
                return RemoteExternalSystemFacade.class.getName();
            }

            @Override
            protected RunProfileState getRunProfileState(Object o, String configuration, Executor executor) throws ExecutionException {
                return RemoteExternalSystemCommunicationManager.this.createRunProfileState(configuration);
            }
        };
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                RemoteExternalSystemCommunicationManager.this.shutdown(false);
            }
        });
    }

    public synchronized void shutdown(boolean wait) {
        this.mySupport.stopAll(wait);
    }

    private RunProfileState createRunProfileState(final String configuration) {
        return new CommandLineState(null){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                ExternalSystemManager manager;
                SimpleJavaParameters params = new SimpleJavaParameters();
                params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                File myWorkingDirectory = new File(configuration);
                params.setWorkingDirectory(myWorkingDirectory.isDirectory() ? myWorkingDirectory.getPath() : PathManager.getBinPath());
                ArrayList classPath = ContainerUtilRt.newArrayList();
                classPath.addAll(PathManager.getUtilClassPath());
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(ProjectBundle.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(PlaceHolder.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(DebuggerView.class), (Collection)classPath);
                ExternalSystemApiUtil.addBundle((PathsList)params.getClassPath(), (String)"messages.ProjectBundle", ProjectBundle.class);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(PsiBundle.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(Alarm.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(DependencyScope.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(ExtensionPointName.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(OpenProjectFileChooserDescriptor.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(ExternalSystemTaskNotificationListener.class), (Collection)classPath);
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()), (Collection)classPath);
                ExternalSystemApiUtil.addBundle((PathsList)params.getClassPath(), (String)"messages.CommonBundle", CommonBundle.class);
                params.getClassPath().addAll((List)classPath);
                params.setMainClass(MAIN_CLASS_NAME);
                params.getVMParametersList().addParametersString("-Djava.awt.headless=true");
                params.getVMParametersList().addParametersString("-Dsun.rmi.transport.connectionTimeout=" + String.valueOf(TimeUnit.HOURS.toMillis(1L)));
                ProjectSystemId externalSystemId = (ProjectSystemId)RemoteExternalSystemCommunicationManager.this.myTargetExternalSystemId.get();
                if (externalSystemId != null && (manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId)) != null) {
                    params.getClassPath().add(PathUtil.getJarPathForClass(manager.getProjectResolverClass().getClass()));
                    params.getProgramParametersList().add(manager.getProjectResolverClass().getName());
                    params.getProgramParametersList().add(manager.getTaskManagerClass().getName());
                    manager.enhanceRemoteProcessing(params);
                }
                return params;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager$3", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager$3", "execute"));
                }
                OSProcessHandler processHandler = this.startProcess();
                DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(null, (ProcessHandler)processHandler, AnAction.EMPTY_ARRAY);
                if (defaultExecutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager$3", "execute"));
                }
                return defaultExecutionResult;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                SimpleJavaParameters params = this.createJavaParameters();
                Sdk sdk = params.getJdk();
                if (sdk == null) {
                    throw new ExecutionException("No sdk is defined. Params: " + params);
                }
                final GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine((String)((JavaSdkType)sdk.getSdkType()).getVMExecutablePath(sdk), (SimpleJavaParameters)params, (boolean)false);
                OSProcessHandler processHandler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString()){

                    public Charset getCharset() {
                        return commandLine.getCharset();
                    }
                };
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                OSProcessHandler oSProcessHandler = processHandler;
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager$3", "startProcess"));
                }
                return oSProcessHandler;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RemoteExternalSystemFacade acquire(@NotNull String id, @NotNull ProjectSystemId externalSystemId) throws Exception {
        RemoteExternalSystemFacade facade;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager", "acquire"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager", "acquire"));
        }
        this.myTargetExternalSystemId.set(externalSystemId);
        try {
            facade = this.mySupport.acquire(this, id);
        }
        finally {
            this.myTargetExternalSystemId.set(null);
        }
        if (facade == null) {
            return null;
        }
        RemoteExternalSystemProgressNotificationManager exported = this.myExportedNotificationManager.get();
        if (exported == null) {
            try {
                exported = (RemoteExternalSystemProgressNotificationManager)UnicastRemoteObject.exportObject((Remote)this.myProgressManager, 0);
                this.myExportedNotificationManager.set(exported);
            }
            catch (RemoteException e) {
                exported = this.myExportedNotificationManager.get();
            }
        }
        if (exported == null) {
            LOG.warn("Can't export progress manager");
        } else {
            facade.applyProgressManager(exported);
        }
        return facade;
    }

    @Override
    public void release(@NotNull String id, @NotNull ProjectSystemId externalSystemId) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager", "release"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager", "release"));
        }
        this.mySupport.release(this, id);
    }

    @Override
    public boolean isAlive(@NotNull RemoteExternalSystemFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/RemoteExternalSystemCommunicationManager", "isAlive"));
        }
        RemoteExternalSystemFacade toCheck = facade;
        if (facade instanceof ExternalSystemFacadeWrapper) {
            toCheck = ((ExternalSystemFacadeWrapper)facade).getDelegate();
        }
        if (toCheck instanceof InProcessExternalSystemFacadeImpl) {
            return false;
        }
        try {
            facade.getResolver();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.mySupport.stopAll(true);
    }
}

