/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalActionUtil {
    @NotNull
    public static MyInfo getProcessingInfo(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/action/ExternalActionUtil", "getProcessingInfo"));
        }
        ExternalProjectPojo externalProject = (ExternalProjectPojo)ExternalSystemDataKeys.SELECTED_PROJECT.getData(context);
        if (externalProject == null) {
            MyInfo myInfo = MyInfo.EMPTY;
            if (myInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/ExternalActionUtil", "getProcessingInfo"));
            }
            return myInfo;
        }
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(context);
        if (externalSystemId == null) {
            MyInfo myInfo = MyInfo.EMPTY;
            if (myInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/ExternalActionUtil", "getProcessingInfo"));
            }
            return myInfo;
        }
        Project ideProject = (Project)CommonDataKeys.PROJECT.getData(context);
        if (ideProject == null) {
            MyInfo myInfo = MyInfo.EMPTY;
            if (myInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/ExternalActionUtil", "getProcessingInfo"));
            }
            return myInfo;
        }
        AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)ideProject, (ProjectSystemId)externalSystemId);
        ExternalProjectSettings externalProjectSettings = settings.getLinkedProjectSettings(externalProject.getPath());
        AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)ideProject, (ProjectSystemId)externalSystemId);
        MyInfo myInfo = new MyInfo(externalProjectSettings == null ? null : settings, localSettings == null ? null : localSettings, externalProjectSettings == null ? null : externalProject, ideProject, externalSystemId);
        if (myInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/ExternalActionUtil", "getProcessingInfo"));
        }
        return myInfo;
    }

    public static class MyInfo {
        public static final MyInfo EMPTY = new MyInfo(null, null, null, null, null);
        @Nullable
        public final AbstractExternalSystemSettings<?, ?, ?> settings;
        @Nullable
        public final AbstractExternalSystemLocalSettings localSettings;
        @Nullable
        public final ExternalProjectPojo externalProject;
        @Nullable
        public final Project ideProject;
        @Nullable
        public final ProjectSystemId externalSystemId;

        MyInfo(@Nullable AbstractExternalSystemSettings<?, ?, ?> settings, @Nullable AbstractExternalSystemLocalSettings localSettings, @Nullable ExternalProjectPojo externalProject, @Nullable Project ideProject, @Nullable ProjectSystemId externalSystemId) {
            this.settings = settings;
            this.localSettings = localSettings;
            this.externalProject = externalProject;
            this.ideProject = ideProject;
            this.externalSystemId = externalSystemId;
        }
    }
}

