/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.action.ExternalActionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemRecentTasksList;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;

public class DetachExternalProjectAction
extends AnAction
implements DumbAware {
    public DetachExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.detach.external.project.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Remove : AllIcons.ToolbarDecorator.Remove);
    }

    public void update(AnActionEvent e) {
        ExternalActionUtil.MyInfo info = ExternalActionUtil.getProcessingInfo(e.getDataContext());
        e.getPresentation().setEnabled(info.externalProject != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ExternalSystemRecentTasksList recentTasksList;
        ExternalActionUtil.MyInfo info = ExternalActionUtil.getProcessingInfo(e.getDataContext());
        if (info.settings == null || info.localSettings == null || info.externalProject == null || info.ideProject == null || info.externalSystemId == null) {
            return;
        }
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{info.externalSystemId.getReadableName()}));
        ExternalSystemTasksTreeModel allTasksModel = (ExternalSystemTasksTreeModel)ExternalSystemDataKeys.ALL_TASKS_MODEL.getData(e.getDataContext());
        if (allTasksModel != null) {
            allTasksModel.pruneNodes(info.externalProject);
        }
        if ((recentTasksList = (ExternalSystemRecentTasksList)((Object)ExternalSystemDataKeys.RECENT_TASKS_LIST.getData(e.getDataContext()))) != null) {
            recentTasksList.getModel().forgetTasksFrom(info.externalProject.getPath());
        }
        info.localSettings.forgetExternalProjects(Collections.singleton(info.externalProject.getPath()));
        info.settings.unlinkExternalProject(info.externalProject.getPath());
        PlatformFacade platformFacade = (PlatformFacade)ServiceManager.getService(PlatformFacade.class);
        String externalSystemIdAsString = info.externalSystemId.toString();
        ArrayList orphanModules = ContainerUtilRt.newArrayList();
        for (Module module : platformFacade.getModules(info.ideProject)) {
            String systemId = module.getOptionValue("external.system.id");
            if (!externalSystemIdAsString.equals(systemId)) continue;
            String path = module.getOptionValue("external.linked.project.path");
            if (!info.externalProject.getPath().equals(path)) continue;
            orphanModules.add(module);
        }
        if (!orphanModules.isEmpty()) {
            ExternalSystemUtil.ruleOrphanModules(orphanModules, info.ideProject, info.externalSystemId);
        }
    }
}

