/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import org.jetbrains.annotations.NotNull;

class FoldingData {
    int widthInColumns;
    int startX;
    private final Editor myEditor;
    private final EditorTextRepresentationHelper myRepresentationHelper;
    private final FoldRegion myFoldRegion;

    FoldingData(@NotNull FoldRegion foldRegion, int startX, @NotNull EditorTextRepresentationHelper representationHelper, @NotNull Editor editor) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/FoldingData", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/softwrap/mapping/FoldingData", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/softwrap/mapping/FoldingData", "<init>"));
        }
        this.widthInColumns = -1;
        this.myFoldRegion = foldRegion;
        this.startX = startX;
        this.myRepresentationHelper = representationHelper;
        this.myEditor = editor;
    }

    public int getCollapsedSymbolsWidthInColumns() {
        if (this.widthInColumns < 0) {
            Document document = this.myEditor.getDocument();
            this.widthInColumns = this.myRepresentationHelper.toVisualColumnSymbolsNumber(document.getCharsSequence(), this.myFoldRegion.getStartOffset(), this.myFoldRegion.getEndOffset(), this.startX);
        }
        return this.widthInColumns;
    }

    @NotNull
    public FoldRegion getFoldRegion() {
        FoldRegion foldRegion = this.myFoldRegion;
        if (foldRegion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/FoldingData", "getFoldRegion"));
        }
        return foldRegion;
    }

    public String toString() {
        return "width in columns: " + this.widthInColumns + ", start X: " + this.startX + ", fold region: " + this.myFoldRegion;
    }
}

