/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CacheUpdateEventsStorage {
    private final List<IncrementalCacheUpdateEvent> myEvents = new ArrayList<IncrementalCacheUpdateEvent>();

    public void add(@NotNull Document document, @NotNull IncrementalCacheUpdateEvent event) {
        IncrementalCacheUpdateEvent next;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheUpdateEventsStorage", "add"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheUpdateEventsStorage", "add"));
        }
        if (this.myEvents.isEmpty()) {
            this.myEvents.add(event);
            return;
        }
        int i = this.findIndex(event);
        if (i < 0) {
            i = -i - 1;
        }
        if (event.getExactOffsetsDiff() != 0) {
            if (i >= this.myEvents.size()) {
                this.myEvents.add(event);
            } else {
                this.myEvents.add(i, event);
            }
            return;
        }
        boolean shouldAdd = true;
        if (i > 0) {
            IncrementalCacheUpdateEvent previous = this.myEvents.get(i - 1);
            if (CacheUpdateEventsStorage.contains(previous, event)) {
                return;
            }
            if (CacheUpdateEventsStorage.contains(event, previous)) {
                this.myEvents.set(i - 1, event);
                shouldAdd = false;
            } else if (previous.getExactOffsetsDiff() == 0 && previous.getOldEndOffset() == event.getOldStartOffset() - 1) {
                this.myEvents.set(i - 1, new IncrementalCacheUpdateEvent(document, previous.getOldStartOffset(), event.getOldEndOffset()));
                shouldAdd = false;
            }
        }
        if (i < this.myEvents.size() && (next = this.myEvents.get(i)).getExactOffsetsDiff() == 0 && next.getOldStartOffset() == event.getOldEndOffset() + 1) {
            if (shouldAdd) {
                this.myEvents.set(i, new IncrementalCacheUpdateEvent(document, event.getOldStartOffset(), next.getOldEndOffset()));
            } else {
                IncrementalCacheUpdateEvent previous = this.myEvents.get(i - 1);
                this.myEvents.set(i - 1, new IncrementalCacheUpdateEvent(document, previous.getOldStartOffset(), next.getOldEndOffset()));
                this.myEvents.remove(i);
            }
            shouldAdd = false;
        }
        if (shouldAdd) {
            this.myEvents.add(i, event);
        }
    }

    private int findIndex(IncrementalCacheUpdateEvent event) {
        int start = 0;
        int end = this.myEvents.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            IncrementalCacheUpdateEvent e = this.myEvents.get(i);
            if (e.getOldExactStartOffset() < event.getOldExactStartOffset()) {
                start = i + 1;
                continue;
            }
            if (e.getOldExactStartOffset() > event.getOldExactStartOffset()) {
                end = i - 1;
                continue;
            }
            return i;
        }
        return -(start + 1);
    }

    private static boolean contains(@NotNull IncrementalCacheUpdateEvent larger, @NotNull IncrementalCacheUpdateEvent smaller) {
        if (larger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheUpdateEventsStorage", "contains"));
        }
        if (smaller == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheUpdateEventsStorage", "contains"));
        }
        if (larger.getExactOffsetsDiff() != 0 || smaller.getExactOffsetsDiff() != 0) {
            return false;
        }
        return larger.getOldStartOffset() <= smaller.getOldStartOffset() && larger.getOldEndOffset() >= smaller.getOldEndOffset();
    }

    @NotNull
    public List<IncrementalCacheUpdateEvent> getEvents() {
        List<IncrementalCacheUpdateEvent> list = this.myEvents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheUpdateEventsStorage", "getEvents"));
        }
        return list;
    }

    public void release() {
        this.myEvents.clear();
    }

    public String toString() {
        return this.myEvents.toString();
    }
}

