/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import org.jetbrains.annotations.NotNull;

public class SoftWrapImpl
implements SoftWrap {
    private final TextChangeImpl myChange;
    private final int myIndentInColumns;
    private final int myIndentInPixels;

    public SoftWrapImpl(@NotNull TextChangeImpl change, int indentInColumns, int indentInPixels) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/SoftWrapImpl", "<init>"));
        }
        this.myChange = change;
        this.myIndentInColumns = indentInColumns;
        this.myIndentInPixels = indentInPixels;
    }

    public int getStart() {
        return this.myChange.getStart();
    }

    public int getEnd() {
        return this.myChange.getEnd();
    }

    @NotNull
    public CharSequence getText() {
        CharSequence charSequence = this.myChange.getText();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/SoftWrapImpl", "getText"));
        }
        return charSequence;
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = this.myChange.getChars();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/SoftWrapImpl", "getChars"));
        }
        return cArray;
    }

    public int getIndentInColumns() {
        return this.myIndentInColumns;
    }

    public int getIndentInPixels() {
        return this.myIndentInPixels;
    }

    public TextChangeImpl getChange() {
        return this.myChange;
    }

    public void advance(int diff) {
        this.myChange.advance(diff);
    }

    public int hashCode() {
        int result = this.myChange.hashCode();
        result = 31 * result + this.myIndentInColumns;
        return 31 * result + this.myIndentInPixels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftWrapImpl that = (SoftWrapImpl)o;
        return this.myIndentInColumns == that.myIndentInColumns && this.myIndentInPixels == that.myIndentInPixels && this.myChange.equals(that.myChange);
    }

    public String toString() {
        return this.myChange.toString();
    }
}

