/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;

public class SoftWrapHelper {
    private SoftWrapHelper() {
    }

    public static boolean isCaretAfterSoftWrap(EditorImpl editor) {
        int offset;
        CaretModelImpl caretModel = editor.getCaretModel();
        if (!caretModel.isUpToDate()) {
            return false;
        }
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        SoftWrap softWrap = softWrapModel.getSoftWrap(offset = caretModel.getOffset());
        if (softWrap == null) {
            return false;
        }
        return editor.offsetToVisualLine(offset) == caretModel.getVisualPosition().line;
    }
}

