/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableText;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.DocumentImpl");
    public static boolean CHECK_DOCUMENT_CONSISTENCY = ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    private final Ref<DocumentListener[]> myCachedDocumentListeners;
    private final List<DocumentListener> myDocumentListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private ReadonlyFragmentModificationHandler myReadonlyFragmentModificationHandler;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableText myText;
    private volatile SoftReference<String> myTextString;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<EditReadOnlyListener> myReadOnlyListeners;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;

    public DocumentImpl(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(text, false);
    }

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this.myCachedDocumentListeners = Ref.create(null);
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.myIsReadOnly = false;
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCheckGuardedBlocks = 0;
        this.myGuardsSuppressed = false;
        this.myEventsHandling = false;
        this.myDoingBulkUpdate = false;
        this.myAcceptSlashR = false;
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index) {
                return DocumentImpl.this.myText.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string = DocumentImpl.this.doGetText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
                }
                return string;
            }
        };
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = ImmutableText.valueOf((Object)chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    lineSet = new LineSet();
                    lineSet.documentCreated(this);
                    this.myLineSet = lineSet;
                }
            }
        }
        return lineSet;
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.myText);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getChars"));
        }
        return cArray;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.isStripTrailingSpacesEnabled = isEnabled;
    }

    public boolean stripTrailingSpaces(Project project) {
        return this.stripTrailingSpaces(project, false, false, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stripTrailingSpaces(@Nullable Project project, boolean inChangedLinesOnly, boolean virtualSpaceEnabled, int caretLine, int caretOffset) {
        if (!this.isStripTrailingSpacesEnabled) {
            return true;
        }
        boolean markAsNeedsStrippingLater = false;
        ImmutableText text = this.myText;
        RangeMarker caretMarker = caretOffset < 0 || caretOffset > this.getTextLength() ? null : this.createRangeMarker(caretOffset, caretOffset);
        try {
            LineSet lineSet = this.getLineSet();
            for (int line = 0; line < lineSet.getLineCount(); ++line) {
                char c;
                if (inChangedLinesOnly && !lineSet.isModified(line)) continue;
                int whiteSpaceStart = -1;
                final int lineEnd = lineSet.getLineEnd(line) - lineSet.getSeparatorLength(line);
                int lineStart = lineSet.getLineStart(line);
                int offset = lineEnd - 1;
                while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                    whiteSpaceStart = offset--;
                }
                if (whiteSpaceStart == -1) continue;
                if (!virtualSpaceEnabled && caretLine == line && caretMarker != null && caretMarker.getStartOffset() >= 0 && whiteSpaceStart < caretMarker.getStartOffset()) {
                    markAsNeedsStrippingLater = true;
                    continue;
                }
                final int finalStart = whiteSpaceStart;
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new DocumentRunnable(this, project){

                    public void run() {
                        DocumentImpl.this.deleteString(finalStart, lineEnd);
                    }
                });
                text = this.myText;
            }
        }
        finally {
            if (caretMarker != null) {
                caretMarker.dispose();
            }
        }
        return markAsNeedsStrippingLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stripTrailingSpaces(@Nullable Project project, boolean inChangedLinesOnly, boolean virtualSpaceEnabled, @NotNull List<Integer> caretOffsets) {
        if (caretOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/DocumentImpl", "stripTrailingSpaces"));
        }
        if (!this.isStripTrailingSpacesEnabled) {
            return true;
        }
        boolean markAsNeedsStrippingLater = false;
        ImmutableText text = this.myText;
        TIntObjectHashMap caretMarkers = new TIntObjectHashMap(caretOffsets.size());
        try {
            if (!virtualSpaceEnabled) {
                for (Integer caretOffset : caretOffsets) {
                    if (caretOffset == null || caretOffset < 0 || caretOffset > this.getTextLength()) continue;
                    Integer line = this.getLineNumber(caretOffset);
                    ArrayList<RangeMarker> markers = (ArrayList<RangeMarker>)caretMarkers.get(line.intValue());
                    if (markers == null) {
                        markers = new ArrayList<RangeMarker>();
                        caretMarkers.put(line.intValue(), markers);
                    }
                    RangeMarker marker = this.createRangeMarker(caretOffset, caretOffset);
                    markers.add(marker);
                }
            }
            LineSet lineSet = this.getLineSet();
            block3: for (int line = 0; line < lineSet.getLineCount(); ++line) {
                List markers;
                char c;
                if (inChangedLinesOnly && !lineSet.isModified(line)) continue;
                int whiteSpaceStart = -1;
                final int lineEnd = lineSet.getLineEnd(line) - lineSet.getSeparatorLength(line);
                int lineStart = lineSet.getLineStart(line);
                int offset = lineEnd - 1;
                while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                    whiteSpaceStart = offset--;
                }
                if (whiteSpaceStart == -1) continue;
                if (!virtualSpaceEnabled && (markers = (List)caretMarkers.get(line)) != null) {
                    for (RangeMarker marker : markers) {
                        if (marker.getStartOffset() < 0 || whiteSpaceStart >= marker.getStartOffset()) continue;
                        markAsNeedsStrippingLater = true;
                        continue block3;
                    }
                }
                final int finalStart = whiteSpaceStart;
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new DocumentRunnable(this, project){

                    public void run() {
                        DocumentImpl.this.deleteString(finalStart, lineEnd);
                    }
                });
                text = this.myText;
            }
        }
        catch (Throwable throwable) {
            caretMarkers.forEachValue((TObjectProcedure)new TObjectProcedure<List<RangeMarker>>(){

                public boolean execute(List<RangeMarker> markerList) {
                    if (markerList != null) {
                        for (RangeMarker marker : markerList) {
                            try {
                                marker.dispose();
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                    return true;
                }
            });
            throw throwable;
        }
        caretMarkers.forEachValue((TObjectProcedure)new /* invalid duplicate definition of identical inner class */);
        return markAsNeedsStrippingLater;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentModificationHandler;
    }

    public void setReadonlyFragmentModificationHandler(ReadonlyFragmentModificationHandler readonlyFragmentModificationHandler) {
        this.myReadonlyFragmentModificationHandler = readonlyFragmentModificationHandler;
    }

    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removeRangeMarker"));
        }
        return this.myRangeMarkers.removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "registerRangeMarker"));
        }
        this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
    }

    public int getRangeMarkersSize() {
        return this.myRangeMarkers.size();
    }

    public int getRangeMarkersNodeSize() {
        return this.myRangeMarkers.nodeSize();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, (Object)"Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createGuardedBlock"));
        }
        return rangeMarker;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removeGuardedBlock"));
        }
        this.myGuardedBlocks.remove(block);
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = this.myGuardedBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getGuardedBlocks"));
        }
        return list;
    }

    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, true, block.getStartOffset(), block.isGreedyToLeft(), end, true, block.getEndOffset(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, (Object)"Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangesIntersect(int start0, boolean leftInclusive0, int start1, boolean leftInclusive1, int end0, boolean rightInclusive0, int end1, boolean rightInclusive1) {
        if (start0 > start1 || start0 == start1 && !leftInclusive0) {
            return DocumentImpl.rangesIntersect(start1, leftInclusive1, start0, leftInclusive0, end1, rightInclusive1, end0, rightInclusive0);
        }
        if (end0 == start1) {
            return leftInclusive1 && rightInclusive0;
        }
        return end0 > start1;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset, false);
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        RangeMarkerImpl rangeMarkerImpl = surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset, true) : new RangeMarkerImpl(this, startOffset, endOffset, true);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarkerImpl;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceText"));
        }
        this.replaceString(0, this.getTextLength(), chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    @Override
    public int getListenersCount() {
        return this.myDocumentListeners.size();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/DocumentImpl", "insertString"));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, s.length() - 20), s.length()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, null, ((Object)s).toString());
        }
        this.updateText(this.myText.insert(offset, ImmutableText.valueOf((Object)s)), offset, null, s, false, LocalTimeCounter.currentTime());
        this.trimToSize();
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (startOffset == endOffset) {
            return;
        }
        CharSequence sToDelete = this.myText.subSequence(startOffset, endOffset);
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, ((Object)sToDelete).toString(), null);
        }
        this.updateText(this.myText.delete(startOffset, endOffset), startOffset, sToDelete, null, false, LocalTimeCounter.currentTime());
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        this.assertBounds(srcStart, srcEnd);
        if (dstOffset == srcEnd) {
            return;
        }
        ProperTextRange srcRange = new ProperTextRange(srcStart, srcEnd);
        assert (!srcRange.containsOffset(dstOffset)) : "Can't perform text move from range [" + srcStart + "; " + srcEnd + ") to offset " + dstOffset;
        String replacement = ((Object)this.getCharsSequence().subSequence(srcStart, srcEnd)).toString();
        this.insertString(dstOffset, replacement);
        int shift = 0;
        if (dstOffset < srcStart) {
            shift = srcEnd - srcStart;
        }
        this.fireMoveText(srcStart + shift, srcEnd + shift, dstOffset);
        this.deleteString(srcStart + shift, srcEnd + shift);
    }

    private void fireMoveText(int start, int end, int newBase) {
        for (DocumentListener listener : this.getCachedListeners()) {
            if (!(listener instanceof PrioritizedInternalDocumentListener)) continue;
            ((PrioritizedInternalDocumentListener)listener).moveTextHappened(start, end, newBase);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), startOffset == 0 && endOffset == this.getTextLength());
    }

    /*
     * WARNING - void declaration
     */
    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean bl) {
        void wholeTextReplaced;
        int newStartInString;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        int newStringLength = s.length();
        CharSequence chars = this.getCharsSequence();
        int newEndInString = newStringLength;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        while (endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1)) {
            --newEndInString;
            --endOffset;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        CharSequence sToDelete = this.myText.subSequence(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, ((Object)sToDelete).toString(), ((Object)changedPart).toString());
        }
        ImmutableText newText = wholeTextReplaced != false && s instanceof ImmutableText ? (ImmutableText)s : this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
        this.updateText(newText, startOffset, sToDelete, changedPart, (boolean)wholeTextReplaced, newModificationStamp);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "assertValidSeparators"));
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators((CharSequence)s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected nested request for document modification from 'before change' callback!");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset, String oldString, String newString) {
        if (guard == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException((DocumentEvent)event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    @Override
    public void clearLineModificationFlags() {
        this.getLineSet().clearModificationFlags();
    }

    public void clearLineModificationFlagsExcept(@NotNull int[] caretLines) {
        if (caretLines == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "clearLineModificationFlagsExcept"));
        }
        IntArrayList modifiedLines = new IntArrayList(caretLines.length);
        LineSet lineSet = this.getLineSet();
        for (int line : caretLines) {
            if (line < 0 || line >= lineSet.getLineCount() || !lineSet.isModified(line)) continue;
            modifiedLines.add(line);
        }
        this.clearLineModificationFlags();
        for (int i = 0; i < modifiedLines.size(); ++i) {
            lineSet.setModified(modifiedLines.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(@NotNull ImmutableText newText, int offset, @Nullable CharSequence oldString, @Nullable CharSequence newString, boolean wholeTextReplaced, long newModificationStamp) {
        DocumentEvent event;
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        try {
            event = this.doBeforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
        }
        finally {
            this.myChangeInProgress = false;
        }
        this.myTextString = null;
        this.myText = newText;
        this.changedUpdate(event, newModificationStamp);
    }

    @NotNull
    private DocumentEvent doBeforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
        VirtualFile file;
        FileDocumentManager manager;
        Application app = ApplicationManager.getApplication();
        if (app != null && (manager = FileDocumentManager.getInstance()) != null && (file = manager.getFile((Document)this)) != null && !file.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        this.assertInsideCommand();
        this.getLineSet();
        DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced);
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getCachedListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange((DocumentEvent)event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
        DocumentEventImpl documentEventImpl = event;
        if (documentEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doBeforeChangedUpdate"));
        }
        return documentEventImpl;
    }

    private void assertInsideCommand() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null && this.myAssertThreading) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            this.getLineSet().changedUpdate(event);
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getCachedListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @NotNull
    public String getText() {
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return DocumentImpl.this.doGetText();
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    @NotNull
    private String doGetText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doGetText"));
        }
        return string;
    }

    @NotNull
    public String getText(final @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return ((Object)DocumentImpl.this.myText.subSequence(range.getStartOffset(), range.getEndOffset())).toString();
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myMutableCharSequence;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCharsSequence"));
        }
        return charSequence;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableText immutableText = this.myText;
        if (immutableText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getImmutableCharSequence"));
        }
        return immutableText;
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        this.myCachedDocumentListeners.set(null);
        if (this.myDocumentListeners.contains(listener)) {
            LOG.error("Already registered: " + listener);
        }
        boolean added = this.myDocumentListeners.add(listener);
        LOG.assertTrue(added, (Object)listener);
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        this.addDocumentListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new DocumentListenerDisposable(listener, this.myCachedDocumentListeners, this.myDocumentListeners));
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removeDocumentListener"));
        }
        DocumentImpl.doRemoveDocumentListener(listener, this.myCachedDocumentListeners, this.myDocumentListeners);
    }

    private static void doRemoveDocumentListener(@NotNull DocumentListener listener, @NotNull Ref<DocumentListener[]> cachedDocumentListenersRef, @NotNull List<DocumentListener> documentListeners) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        if (cachedDocumentListenersRef == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        if (documentListeners == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        cachedDocumentListenersRef.set(null);
        boolean success = documentListeners.remove(listener);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener + "). Registered listeners: " + documentListeners);
        }
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.getLineSet().createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createLineIterator"));
        }
        return lineIterator;
    }

    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result >= 0);
        return result;
    }

    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getCachedListeners() {
        DocumentListener[] cachedListeners = (DocumentListener[])this.myCachedDocumentListeners.get();
        if (cachedListeners == null) {
            DocumentListener[] listeners = this.myDocumentListeners.toArray(new DocumentListener[this.myDocumentListeners.size()]);
            Arrays.sort(listeners, PrioritizedDocumentListener.COMPARATOR);
            cachedListeners = listeners;
            this.myCachedDocumentListeners.set((Object)cachedListeners);
        }
        if (cachedListeners == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCachedListeners"));
        }
        return cachedListeners;
    }

    public void fireReadOnlyModificationAttempt() {
        for (EditReadOnlyListener listener : this.myReadOnlyListeners) {
            listener.readOnlyModificationAttempt(this);
        }
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "addEditReadOnlyListener"));
        }
        this.myReadOnlyListeners.add(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removeEditReadOnlyListener"));
        }
        this.myReadOnlyListeners.remove(listener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    public void setText(final @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "setText"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.replaceString(0, DocumentImpl.this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
            }
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)this));
        }
        this.clearLineModificationFlags();
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    @Override
    public final void setInBulkUpdate(boolean value) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myDoingBulkUpdate == value) {
            return;
        }
        this.myDoingBulkUpdate = value;
        if (value) {
            DocumentImpl.getPublisher().updateStarted(this);
        } else {
            DocumentImpl.getPublisher().updateFinished(this);
        }
    }

    @NotNull
    private static DocumentBulkUpdateListener getPublisher() {
        DocumentBulkUpdateListener documentBulkUpdateListener = DocumentBulkUpdateListenerHolder.ourBulkChangePublisher;
        if (documentBulkUpdateListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getPublisher"));
        }
        return documentBulkUpdateListener;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "processRangeMarkers"));
        }
        return this.myRangeMarkers.process(processor);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/DocumentImpl", "processRangeMarkersOverlappingWith"));
        }
        return this.myRangeMarkers.processOverlappingWith(start, end, processor);
    }

    @NotNull
    public String dumpState() {
        StringBuilder result = new StringBuilder();
        result.append(", intervals:\n");
        for (int line = 0; line < this.getLineCount(); ++line) {
            result.append(line).append(": ").append(this.getLineStartOffset(line)).append("-").append(this.getLineEndOffset(line)).append(", ");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile((Document)this) + "]";
    }

    private static class DocumentBulkUpdateListenerHolder {
        private static final DocumentBulkUpdateListener ourBulkChangePublisher = (DocumentBulkUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DocumentBulkUpdateListener.TOPIC);

        private DocumentBulkUpdateListenerHolder() {
        }
    }

    private static class DocumentListenerDisposable
    implements Disposable {
        private final DocumentListener myListener;
        private final Ref<DocumentListener[]> myCachedDocumentListenersRef;
        private final List<DocumentListener> myDocumentListeners;

        public DocumentListenerDisposable(@NotNull DocumentListener listener, @NotNull Ref<DocumentListener[]> cachedDocumentListenersRef, @NotNull List<DocumentListener> documentListeners) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            if (cachedDocumentListenersRef == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            if (documentListeners == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            this.myListener = listener;
            this.myCachedDocumentListenersRef = cachedDocumentListenersRef;
            this.myDocumentListeners = documentListeners;
        }

        public void dispose() {
            DocumentImpl.doRemoveDocumentListener(this.myListener, (Ref<DocumentListener[]>)this.myCachedDocumentListenersRef, this.myDocumentListeners);
        }
    }
}

