/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener,
Disposable {
    private final EditorImpl myEditor;
    private final EventDispatcher<CaretListener> myCaretListeners = EventDispatcher.create(CaretListener.class);
    private final boolean mySupportsMultipleCarets = Registry.is((String)"editor.allow.multiple.carets");
    private TextAttributes myTextAttributes;
    boolean myIgnoreWrongMoves = false;
    boolean myIsInUpdate;
    boolean isDocumentChanged;
    private final LinkedList<CaretImpl> myCarets = new LinkedList();
    private CaretImpl myCurrentCaret;
    private boolean myPerformCaretMergingAfterCurrentOperation;

    public CaretModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myCarets.add(new CaretImpl(this.myEditor));
        DocumentBulkUpdateListener bulkUpdateListener = new DocumentBulkUpdateListener(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl$1", "updateStarted"));
                }
                for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                    caret.onBulkDocumentUpdateStarted(doc);
                }
            }

            @Override
            public void updateFinished(final @NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl$1", "updateFinished"));
                }
                CaretModelImpl.this.doWithCaretMerging(new Runnable(){

                    @Override
                    public void run() {
                        for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                            caret.onBulkDocumentUpdateFinished(doc);
                        }
                    }
                });
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DocumentBulkUpdateListener.TOPIC, (Object)bulkUpdateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(final DocumentEvent e) {
        this.isDocumentChanged = true;
        try {
            this.myIsInUpdate = false;
            this.doWithCaretMerging(new Runnable(){

                @Override
                public void run() {
                    for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                        caret.updateCaretPosition((DocumentEventImpl)e);
                    }
                }
            });
        }
        finally {
            this.isDocumentChanged = false;
        }
    }

    public void beforeDocumentChange(DocumentEvent e) {
        this.myIsInUpdate = true;
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public void dispose() {
        for (CaretImpl caret : this.myCarets) {
            Disposer.dispose((Disposable)caret);
        }
    }

    public void setIgnoreWrongMoves(boolean ignoreWrongMoves) {
        this.myIgnoreWrongMoves = ignoreWrongMoves;
    }

    public void updateVisualPosition() {
        for (CaretImpl caret : this.myCarets) {
            caret.updateVisualPosition();
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, blockSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "moveToLogicalPosition"));
        }
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "moveToVisualPosition"));
        }
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCurrentCaret().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getCurrentCaret().getLogicalPosition();
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getCurrentCaret().getVisualPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getVisualPosition"));
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    int getWordAtCaretStart() {
        return this.getCurrentCaret().getWordAtCaretStart();
    }

    int getWordAtCaretEnd() {
        return this.getCurrentCaret().getWordAtCaretEnd();
    }

    public void addCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "addCaretListener"));
        }
        this.myCaretListeners.addListener((EventListener)listener);
    }

    public void removeCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "removeCaretListener"));
        }
        this.myCaretListeners.removeListener((EventListener)listener);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            this.myTextAttributes = new TextAttributes();
            this.myTextAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public boolean supportsMultipleCarets() {
        return this.mySupportsMultipleCarets;
    }

    @NotNull
    public CaretImpl getCurrentCaret() {
        CaretImpl currentCaret = this.myCurrentCaret;
        CaretImpl caretImpl = ApplicationManager.getApplication().isDispatchThread() && currentCaret != null ? currentCaret : this.getPrimaryCaret();
        if (caretImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getCurrentCaret"));
        }
        return caretImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CaretImpl getPrimaryCaret() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        CaretImpl caretImpl = this.myCarets.get(this.myCarets.size() - 1);
        // MONITOREXIT : linkedList
        if (caretImpl != null) return caretImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getPrimaryCaret"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretCount() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Caret> getAllCarets() {
        ArrayList<Caret> carets;
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            carets = new ArrayList<Caret>(this.myCarets);
        }
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ArrayList<Caret> arrayList = carets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getAllCarets"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "getCaretAt"));
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            for (CaretImpl caret : this.myCarets) {
                if (!caret.getVisualPosition().equals((Object)pos)) continue;
                return caret;
            }
            return null;
        }
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "addCaret"));
        }
        this.myEditor.assertIsDispatchThread();
        CaretImpl caret = new CaretImpl(this.myEditor);
        caret.moveToVisualPosition(pos, false);
        if (this.addCaret(caret)) {
            return caret;
        }
        Disposer.dispose((Disposable)caret);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCaret(CaretImpl caretToAdd) {
        for (CaretImpl caret : this.myCarets) {
            VisualPosition newVisualPosition = caretToAdd.getVisualPosition();
            int newOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(newVisualPosition));
            if (!caret.getVisualPosition().equals((Object)newVisualPosition) && (newOffset < caret.getSelectionStart() || newOffset > caret.getSelectionEnd())) continue;
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            this.myCarets.add(caretToAdd);
        }
        this.fireCaretAdded(caretToAdd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "removeCaret"));
        }
        this.myEditor.assertIsDispatchThread();
        if (this.myCarets.size() <= 1 || !(caret instanceof CaretImpl)) {
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (!this.myCarets.remove(caret)) {
                return false;
            }
        }
        this.fireCaretRemoved(caret);
        Disposer.dispose((Disposable)caret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryCarets() {
        this.myEditor.assertIsDispatchThread();
        if (!this.supportsMultipleCarets()) {
            return;
        }
        ListIterator<CaretImpl> caretIterator = this.myCarets.listIterator(this.myCarets.size() - 1);
        while (caretIterator.hasPrevious()) {
            CaretImpl caret = caretIterator.previous();
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                caretIterator.remove();
            }
            this.fireCaretRemoved(caret);
            Disposer.dispose((Disposable)caret);
        }
    }

    public void runForEachCaret(final @NotNull CaretAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "runForEachCaret"));
        }
        this.myEditor.assertIsDispatchThread();
        if (!this.supportsMultipleCarets()) {
            action.perform((Caret)this.getPrimaryCaret());
            return;
        }
        if (this.myCurrentCaret != null) {
            action.perform((Caret)this.myCurrentCaret);
            return;
        }
        this.doWithCaretMerging(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<Caret> sortedCarets = CaretModelImpl.this.getAllCarets();
                    for (Caret caret : sortedCarets) {
                        CaretModelImpl.this.myCurrentCaret = (CaretImpl)caret;
                        action.perform(caret);
                    }
                }
                finally {
                    CaretModelImpl.this.myCurrentCaret = null;
                }
            }
        });
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "runBatchCaretOperation"));
        }
        this.myEditor.assertIsDispatchThread();
        this.doWithCaretMerging(runnable);
    }

    private void mergeOverlappingCaretsAndSelections() {
        if (!this.supportsMultipleCarets() || this.myCarets.size() <= 1) {
            return;
        }
        LinkedList<CaretImpl> carets = new LinkedList<CaretImpl>(this.myCarets);
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ListIterator it = carets.listIterator();
        while (it.hasNext()) {
            CaretImpl toRemove;
            CaretImpl toRetain;
            CaretImpl prevCaret = null;
            if (it.hasPrevious()) {
                prevCaret = (CaretImpl)((Object)it.previous());
                it.next();
            }
            CaretImpl currCaret = (CaretImpl)((Object)it.next());
            if (prevCaret == null || !currCaret.getVisualPosition().equals((Object)prevCaret.getVisualPosition()) && !CaretModelImpl.selectionsIntersect(currCaret, prevCaret)) continue;
            int newSelectionStart = Math.min(currCaret.getSelectionStart(), prevCaret.getSelectionStart());
            int newSelectionEnd = Math.max(currCaret.getSelectionEnd(), prevCaret.getSelectionEnd());
            if (currCaret.getOffset() >= prevCaret.getSelectionStart() && currCaret.getOffset() <= prevCaret.getSelectionEnd()) {
                toRetain = prevCaret;
                toRemove = currCaret;
                it.remove();
                it.previous();
            } else {
                toRetain = currCaret;
                toRemove = prevCaret;
                it.previous();
                it.previous();
                it.remove();
            }
            this.removeCaret(toRemove);
            if (newSelectionStart >= newSelectionEnd) continue;
            toRetain.setSelection(newSelectionStart, newSelectionEnd);
        }
    }

    private static boolean selectionsIntersect(CaretImpl firstCaret, CaretImpl secondCaret) {
        return firstCaret.getSelectionStart() < secondCaret.getSelectionStart() && firstCaret.getSelectionEnd() > secondCaret.getSelectionStart() || firstCaret.getSelectionStart() > secondCaret.getSelectionStart() && firstCaret.getSelectionStart() < secondCaret.getSelectionEnd() || firstCaret.getSelectionStart() == secondCaret.getSelectionStart() && secondCaret.getSelectionEnd() > secondCaret.getSelectionStart() && firstCaret.getSelectionEnd() > firstCaret.getSelectionStart() || (firstCaret.getSelectionStart() == firstCaret.getSelectionEnd() && firstCaret.hasVirtualSelection() || secondCaret.getSelectionStart() == secondCaret.getSelectionEnd() && secondCaret.hasVirtualSelection()) && (firstCaret.getSelectionStart() == secondCaret.getSelectionStart() || firstCaret.getSelectionEnd() == secondCaret.getSelectionEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWithCaretMerging(Runnable runnable) {
        if (this.myPerformCaretMergingAfterCurrentOperation) {
            runnable.run();
        } else {
            this.myPerformCaretMergingAfterCurrentOperation = true;
            try {
                runnable.run();
                this.mergeOverlappingCaretsAndSelections();
            }
            finally {
                this.myPerformCaretMergingAfterCurrentOperation = false;
            }
        }
    }

    public void setCaretsAndSelections(final @NotNull List<CaretState> caretStates) {
        if (caretStates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "setCaretsAndSelections"));
        }
        this.myEditor.assertIsDispatchThread();
        if (caretStates.isEmpty()) {
            throw new IllegalArgumentException("At least one caret should exist");
        }
        this.doWithCaretMerging(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CaretImpl caret;
                int index = 0;
                int oldCaretCount = CaretModelImpl.this.myCarets.size();
                Iterator caretIterator = CaretModelImpl.this.myCarets.iterator();
                for (CaretState caretState : caretStates) {
                    boolean caretAdded;
                    if (index++ < oldCaretCount) {
                        caret = (CaretImpl)((Object)caretIterator.next());
                        caretAdded = false;
                    } else {
                        caret = new CaretImpl(CaretModelImpl.this.myEditor);
                        if (caretState != null && caretState.getCaretPosition() != null) {
                            caret.moveToLogicalPosition(caretState.getCaretPosition(), false, null, false);
                        }
                        LinkedList linkedList = CaretModelImpl.this.myCarets;
                        synchronized (linkedList) {
                            CaretModelImpl.this.myCarets.add(caret);
                        }
                        CaretModelImpl.this.fireCaretAdded(caret);
                        caretAdded = true;
                    }
                    if (caretState != null && caretState.getCaretPosition() != null && !caretAdded) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition());
                    }
                    if (caretState == null || caretState.getSelectionStart() == null || caretState.getSelectionEnd() == null) continue;
                    caret.setSelection(CaretModelImpl.this.myEditor.logicalToVisualPosition(caretState.getSelectionStart()), CaretModelImpl.this.myEditor.logicalPositionToOffset(caretState.getSelectionStart()), CaretModelImpl.this.myEditor.logicalToVisualPosition(caretState.getSelectionEnd()), CaretModelImpl.this.myEditor.logicalPositionToOffset(caretState.getSelectionEnd()));
                }
                int caretsToRemove = CaretModelImpl.this.myCarets.size() - caretStates.size();
                for (int i = 0; i < caretsToRemove; ++i) {
                    LinkedList linkedList = CaretModelImpl.this.myCarets;
                    synchronized (linkedList) {
                        caret = (CaretImpl)((Object)CaretModelImpl.this.myCarets.removeLast());
                    }
                    CaretModelImpl.this.fireCaretRemoved(caret);
                    Disposer.dispose((Disposable)caret);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        ArrayList<CaretState> states = new ArrayList<CaretState>(this.myCarets.size());
        Iterator i$ = this.myCarets.iterator();
        while (true) {
            if (!i$.hasNext()) {
                ArrayList<CaretState> arrayList = states;
                // MONITOREXIT : linkedList
                if (arrayList != null) return arrayList;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getCaretsAndSelections"));
            }
            CaretImpl caret = (CaretImpl)((Object)i$.next());
            states.add(new CaretState(caret.getLogicalPosition(), this.myEditor.visualToLogicalPosition(caret.getSelectionStartPosition()), this.myEditor.visualToLogicalPosition(caret.getSelectionEndPosition())));
        }
    }

    void fireCaretPositionChanged(CaretEvent caretEvent) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretPositionChanged(caretEvent);
    }

    void fireCaretAdded(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "fireCaretAdded"));
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretAdded(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    void fireCaretRemoved(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/CaretModelImpl", "fireCaretRemoved"));
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretRemoved(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    private static class CaretPositionComparator
    implements Comparator<Caret> {
        private static final CaretPositionComparator INSTANCE = new CaretPositionComparator();

        private CaretPositionComparator() {
        }

        @Override
        public int compare(Caret o1, Caret o2) {
            return VisualPositionComparator.INSTANCE.compare(o1.getVisualPosition(), o2.getVisualPosition());
        }
    }

    private static class VisualPositionComparator
    implements Comparator<VisualPosition> {
        private static final VisualPositionComparator INSTANCE = new VisualPositionComparator();

        private VisualPositionComparator() {
        }

        @Override
        public int compare(VisualPosition o1, VisualPosition o2) {
            if (o1.line != o2.line) {
                return o1.line - o2.line;
            }
            return o1.column - o2.column;
        }
    }
}

