/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    private final ExternalInfo myExternalInfo = new ExternalInfo();

    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme, DefaultColorSchemesManager defaultColorSchemesManager) {
        super(parentScheme, defaultColorSchemesManager);
    }

    public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
        if (attributes != this.getAttributes(key)) {
            this.myAttributesMap.put(key, attributes);
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (!Comparing.equal((Object)color, (Object)this.getColor(key))) {
            this.myColorsMap.put(key, color);
        }
    }

    public TextAttributes getAttributes(TextAttributesKey key) {
        if (key != null) {
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            TextAttributes attributes = (TextAttributes)this.myAttributesMap.get(key);
            if (fallbackKey == null) {
                if (attributes != null) {
                    return attributes;
                }
            } else {
                if (attributes != null && !attributes.isFallbackEnabled()) {
                    return attributes;
                }
                attributes = this.getFallbackAttributes(fallbackKey);
                if (attributes != null) {
                    return attributes;
                }
            }
        }
        return this.myParentScheme.getAttributes(key);
    }

    public boolean containsKey(TextAttributesKey key) {
        return this.myAttributesMap.containsKey(key);
    }

    public Color getColor(ColorKey key) {
        if (this.myColorsMap.containsKey(key)) {
            return (Color)this.myColorsMap.get(key);
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme, DefaultColorSchemesManager.getInstance());
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        return newScheme;
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "getExternalInfo"));
        }
        return externalInfo;
    }
}

