/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorSchemesManager
implements JDOMExternalizable,
NamedComponent {
    private final List<DefaultColorsScheme> mySchemes = new ArrayList<DefaultColorsScheme>();
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";

    @NotNull
    public String getComponentName() {
        if ("DefaultColorSchemesManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ex/DefaultColorSchemesManager", "getComponentName"));
        }
        return "DefaultColorSchemesManager";
    }

    public static DefaultColorSchemesManager getInstance() {
        return (DefaultColorSchemesManager)ServiceManager.getService(DefaultColorSchemesManager.class);
    }

    public void readExternal(Element element) throws InvalidDataException {
        List schemes = element.getChildren(SCHEME_ELEMENT);
        for (Object scheme : schemes) {
            Element schemeElement = (Element)scheme;
            DefaultColorsScheme newScheme = new DefaultColorsScheme(this);
            newScheme.readExternal(schemeElement);
            this.mySchemes.add(newScheme);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        throw new WriteExternalException();
    }

    public DefaultColorsScheme[] getAllSchemes() {
        return this.mySchemes.toArray(new DefaultColorsScheme[this.mySchemes.size()]);
    }

    @Nullable
    public EditorColorsScheme getScheme(String name) {
        for (DefaultColorsScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }
}

