/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.ide.CopyPasteManager;

public class StartNewLineAction
extends EditorAction {
    public StartNewLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return Handler.getEnterHandler().isEnabled(editor, dataContext);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CopyPasteManager.getInstance().stopKillRings();
            if (editor.getDocument().getLineCount() != 0) {
                editor.getSelectionModel().removeSelection();
                LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
                int lineEndOffset = editor.getDocument().getLineEndOffset(caretPosition.line);
                editor.getCaretModel().moveToOffset(lineEndOffset);
            }
            Handler.getEnterHandler().execute(editor, dataContext);
        }

        private static EditorActionHandler getEnterHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorEnter");
        }
    }
}

