/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.text.CharArrayUtil;

public class SplitLineAction
extends EditorAction {
    public static Key<Boolean> SPLIT_LINE_KEY = Key.create((String)"com.intellij.openapi.editor.actions.SplitLineAction");

    public SplitLineAction() {
        super((EditorActionHandler)new Handler());
        this.setEnabledInModalContext(false);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return Handler.getEnterHandler().isEnabled(editor, dataContext) && !((EditorEx)editor).isEmbeddedIntoDialogWrapper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CopyPasteManager.getInstance().stopKillRings();
            Document document = editor.getDocument();
            RangeMarker rangeMarker = document.createRangeMarker(editor.getCaretModel().getOffset(), editor.getCaretModel().getOffset());
            CharSequence chars = document.getCharsSequence();
            int offset = editor.getCaretModel().getOffset();
            int lineStart = document.getLineStartOffset(document.getLineNumber(offset));
            CharSequence beforeCaret = chars.subSequence(lineStart, offset);
            if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)beforeCaret)) {
                String strToInsert = "";
                if (beforeCaret != null) {
                    strToInsert = strToInsert + ((Object)beforeCaret).toString();
                }
                strToInsert = strToInsert + "\n";
                document.insertString(lineStart, (CharSequence)strToInsert);
                editor.getCaretModel().moveToOffset(offset);
            } else {
                DataManager.getInstance().saveInDataContext(dataContext, SPLIT_LINE_KEY, (Object)true);
                try {
                    Handler.getEnterHandler().execute(editor, dataContext);
                }
                finally {
                    DataManager.getInstance().saveInDataContext(dataContext, SPLIT_LINE_KEY, null);
                }
                editor.getCaretModel().moveToOffset(Math.min(document.getTextLength(), rangeMarker.getStartOffset()));
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static EditorActionHandler getEnterHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorEnter");
        }
    }
}

