/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public class SelectNextOccurrenceAction
extends EditorAction {
    protected SelectNextOccurrenceAction() {
        super((EditorActionHandler)new Handler());
    }

    static class Handler
    extends SelectOccurrencesActionHandler {
        Handler() {
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return super.isEnabled(editor, dataContext) && editor.getProject() != null && editor.getCaretModel().supportsMultipleCarets();
        }

        public void doExecute(Editor editor, @Nullable Caret c, DataContext dataContext) {
            Caret caret = c == null ? editor.getCaretModel().getPrimaryCaret() : c;
            TextRange wordSelectionRange = Handler.getSelectionRange(editor, caret);
            boolean notFoundPreviously = Handler.getAndResetNotFoundStatus(editor);
            boolean wholeWordSearch = Handler.isWholeWordSearch(editor);
            if (caret.hasSelection()) {
                Project project = editor.getProject();
                String selectedText = caret.getSelectedText();
                if (project == null || selectedText == null) {
                    return;
                }
                FindManager findManager = FindManager.getInstance((Project)project);
                FindModel model = new FindModel();
                model.setStringToFind(selectedText);
                model.setCaseSensitive(true);
                model.setWholeWordsOnly(wholeWordSearch);
                int searchStartOffset = notFoundPreviously ? 0 : caret.getSelectionEnd();
                FindResult findResult = findManager.findString(editor.getDocument().getCharsSequence(), searchStartOffset, model);
                if (findResult.isStringFound()) {
                    int newCaretOffset = caret.getOffset() - caret.getSelectionStart() + findResult.getStartOffset();
                    EditorActionUtil.makePositionVisible(editor, newCaretOffset);
                    Caret newCaret = editor.getCaretModel().addCaret(editor.offsetToVisualPosition(newCaretOffset));
                    if (newCaret == null) {
                        if (notFoundPreviously) {
                            Handler.setNotFoundStatus(editor);
                        }
                    } else {
                        Handler.setSelection(editor, newCaret, (TextRange)findResult);
                    }
                } else {
                    Handler.setNotFoundStatus(editor);
                    Handler.showHint(editor);
                }
            } else {
                if (wordSelectionRange == null) {
                    return;
                }
                Handler.setSelection(editor, caret, wordSelectionRange);
                Handler.setWholeWordSearch(editor, true);
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }
}

