/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public class SelectAllOccurrencesAction
extends EditorAction {
    protected SelectAllOccurrencesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends SelectOccurrencesActionHandler {
        private Handler() {
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return super.isEnabled(editor, dataContext) && editor.getProject() != null && editor.getCaretModel().supportsMultipleCarets();
        }

        public void doExecute(Editor editor, @Nullable Caret c, DataContext dataContext) {
            TextRange wordSelectionRange;
            Caret caret;
            Caret caret2 = caret = c == null ? editor.getCaretModel().getPrimaryCaret() : c;
            if (!caret.hasSelection() && (wordSelectionRange = Handler.getSelectionRange(editor, caret)) != null) {
                Handler.setSelection(editor, caret, wordSelectionRange);
            }
            String selectedText = caret.getSelectedText();
            Project project = editor.getProject();
            if (project == null || selectedText == null) {
                return;
            }
            int caretShiftFromSelectionStart = caret.getOffset() - caret.getSelectionStart();
            FindManager findManager = FindManager.getInstance((Project)project);
            FindModel model = new FindModel();
            model.setStringToFind(selectedText);
            model.setCaseSensitive(true);
            model.setWholeWordsOnly(true);
            int searchStartOffset = 0;
            FindResult findResult = findManager.findString(editor.getDocument().getCharsSequence(), searchStartOffset, model);
            while (findResult.isStringFound()) {
                int newCaretOffset = caretShiftFromSelectionStart + findResult.getStartOffset();
                EditorActionUtil.makePositionVisible(editor, newCaretOffset);
                Caret newCaret = editor.getCaretModel().addCaret(editor.offsetToVisualPosition(newCaretOffset));
                if (newCaret != null) {
                    Handler.setSelection(editor, newCaret, (TextRange)findResult);
                }
                findResult = findManager.findString(editor.getDocument().getCharsSequence(), findResult.getEndOffset(), model);
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }
}

