/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.ide.CopyPasteManager;

public class DeleteLineAction
extends TextComponentEditorAction {
    public DeleteLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            SelectionModel selectionModel = editor.getSelectionModel();
            Document document = editor.getDocument();
            if (selectionModel.hasSelection()) {
                int selectionStart = selectionModel.getSelectionStart();
                int selectionEnd = selectionModel.getSelectionEnd();
                selectionModel.removeSelection();
                int lineStartOffset = document.getLineStartOffset(document.getLineNumber(selectionStart));
                int nextLine = document.getLineNumber(selectionEnd);
                if (document.getLineStartOffset(nextLine) != selectionEnd) {
                    ++nextLine;
                }
                int nextLineStartOffset = nextLine == document.getLineCount() ? document.getTextLength() : Math.min(document.getTextLength(), document.getLineStartOffset(nextLine));
                document.deleteString(lineStartOffset, nextLineStartOffset);
                return;
            }
            VisualPosition position = editor.getCaretModel().getVisualPosition();
            selectionModel.selectLineAtCaret();
            boolean removeLastSymbol = selectionModel.getSelectionEnd() == document.getTextLength() && document.getLineCount() > 1;
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            if (removeLastSymbol) {
                document.deleteString(document.getTextLength() - 1, document.getTextLength());
                position = new VisualPosition(position.line - 1, position.column);
            }
            editor.getCaretModel().moveToVisualPosition(position);
        }
    }
}

