/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CutLineEndAction
extends EditorAction {
    public CutLineEndAction() {
        super((EditorActionHandler)new Handler(true));
    }

    static class Handler
    extends EditorWriteActionHandler {
        private final boolean myCopyToClipboard;

        Handler(boolean copyToClipboard) {
            this.myCopyToClipboard = copyToClipboard;
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            int end;
            int start;
            Document doc = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            if (caretOffset >= doc.getTextLength()) {
                return;
            }
            int lineNumber = doc.getLineNumber(caretOffset);
            int lineEndOffset = doc.getLineEndOffset(lineNumber);
            if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets() && caretOffset == lineEndOffset) {
                return;
            }
            if (caretOffset >= lineEndOffset) {
                start = lineEndOffset;
                end = lineEndOffset + 1;
            } else {
                start = caretOffset;
                end = lineEndOffset;
                if (lineEndOffset < doc.getTextLength() && CharArrayUtil.isEmptyOrSpaces((CharSequence)doc.getCharsSequence(), (int)caretOffset, (int)lineEndOffset)) {
                    ++end;
                }
            }
            this.delete(editor, start, end);
        }

        private void delete(@NotNull Editor editor, int start, int end) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/actions/CutLineEndAction$Handler", "delete"));
            }
            if (this.myCopyToClipboard) {
                KillRingUtil.copyToKillRing(editor, start, end, true);
            } else {
                CopyPasteManager.getInstance().stopKillRings();
            }
            editor.getDocument().deleteString(start, end);
        }
    }
}

