/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.util.ui.MacUIUtil;
import org.jetbrains.annotations.NotNull;

public class BackspaceAction
extends EditorAction {
    public BackspaceAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void doBackSpaceAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/actions/BackspaceAction", "doBackSpaceAtCaret"));
        }
        if (editor.getSelectionModel().hasSelection()) {
            int newOffset = editor.getSelectionModel().getSelectionStart();
            if (EditorActionUtil.canEditAtOffset(editor, newOffset)) {
                editor.getCaretModel().moveToOffset(newOffset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                EditorModificationUtil.deleteSelectedText((Editor)editor);
            }
            return;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int colNumber = editor.getCaretModel().getLogicalPosition().column;
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (colNumber > 0) {
            if (EditorModificationUtil.calcAfterLineEnd((Editor)editor) > 0) {
                if (EditorActionUtil.canEditAtOffset(editor, offset - 1)) {
                    int columnShift = -1;
                    editor.getCaretModel().moveCaretRelatively(columnShift, 0, false, false, true);
                }
            } else {
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
                FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
                if (region != null && region.shouldNeverExpand()) {
                    if (EditorActionUtil.canEditAtOffset(editor, region.getStartOffset())) {
                        document.deleteString(region.getStartOffset(), region.getEndOffset());
                        editor.getCaretModel().moveToOffset(region.getStartOffset());
                    }
                } else if (EditorActionUtil.canEditAtOffset(editor, offset - 1)) {
                    document.deleteString(offset - 1, offset);
                    editor.getCaretModel().moveToOffset(offset - 1, true);
                }
            }
        } else if (lineNumber > 0) {
            int separatorLength = document.getLineSeparatorLength(lineNumber - 1);
            int lineEnd = document.getLineEndOffset(lineNumber - 1) + separatorLength;
            if (EditorActionUtil.canEditAtOffset(editor, lineEnd - separatorLength)) {
                document.deleteString(lineEnd - separatorLength, lineEnd);
                editor.getCaretModel().moveToOffset(lineEnd - separatorLength);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                commandProcessor.setCurrentCommandGroupId(null);
            }
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            SelectionModel selectionModel;
            MacUIUtil.hideCursor();
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            if ((selectionModel = editor.getSelectionModel()).hasBlockSelection()) {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                int column = Math.min(start.column, end.column);
                int startLine = Math.min(start.line, end.line);
                int endLine = Math.max(start.line, end.line);
                EditorModificationUtil.deleteBlockSelection((Editor)editor);
                if (column > 0 && start.column == end.column) {
                    for (int i = startLine; i <= endLine; ++i) {
                        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, column));
                        BackspaceAction.doBackSpaceAtCaret(editor);
                    }
                    --column;
                }
                int newColumn = Math.max(column, 0);
                selectionModel.setBlockSelection(new LogicalPosition(startLine, newColumn), new LogicalPosition(endLine, newColumn));
                return;
            }
            BackspaceAction.doBackSpaceAtCaret(editor);
        }
    }
}

