/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.fragments.LineBlock;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.splitter.Interval;
import com.intellij.openapi.diff.impl.splitter.LinearTransformation;
import com.intellij.openapi.diff.impl.splitter.Trapezium;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineBlocks {
    public static final LineBlocks EMPTY = new LineBlocks(Collections.<Diff>emptyList());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.splitter.LineBlocks");
    private final List<Diff> myDiffs;

    private LineBlocks(List<Diff> diffs) {
        this.myDiffs = diffs;
    }

    public Interval getVisibleIndices(Trapezium visibleArea) {
        Interval visible1 = visibleArea.getBase1();
        Interval visible2 = visibleArea.getBase2();
        Interval[] intervals1 = this.getIntervals(FragmentSide.SIDE1);
        Interval[] intervals2 = this.getIntervals(FragmentSide.SIDE2);
        int index = Math.min(LineBlocks.getMaxStartedIndex(intervals1, visible1.getStart()), LineBlocks.getMaxStartedIndex(intervals2, visible2.getStart()));
        int lastIndex = Math.max(LineBlocks.getMinNotStartedIndex(intervals1, visible1.getEnd()), LineBlocks.getMinNotStartedIndex(intervals2, visible2.getEnd()));
        return Interval.fromTo(index, lastIndex);
    }

    public Trapezium getTrapezium(int index) {
        return new Trapezium(this.getIntervals(FragmentSide.SIDE1)[index], this.getIntervals(FragmentSide.SIDE2)[index]);
    }

    public TextDiffType getType(int index) {
        return this.myDiffs.get(index).getDiffType();
    }

    public int getCount() {
        return this.getBeginnings(FragmentSide.SIDE1).length;
    }

    public int[] getBeginnings(FragmentSide side) {
        return this.getBeginnings(side, false);
    }

    public int[] getBeginnings(FragmentSide side, boolean unappliedOnly) {
        ArrayList<Integer> result = new ArrayList<Integer>(this.myDiffs.size());
        int previousBeginning = Integer.MIN_VALUE;
        for (Diff diff : this.myDiffs) {
            if (unappliedOnly && diff.getDiffType().isApplied()) continue;
            Interval interval = diff.getInterval(side);
            int start = interval.getStart();
            if (start != previousBeginning) {
                result.add(start);
            }
            previousBeginning = start;
        }
        return ArrayUtil.toIntArray(result);
    }

    static int getMaxStartedIndex(Interval[] intervals, int start) {
        int index;
        for (int i = index = LineBlocks.getMinIndex(intervals, start, Interval.START_COMPARATOR); i > 0; --i) {
            if (intervals[i - 1].getEnd() > start) continue;
            return i;
        }
        return 0;
    }

    static int getMinNotStartedIndex(Interval[] intervals, int end) {
        int index;
        for (int i = index = LineBlocks.getMinIndex(intervals, end, Interval.END_COMPARATOR); i < intervals.length; ++i) {
            if (intervals[i].getStart() < end) continue;
            return i;
        }
        return intervals.length;
    }

    private static int getMinIndex(Interval[] intervals, int start, Comparator comparator) {
        int index = Arrays.binarySearch(intervals, new Integer(start), comparator);
        return index >= 0 ? index : -index - 1;
    }

    public int transform(FragmentSide masterSide, int location) {
        return this.transform(location, this.getIntervals(masterSide), this.getIntervals(masterSide.otherSide()));
    }

    public Interval[] getIntervals(FragmentSide side) {
        Interval[] intervals = new Interval[this.myDiffs.size()];
        for (int i = 0; i < intervals.length; ++i) {
            intervals[i] = this.myDiffs.get(i).getInterval(side);
        }
        return intervals;
    }

    public TextDiffType[] getTypes() {
        TextDiffType[] types = new TextDiffType[this.myDiffs.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.myDiffs.get(i).getDiffType();
        }
        return types;
    }

    private int transform(int location, Interval[] domain, Interval[] range) {
        Interval rightInterval;
        Interval leftInterval;
        if (domain.length == 0) {
            if (range.length != 0) {
                LOG.error("" + range.length);
            }
            return location;
        }
        int count = this.getIntervals(FragmentSide.SIDE1).length;
        LOG.assertTrue(count == this.getIntervals(FragmentSide.SIDE2).length);
        int index = LineBlocks.getMaxStartedIndex(domain, location);
        if (index == 0) {
            if (domain[0].contains(location)) {
                leftInterval = domain[0];
                rightInterval = range[0];
            } else {
                leftInterval = Interval.fromTo(0, domain[0].getStart());
                rightInterval = Interval.fromTo(0, range[0].getStart());
            }
        } else if (index == count) {
            leftInterval = Interval.toInf(domain[count - 1].getEnd());
            rightInterval = Interval.toInf(range[count - 1].getEnd());
        } else if (domain[index].contains(location)) {
            leftInterval = domain[index];
            rightInterval = range[index];
        } else {
            leftInterval = Interval.fromTo(domain[index - 1].getEnd(), domain[index].getStart());
            rightInterval = Interval.fromTo(range[index - 1].getEnd(), range[index].getStart());
        }
        return LinearTransformation.oneToOne(location, leftInterval.getStart(), rightInterval);
    }

    public static LineBlocks fromLineFragments(List<LineFragment> lines) {
        ArrayList<LineFragment> filtered = new ArrayList<LineFragment>();
        for (LineFragment fragment : lines) {
            if (fragment.getType() == null) continue;
            filtered.add(fragment);
        }
        return LineBlocks.createLineBlocks(filtered.toArray(new LineBlock[filtered.size()]));
    }

    static LineBlocks createLineBlocks(LineBlock[] blocks) {
        Arrays.sort(blocks, LineBlock.COMPARATOR);
        ArrayList<Diff> diffs = new ArrayList<Diff>(blocks.length);
        for (LineBlock block : blocks) {
            Interval interval1 = new Interval(block.getStartingLine1(), block.getModifiedLines1());
            Interval interval2 = new Interval(block.getStartingLine2(), block.getModifiedLines2());
            diffs.add(new Diff(interval1, interval2, LineBlocks.makeTextDiffType(block)));
        }
        return new LineBlocks(diffs);
    }

    private static TextDiffType makeTextDiffType(LineBlock block) {
        TextDiffType type = TextDiffType.create(block.getType());
        if (block instanceof LineFragment) {
            return DiffUtil.makeTextDiffType((LineFragment)block);
        }
        return type;
    }

    @NotNull
    public static LineBlocks fromChanges(@NotNull List<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/splitter/LineBlocks", "fromChanges"));
        }
        Collections.sort(changes, ChangeList.CHANGE_ORDER);
        ArrayList<Diff> diffs = new ArrayList<Diff>(changes.size());
        for (Change change : changes) {
            if (!change.isValid()) continue;
            int start1 = change.getChangeSide(FragmentSide.SIDE1).getStartLine();
            int end1 = change.getChangeSide(FragmentSide.SIDE1).getEndLine();
            Interval interval1 = Interval.fromTo(start1, end1);
            int start2 = change.getChangeSide(FragmentSide.SIDE2).getStartLine();
            int end2 = change.getChangeSide(FragmentSide.SIDE2).getEndLine();
            Interval interval2 = Interval.fromTo(start2, end2);
            diffs.add(new Diff(interval1, interval2, change.getType().getTypeKey()));
        }
        LineBlocks lineBlocks = new LineBlocks(diffs);
        if (lineBlocks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/splitter/LineBlocks", "fromChanges"));
        }
        return lineBlocks;
    }

    private static class Diff {
        @NotNull
        private final Interval myIntervalForSide1;
        @NotNull
        private final Interval myIntervalForSide2;
        @NotNull
        private final TextDiffType myDiffType;

        private Diff(@NotNull Interval intervalForSide1, @NotNull Interval intervalForSide2, @NotNull TextDiffType type) {
            if (intervalForSide1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/splitter/LineBlocks$Diff", "<init>"));
            }
            if (intervalForSide2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/splitter/LineBlocks$Diff", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/splitter/LineBlocks$Diff", "<init>"));
            }
            this.myIntervalForSide1 = intervalForSide1;
            this.myIntervalForSide2 = intervalForSide2;
            this.myDiffType = type;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = this.myDiffType;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/splitter/LineBlocks$Diff", "getDiffType"));
            }
            return textDiffType;
        }

        public Interval getInterval(FragmentSide side) {
            return side == FragmentSide.SIDE1 ? this.myIntervalForSide1 : this.myIntervalForSide2;
        }
    }
}

