/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diff.impl.settings.DiffMergeEditorSetting;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettings;
import com.intellij.openapi.editor.Editor;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffMergeSettingsAction
extends AnAction {
    @NotNull
    private final Collection<Editor> myEditors;
    @NotNull
    private final ActionGroup myActionGroup;
    @NotNull
    private final DiffMergeSettings mySettings;

    public DiffMergeSettingsAction(@NotNull Collection<Editor> editors, @NotNull DiffMergeSettings settings) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction", "<init>"));
        }
        super(AllIcons.General.Gear);
        this.myEditors = editors;
        this.mySettings = settings;
        this.myActionGroup = new MergeToolActionGroup();
    }

    public void actionPerformed(AnActionEvent e) {
        InputEvent inputEvent = e.getInputEvent();
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", this.myActionGroup);
        int x = 0;
        int y = 0;
        if (inputEvent instanceof MouseEvent) {
            x = ((MouseEvent)inputEvent).getX();
            y = ((MouseEvent)inputEvent).getY();
        }
        popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
    }

    private static class DiffMergeToggleAction
    extends ToggleAction {
        @NotNull
        private final DiffMergeEditorSetting mySetting;
        @NotNull
        private final Collection<Editor> myEditors;
        @NotNull
        private final DiffMergeSettings mySettings;

        private DiffMergeToggleAction(@NotNull String actionId, @NotNull DiffMergeEditorSetting setting, @NotNull Collection<Editor> editors, @NotNull DiffMergeSettings settings) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction$DiffMergeToggleAction", "<init>"));
            }
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction$DiffMergeToggleAction", "<init>"));
            }
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction$DiffMergeToggleAction", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction$DiffMergeToggleAction", "<init>"));
            }
            super(ActionsBundle.actionText((String)actionId), ActionsBundle.actionDescription((String)actionId), null);
            this.mySetting = setting;
            this.myEditors = editors;
            this.mySettings = settings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.getPreference(this.mySetting);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.setPreference(this.mySetting, state);
            for (Editor editor : this.myEditors) {
                this.mySetting.apply(editor, state);
            }
        }

        private void setPreference(DiffMergeEditorSetting preference, boolean state) {
            this.mySettings.setPreference(preference, state);
        }

        private boolean getPreference(DiffMergeEditorSetting preference) {
            return this.mySettings.getPreference(preference);
        }
    }

    private class MergeToolActionGroup
    extends ActionGroup {
        private MergeToolActionGroup() {
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new DiffMergeToggleAction("EditorToggleShowWhitespaces", DiffMergeEditorSetting.WHITESPACES, DiffMergeSettingsAction.this.myEditors, DiffMergeSettingsAction.this.mySettings), new DiffMergeToggleAction("EditorToggleShowLineNumbers", DiffMergeEditorSetting.LINE_NUMBERS, DiffMergeSettingsAction.this.myEditors, DiffMergeSettingsAction.this.mySettings), new DiffMergeToggleAction("EditorToggleShowIndentLines", DiffMergeEditorSetting.INDENT_LINES, DiffMergeSettingsAction.this.myEditors, DiffMergeSettingsAction.this.mySettings), new DiffMergeToggleAction("EditorToggleUseSoftWraps", DiffMergeEditorSetting.SOFT_WRAPS, DiffMergeSettingsAction.this.myEditors, DiffMergeSettingsAction.this.mySettings)};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction$MergeToolActionGroup", "getChildren"));
            }
            return anActionArray;
        }
    }
}

