/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwoSideChange<T extends SideChange>
extends ChangeSide
implements DiffRangeMarker.RangeInvalidListener {
    @NotNull
    protected final MergeList myMergeList;
    @NotNull
    protected DiffRangeMarker myBaseRangeMarker;
    protected T myLeftChange;
    protected T myRightChange;
    @NotNull
    protected final ChangeHighlighterHolder myCommonHighlighterHolder;

    protected TwoSideChange(@NotNull TextRange baseRange, @NotNull MergeList mergeList, @NotNull ChangeHighlighterHolder highlighterHolder) {
        if (baseRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "<init>"));
        }
        if (mergeList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "<init>"));
        }
        if (highlighterHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "<init>"));
        }
        this.myBaseRangeMarker = new DiffRangeMarker((DocumentEx)mergeList.getBaseDocument(), baseRange, this);
        this.myMergeList = mergeList;
        this.myCommonHighlighterHolder = highlighterHolder;
    }

    @Override
    @NotNull
    public ChangeHighlighterHolder getHighlighterHolder() {
        ChangeHighlighterHolder changeHighlighterHolder = this.myCommonHighlighterHolder;
        if (changeHighlighterHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "getHighlighterHolder"));
        }
        return changeHighlighterHolder;
    }

    @Override
    @NotNull
    public DiffRangeMarker getRange() {
        DiffRangeMarker diffRangeMarker = this.myBaseRangeMarker;
        if (diffRangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "getRange"));
        }
        return diffRangeMarker;
    }

    @Nullable
    public Change getLeftChange() {
        return this.myLeftChange;
    }

    @Nullable
    public Change getRightChange() {
        return this.myRightChange;
    }

    public void setRange(@NotNull DiffRangeMarker range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "setRange"));
        }
        this.myBaseRangeMarker = range;
    }

    @Nullable
    T getOtherChange(@NotNull T change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "getOtherChange"));
        }
        if (change == this.myLeftChange) {
            return this.myRightChange;
        }
        if (change == this.myRightChange) {
            return this.myLeftChange;
        }
        throw new IllegalStateException("Unexpected change: " + change);
    }

    public void removeOtherChange(@NotNull T change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "removeOtherChange"));
        }
        if (change == this.myLeftChange) {
            this.myRightChange = null;
        } else if (change == this.myRightChange) {
            this.myLeftChange = null;
        } else {
            throw new IllegalStateException("Unexpected change: " + change);
        }
    }

    public void conflictRemoved() {
        TwoSideChange.removeHighlighters(this.myLeftChange);
        TwoSideChange.removeHighlighters(this.myRightChange);
        this.myCommonHighlighterHolder.removeHighlighters();
        this.myMergeList.removeChanges((Change)this.myLeftChange, (Change)this.myRightChange);
        this.myBaseRangeMarker.removeListener(this);
    }

    private static <T extends SideChange> void removeHighlighters(@Nullable T change) {
        if (change != null) {
            change.getOriginalSide().getHighlighterHolder().removeHighlighters();
        }
    }

    @NotNull
    public Document getOriginalDocument(FragmentSide mergeSide) {
        Document document = this.myMergeList.getChanges(mergeSide).getDocument(MergeList.BRANCH_SIDE);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "getOriginalDocument"));
        }
        return document;
    }

    @Override
    public void onRangeInvalidated() {
        this.conflictRemoved();
    }

    @NotNull
    public MergeList getMergeList() {
        MergeList mergeList = this.myMergeList;
        if (mergeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange", "getMergeList"));
        }
        return mergeList;
    }

    protected static abstract class SideChange<V extends TwoSideChange>
    extends Change
    implements DiffRangeMarker.RangeInvalidListener {
        protected V myTwoSideChange;
        @NotNull
        protected final ChangeList myChangeList;
        protected Change.SimpleChangeSide myOriginalSide;
        @NotNull
        protected ChangeType myType;

        protected SideChange(@NotNull V twoSideChange, @NotNull ChangeList changeList, @NotNull ChangeType type, @NotNull FragmentSide mergeSide, @NotNull TextRange versionRange) {
            if (twoSideChange == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "<init>"));
            }
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "<init>"));
            }
            if (mergeSide == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "<init>"));
            }
            if (versionRange == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "<init>"));
            }
            this.myTwoSideChange = twoSideChange;
            this.myChangeList = changeList;
            this.myOriginalSide = new Change.SimpleChangeSide(mergeSide, new DiffRangeMarker((DocumentEx)((TwoSideChange)twoSideChange).getOriginalDocument(mergeSide), versionRange, this));
            this.myType = type;
        }

        @Override
        @NotNull
        public ChangeType getType() {
            ChangeType changeType = this.myType;
            if (changeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "getType"));
            }
            return changeType;
        }

        public Change.SimpleChangeSide getOriginalSide() {
            return this.myOriginalSide;
        }

        protected void markApplied() {
            this.myType = ChangeType.deriveApplied(this.myType);
            this.myChangeList.apply(this);
            this.myOriginalSide.getHighlighterHolder().updateHighlighter(this.myOriginalSide, this.myType);
            this.myOriginalSide.getHighlighterHolder().setActions(new AnAction[0]);
            ((TwoSideChange)this.myTwoSideChange).getHighlighterHolder().updateHighlighter((ChangeSide)this.myTwoSideChange, this.myType);
        }

        @Override
        public ChangeList getChangeList() {
            return ((TwoSideChange)this.myTwoSideChange).getMergeList().getChanges(this.myOriginalSide.getFragmentSide());
        }

        @Override
        protected void changeSide(ChangeSide sideToChange, DiffRangeMarker newRange) {
            ((TwoSideChange)this.myTwoSideChange).setRange(newRange);
        }

        @Override
        @NotNull
        public ChangeSide getChangeSide(@NotNull FragmentSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "getChangeSide"));
            }
            Change.SimpleChangeSide simpleChangeSide = SideChange.isBranch(side) ? this.myOriginalSide : this.myTwoSideChange;
            if (simpleChangeSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "getChangeSide"));
            }
            return simpleChangeSide;
        }

        protected static boolean isBranch(@NotNull FragmentSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange", "isBranch"));
            }
            return MergeList.BRANCH_SIDE == side;
        }

        @Override
        protected void removeFromList() {
            ((TwoSideChange)this.myTwoSideChange).conflictRemoved();
            this.myTwoSideChange = null;
        }

        @Override
        public boolean isValid() {
            return this.myTwoSideChange != null;
        }

        @Override
        public void onRemovedFromList() {
            this.myOriginalSide.getRange().removeListener(this);
            this.myTwoSideChange = null;
            this.myOriginalSide = null;
        }

        @Override
        public void onRangeInvalidated() {
            this.removeFromList();
        }
    }
}

