/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeNoConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.TwoSideChange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class NoConflictChange
extends TwoSideChange.SideChange<MergeNoConflict> {
    private static final Logger LOG = Logger.getInstance(NoConflictChange.class);
    private boolean myApplied;

    public NoConflictChange(@NotNull MergeNoConflict twoSideChange, @NotNull FragmentSide mergeSide, @NotNull TextRange baseRange, @NotNull TextRange versionRange, @NotNull ChangeList changeList) {
        if (twoSideChange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/NoConflictChange", "<init>"));
        }
        if (mergeSide == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/incrementalMerge/NoConflictChange", "<init>"));
        }
        if (baseRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/incrementalMerge/NoConflictChange", "<init>"));
        }
        if (versionRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/impl/incrementalMerge/NoConflictChange", "<init>"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/diff/impl/incrementalMerge/NoConflictChange", "<init>"));
        }
        super(twoSideChange, changeList, ChangeType.fromRanges(baseRange, versionRange), mergeSide, versionRange);
    }

    @Override
    public void onApplied() {
        this.markApplied();
        NoConflictChange otherChange = ((MergeNoConflict)this.myTwoSideChange).getOtherChange(this);
        LOG.assertTrue(otherChange != null, (Object)String.format("Other change is null. This change: %s Merge conflict: %s", this, this.myTwoSideChange));
        otherChange.markApplied();
    }

    @Override
    protected void markApplied() {
        if (!this.myApplied) {
            this.myApplied = true;
            super.markApplied();
        }
    }
}

