/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.impl.external.BaseExternalTool;
import com.intellij.openapi.diff.impl.external.ContentExternalizer;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.LocalFileExternalizer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

class ExtCompareFolders
extends BaseExternalTool {
    public static final BaseExternalTool INSTANCE = new ExtCompareFolders();

    private ExtCompareFolders() {
        super(DiffManagerImpl.ENABLE_FOLDERS, DiffManagerImpl.FOLDERS_TOOL);
    }

    @Override
    public boolean isAvailable(DiffRequest request) {
        DiffContent[] contents = request.getContents();
        if (contents.length != 2) {
            return false;
        }
        if (this.externalize(request, 0) == null) {
            return false;
        }
        return this.externalize(request, 1) != null;
    }

    @Override
    @Nullable
    protected ContentExternalizer externalize(DiffRequest request, int index) {
        VirtualFile file = request.getContents()[index].getFile();
        if (!ExtCompareFolders.isLocalDirectory(file)) {
            return null;
        }
        return LocalFileExternalizer.tryCreate(file);
    }

    private static boolean isLocalDirectory(VirtualFile file) {
        VirtualFile local = ExtCompareFolders.getLocalFile(file);
        return local != null && local.isDirectory();
    }
}

