/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.BaseExternalTool;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.LocalFileExternalizer;
import com.intellij.openapi.vfs.VirtualFile;

class ExtCompareFiles
extends BaseExternalTool {
    public static final BaseExternalTool INSTANCE = new ExtCompareFiles();

    private ExtCompareFiles() {
        super(DiffManagerImpl.ENABLE_FILES, DiffManagerImpl.FILES_TOOL);
    }

    @Override
    public boolean isAvailable(DiffRequest request) {
        DiffContent[] contents;
        for (DiffContent content : contents = request.getContents()) {
            VirtualFile file = ExtCompareFiles.getLocalFile(content.getFile());
            if (file != null && file.isDirectory()) {
                return false;
            }
            if (LocalFileExternalizer.canExternalizeAsFile(file) || !DiffUtil.isWritable(content)) continue;
            return false;
        }
        if (contents.length != 2) {
            return false;
        }
        if (this.externalize(request, 0) == null) {
            return false;
        }
        return this.externalize(request, 1) != null;
    }
}

