/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.external.BinaryDiffTool;
import com.intellij.openapi.diff.impl.external.CompositeDiffTool;
import com.intellij.openapi.diff.impl.external.ExtCompareFiles;
import com.intellij.openapi.diff.impl.external.ExtCompareFolders;
import com.intellij.openapi.diff.impl.external.ExtMergeFiles;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.diff.impl.external.MultiLevelDiffTool;
import com.intellij.openapi.diff.impl.mergeTool.MergeTool;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.StringProperty;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffManagerImpl
extends DiffManager
implements JDOMExternalizable {
    public static final int FULL_DIFF_DIVIDER_POLYGONS_OFFSET = 3;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.DiffManagerImpl");
    private static final Externalizer<String> TOOL_PATH_UPDATE = new Externalizer<String>(){
        @NonNls
        private static final String NEW_VALUE = "newValue";

        public String readValue(Element dataElement) {
            String path = dataElement.getAttributeValue(NEW_VALUE);
            if (path != null) {
                return path;
            }
            String prevValue = dataElement.getAttributeValue("value");
            return prevValue != null ? prevValue.trim() : null;
        }

        public void writeValue(Element dataElement, String path) {
            dataElement.setAttribute("value", path);
            dataElement.setAttribute(NEW_VALUE, path);
        }
    };
    static final StringProperty FOLDERS_TOOL = new StringProperty("foldersTool", "");
    static final StringProperty FILES_TOOL = new StringProperty("filesTool", "");
    static final StringProperty MERGE_TOOL = new StringProperty("mergeTool", "");
    static final StringProperty MERGE_TOOL_PARAMETERS = new StringProperty("mergeToolParameters", "");
    static final BooleanProperty ENABLE_FOLDERS = new BooleanProperty("enableFolders", false);
    static final BooleanProperty ENABLE_FILES = new BooleanProperty("enableFiles", false);
    static final BooleanProperty ENABLE_MERGE = new BooleanProperty("enableMerge", false);
    private final ExternalizablePropertyContainer myProperties;
    private final ArrayList<DiffTool> myAdditionTools = new ArrayList();
    public static final DiffTool INTERNAL_DIFF = new FrameDiffTool();
    public static final Key<Boolean> EDITOR_IS_DIFF_KEY = new Key("EDITOR_IS_DIFF_KEY");
    private static final MarkupEditorFilter DIFF_EDITOR_FILTER = new MarkupEditorFilter(){

        public boolean avaliableIn(Editor editor) {
            return editor.getUserData(EDITOR_IS_DIFF_KEY) != null;
        }
    };
    private ComparisonPolicy myComparisonPolicy;
    private HighlightMode myHighlightMode;
    @NonNls
    public static final String COMPARISON_POLICY_ATTR_NAME = "COMPARISON_POLICY";
    @NonNls
    public static final String HIGHLIGHT_MODE_ATTR_NAME = "HIGHLIGHT_MODE";

    public DiffManagerImpl() {
        this.myProperties = new ExternalizablePropertyContainer();
        this.myProperties.registerProperty(ENABLE_FOLDERS);
        this.myProperties.registerProperty((AbstractProperty)FOLDERS_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(ENABLE_FILES);
        this.myProperties.registerProperty((AbstractProperty)FILES_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(ENABLE_MERGE);
        this.myProperties.registerProperty((AbstractProperty)MERGE_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(MERGE_TOOL_PARAMETERS);
    }

    public DiffTool getIdeaDiffTool() {
        return INTERNAL_DIFF;
    }

    public DiffTool getDiffTool() {
        DiffTool[] standardTools;
        if (!(ENABLE_FILES.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && ENABLE_FOLDERS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && ENABLE_MERGE.value((AbstractProperty.AbstractPropertyContainer)this.myProperties))) {
            DiffTool[] embeddableTools = new DiffTool[]{INTERNAL_DIFF, new MergeTool(), BinaryDiffTool.INSTANCE};
            standardTools = new DiffTool[]{ExtCompareFolders.INSTANCE, ExtCompareFiles.INSTANCE, ExtMergeFiles.INSTANCE, new MultiLevelDiffTool(Arrays.asList(embeddableTools)), INTERNAL_DIFF, new MergeTool(), BinaryDiffTool.INSTANCE};
        } else {
            standardTools = new DiffTool[]{ExtCompareFolders.INSTANCE, ExtCompareFiles.INSTANCE, ExtMergeFiles.INSTANCE, INTERNAL_DIFF, new MergeTool(), BinaryDiffTool.INSTANCE};
        }
        ArrayList<DiffTool> allTools = new ArrayList<DiffTool>(this.myAdditionTools);
        allTools.addAll(Arrays.asList(standardTools));
        return new CompositeDiffTool(allTools);
    }

    public boolean registerDiffTool(@NotNull DiffTool tool) throws NullPointerException {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "registerDiffTool"));
        }
        if (this.myAdditionTools.contains(tool)) {
            return false;
        }
        this.myAdditionTools.add(tool);
        return true;
    }

    public void unregisterDiffTool(DiffTool tool) {
        this.myAdditionTools.remove(tool);
        LOG.assertTrue(!this.myAdditionTools.contains(tool));
    }

    public MarkupEditorFilter getDiffEditorFilter() {
        return DIFF_EDITOR_FILTER;
    }

    public DiffPanel createDiffPanel(Window window, Project project, DiffTool parentTool) {
        return new DiffPanelImpl(window, project, true, true, 3, parentTool);
    }

    public DiffPanel createDiffPanel(Window window, Project project, @NotNull Disposable parentDisposable, DiffTool parentTool) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "createDiffPanel"));
        }
        DiffPanel diffPanel = this.createDiffPanel(window, project, parentTool);
        Disposer.register((Disposable)parentDisposable, (Disposable)diffPanel);
        return diffPanel;
    }

    public static DiffManagerImpl getInstanceEx() {
        return (DiffManagerImpl)DiffManager.getInstance();
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "readExternal"));
        }
        this.myProperties.readExternal(element);
        this.readPolicy(element);
        this.readMode(element);
    }

    private void readPolicy(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "readPolicy"));
        }
        String policyName = element.getAttributeValue(COMPARISON_POLICY_ATTR_NAME);
        if (policyName != null) {
            ComparisonPolicy[] policies;
            for (ComparisonPolicy policy : policies = ComparisonPolicy.getAllInstances()) {
                if (!policy.getName().equals(policyName)) continue;
                this.myComparisonPolicy = policy;
                break;
            }
        }
    }

    private void readMode(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "readMode"));
        }
        String modeName = element.getAttributeValue(HIGHLIGHT_MODE_ATTR_NAME);
        if (modeName != null) {
            try {
                this.myHighlightMode = HighlightMode.valueOf((String)modeName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "writeExternal"));
        }
        this.myProperties.writeExternal(element);
        if (this.myComparisonPolicy != null) {
            element.setAttribute(COMPARISON_POLICY_ATTR_NAME, this.myComparisonPolicy.getName());
        }
        if (this.myHighlightMode != null) {
            element.setAttribute(HIGHLIGHT_MODE_ATTR_NAME, this.myHighlightMode.name());
        }
    }

    public AbstractProperty.AbstractPropertyContainer getProperties() {
        return this.myProperties;
    }

    static DiffPanel createDiffPanel(DiffRequest data, Window window, @NotNull Disposable parentDisposable, FrameDiffTool tool) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/external/DiffManagerImpl", "createDiffPanel"));
        }
        DiffPanel diffPanel = null;
        try {
            diffPanel = DiffManager.getInstance().createDiffPanel(window, data.getProject(), parentDisposable, (DiffTool)tool);
            int contentCount = data.getContents().length;
            LOG.assertTrue(contentCount == 2, (Object)String.valueOf(contentCount));
            LOG.assertTrue(data.getContentTitles().length == contentCount);
            diffPanel.setDiffRequest(data);
            return diffPanel;
        }
        catch (RuntimeException e) {
            if (diffPanel != null) {
                Disposer.dispose(diffPanel);
            }
            throw e;
        }
    }

    public void setComparisonPolicy(ComparisonPolicy p) {
        this.myComparisonPolicy = p;
    }

    @Nullable
    public ComparisonPolicy getComparisonPolicy() {
        return this.myComparisonPolicy;
    }

    public void setHighlightMode(HighlightMode highlightMode) {
        this.myHighlightMode = highlightMode;
    }

    @Nullable
    public HighlightMode getHighlightMode() {
        return this.myHighlightMode;
    }
}

