/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiffLineMarkerRenderer
implements LineMarkerRenderer {
    @NotNull
    private final TextDiffType myDiffType;

    @NotNull
    public static DiffLineMarkerRenderer createInstance(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer", "createInstance"));
        }
        DiffLineMarkerRenderer diffLineMarkerRenderer = new DiffLineMarkerRenderer(diffType);
        if (diffLineMarkerRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer", "createInstance"));
        }
        return diffLineMarkerRenderer;
    }

    private DiffLineMarkerRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer", "<init>"));
        }
        this.myDiffType = diffType;
    }

    public void paint(Editor editor, Graphics g, Rectangle range) {
        Color color = this.myDiffType.getPolygonColor(editor);
        if (color == null) {
            return;
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = range.y;
        int width = gutter.getWidth();
        int height = range.height;
        if (!this.myDiffType.isApplied()) {
            if (height > 2) {
                g.setColor(color);
                g.fillRect(x, y, width, height);
                DiffUtil.drawDoubleShadowedLine(g2, x, x + width, y - 1, color);
                DiffUtil.drawDoubleShadowedLine(g2, x, x + width, y + height - 1, color);
            } else {
                DiffUtil.drawDoubleShadowedLine(g2, x, x + width, y - 1, color);
            }
        } else {
            DiffUtil.drawBoldDottedFramingLines(g2, x, x + width, y - 1, y + height - 1, color);
        }
    }
}

