/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.compiler.impl.packagingCompiler.BuildRecipeImpl;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.make.BuildRecipe;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentUtilImpl
extends DeploymentUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.deployment.MakeUtilImpl");

    public void copyFile(@NotNull File fromFile, @NotNull File toFile, @NotNull CompileContext context, @Nullable Set<String> writtenPaths, @Nullable FileFilter fileFilter) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/deployment/DeploymentUtilImpl", "copyFile"));
        }
        if (toFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/deployment/DeploymentUtilImpl", "copyFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/deployment/DeploymentUtilImpl", "copyFile"));
        }
        if (fileFilter != null && !fileFilter.accept(fromFile)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping " + fromFile.getAbsolutePath() + ": it wasn't accepted by filter " + fileFilter);
            }
            return;
        }
        DeploymentUtilImpl.checkPathDoNotNavigatesUpFromFile(fromFile);
        DeploymentUtilImpl.checkPathDoNotNavigatesUpFromFile(toFile);
        if (fromFile.isDirectory()) {
            File[] fromFiles = fromFile.listFiles();
            toFile.mkdirs();
            for (File file : fromFiles) {
                this.copyFile(file, new File(toFile, file.getName()), context, writtenPaths, fileFilter);
            }
            return;
        }
        if (toFile.isDirectory()) {
            context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"message.text.destination.is.directory", (Object[])new Object[]{DeploymentUtilImpl.createCopyErrorMessage(fromFile, toFile)}), null, -1, -1);
            return;
        }
        if (FileUtil.filesEqual((File)fromFile, (File)toFile) || writtenPaths != null && !writtenPaths.add(toFile.getPath())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping " + fromFile.getAbsolutePath() + ": " + toFile.getAbsolutePath() + " is already written");
            }
            return;
        }
        if (!FileUtil.isFilePathAcceptable((File)toFile, (FileFilter)fileFilter)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping " + fromFile.getAbsolutePath() + ": " + toFile.getAbsolutePath() + " wasn't accepted by filter " + fileFilter);
            }
            return;
        }
        context.getProgressIndicator().setText("Copying files");
        context.getProgressIndicator().setText2(fromFile.getPath());
        try {
            File canonicalFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copy file '" + fromFile + "' to '" + toFile + "'");
            }
            if (toFile.exists() && !SystemInfo.isFileSystemCaseSensitive && !(canonicalFile = toFile.getCanonicalFile()).getAbsolutePath().equals(toFile.getAbsolutePath())) {
                FileUtil.delete((File)toFile);
            }
            FileUtil.copy((File)fromFile, (File)toFile);
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, DeploymentUtilImpl.createCopyErrorMessage(fromFile, toFile) + ": " + e.getLocalizedMessage(), null, -1, -1);
        }
    }

    private static void checkPathDoNotNavigatesUpFromFile(File file) {
        String filepath;
        File filepart;
        String path = file.getPath();
        int i = path.indexOf("..");
        if (i != -1 && (filepart = new File(filepath = path.substring(0, i - 1))).exists() && !filepart.isDirectory()) {
            LOG.error("Incorrect file path: '" + path + '\'');
        }
    }

    private static String createCopyErrorMessage(File fromFile, File toFile) {
        return CompilerBundle.message((String)"message.text.error.copying.file.to.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)fromFile.getPath()), FileUtil.toSystemDependentName((String)toFile.getPath())});
    }

    public final boolean addItemsRecursively(@NotNull BuildRecipe items, @NotNull File root, String outputRelativePath) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/deployment/DeploymentUtilImpl", "addItemsRecursively"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/deployment/DeploymentUtilImpl", "addItemsRecursively"));
        }
        if (outputRelativePath == null) {
            outputRelativePath = "";
        }
        outputRelativePath = DeploymentUtilImpl.trimForwardSlashes((String)outputRelativePath);
        items.addFileCopyInstruction(root, true, outputRelativePath);
        return true;
    }

    public void reportDeploymentDescriptorDoesNotExists(ConfigFile descriptor, CompileContext context, Module module) {
        String description = ModuleType.get((Module)module).getName() + " '" + module.getName() + '\'';
        String descriptorPath = VfsUtil.urlToPath((String)descriptor.getUrl());
        String message = CompilerBundle.message((String)"message.text.compiling.item.deployment.descriptor.could.not.be.found", (Object[])new Object[]{description, descriptorPath});
        context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
    }

    public void checkConfigFile(ConfigFile descriptor, CompileContext compileContext, Module module) {
        if (new File(VfsUtil.urlToPath((String)descriptor.getUrl())).exists()) {
            String message = this.getConfigFileErrorMessage(descriptor);
            if (message != null) {
                String moduleDescription = ModuleType.get((Module)module).getName() + " '" + module.getName() + '\'';
                compileContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"message.text.compiling.module.message", (Object[])new Object[]{moduleDescription, message}), descriptor.getUrl(), -1, -1);
            }
        } else {
            DeploymentUtil.getInstance().reportDeploymentDescriptorDoesNotExists(descriptor, compileContext, module);
        }
    }

    public BuildRecipe createBuildRecipe() {
        return new BuildRecipeImpl();
    }

    @Nullable
    public String getConfigFileErrorMessage(ConfigFile configFile) {
        XmlDocument document;
        if (configFile.getVirtualFile() == null) {
            String path = FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configFile.getUrl()));
            return CompilerBundle.message((String)"mesage.text.deployment.descriptor.file.not.exist", (Object[])new Object[]{path});
        }
        PsiFile psiFile = configFile.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return CompilerBundle.message((String)"message.text.deployment.description.invalid.file", (Object[])new Object[0]);
        }
        if (psiFile instanceof XmlFile && ((document = ((XmlFile)psiFile).getDocument()) == null || document.getRootTag() == null)) {
            return CompilerBundle.message((String)"message.text.xml.file.invalid", (Object[])new Object[]{FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configFile.getUrl()))});
        }
        return null;
    }
}

