/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionListener;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashMap;
import gnu.trove.TObjectLongHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementStorage
implements StateStorage,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.XmlElementStorage");
    @NonNls
    private static final String ATTR_NAME = "name";
    private static final String VERSION_FILE_SUFFIX = ".ver";
    protected TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    @NotNull
    private final String myRootElementName;
    private Object mySession;
    private StorageData myLoadedData;
    protected final StreamProvider myStreamProvider;
    protected final String myFileSpec;
    private final ComponentRoamingManager myComponentRoamingManager;
    protected boolean myBlockSavingTheContent;
    protected int myUpToDateHash;
    protected int myProviderUpToDateHash;
    private boolean mySavingDisabled;
    private final Map<String, Object> myStorageComponentStates;
    private final ComponentVersionProvider myLocalVersionProvider;
    protected final RemoteComponentVersionProvider myRemoteVersionProvider;
    protected ComponentVersionListener myListener;
    private boolean myDisposed;

    protected XmlElementStorage(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull Disposable parentDisposable, @NotNull String rootElementName, @Nullable StreamProvider streamProvider, String fileSpec, ComponentRoamingManager componentRoamingManager, ComponentVersionProvider localComponentVersionsProvider) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        this.myBlockSavingTheContent = false;
        this.myUpToDateHash = -1;
        this.myProviderUpToDateHash = -1;
        this.mySavingDisabled = false;
        this.myStorageComponentStates = new THashMap();
        this.myListener = new ComponentVersionListener(){

            @Override
            public void componentStateChanged(String componentName) {
                XmlElementStorage.this.myLocalVersionProvider.changeVersion(componentName, System.currentTimeMillis());
            }
        };
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        this.myRootElementName = rootElementName;
        this.myStreamProvider = streamProvider;
        this.myFileSpec = fileSpec;
        this.myComponentRoamingManager = componentRoamingManager;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLocalVersionProvider = localComponentVersionsProvider;
        this.myRemoteVersionProvider = streamProvider == null || !streamProvider.isVersioningRequired() ? null : new RemoteComponentVersionProvider();
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    @Nullable
    protected abstract Document loadDocument() throws StateStorageException;

    @Nullable
    public synchronized Element getState(String componentName) throws StateStorageException {
        StorageData storageData = this.getStorageData(false);
        Element state = storageData.getState(componentName);
        if (state != null) {
            if (!this.myStorageComponentStates.containsKey(componentName)) {
                this.myStorageComponentStates.put(componentName, state);
            }
            storageData.removeState(componentName);
        }
        return state;
    }

    public boolean hasState(Object component, String componentName, Class<?> aClass, boolean reloadData) throws StateStorageException {
        return this.getStorageData(reloadData).hasState(componentName);
    }

    @Nullable
    public <T> T getState(Object component, String componentName, Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        return DefaultStateSerializer.deserializeState(this.getState(componentName), stateClass, mergeInto);
    }

    @NotNull
    protected StorageData getStorageData(boolean reloadData) throws StateStorageException {
        if (this.myLoadedData != null && !reloadData) {
            StorageData storageData = this.myLoadedData;
            if (storageData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
            }
            return storageData;
        }
        StorageData storageData = this.myLoadedData = this.loadData(true);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
        }
        return storageData;
    }

    @NotNull
    protected StorageData loadData(boolean useProvidersData) throws StateStorageException {
        Document document = this.loadDocument();
        StorageData result = this.createStorageData();
        if (document != null) {
            this.loadState(result, document.getRootElement());
        }
        if (useProvidersData && this.myStreamProvider != null && this.myStreamProvider.isEnabled()) {
            for (RoamingType roamingType : RoamingType.values()) {
                if (roamingType == RoamingType.DISABLED || roamingType == RoamingType.GLOBAL) continue;
                try {
                    Document sharedDocument = StorageUtil.loadDocument(this.myStreamProvider.loadContent(this.myFileSpec, roamingType));
                    if (sharedDocument == null) continue;
                    this.filterOutOfDate(sharedDocument.getRootElement());
                    this.loadState(result, sharedDocument.getRootElement());
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        StorageData storageData = result;
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadData"));
        }
        return storageData;
    }

    protected void loadState(StorageData result, Element element) throws StateStorageException {
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element);
        }
        IdeaPluginDescriptorImpl.internJDOMElement(element);
        try {
            result.load(element);
            result.checkUnknownMacros(this.myPathMacroSubstitutor);
        }
        catch (IOException e) {
            throw new StateStorageException((Throwable)e);
        }
    }

    @NotNull
    protected StorageData createStorageData() {
        StorageData storageData = new StorageData(this.myRootElementName);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "createStorageData"));
        }
        return storageData;
    }

    public void setDefaultState(Element element) {
        this.myLoadedData = this.createStorageData();
        try {
            this.loadState(this.myLoadedData, element);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        MyExternalizationSession myExternalizationSession;
        try {
            MyExternalizationSession session = new MyExternalizationSession(this.getStorageData(false).clone(), this.myListener);
            this.mySession = session;
            myExternalizationSession = session;
        }
        catch (StateStorageException e) {
            throw new RuntimeException(e);
        }
        if (myExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "startExternalization"));
        }
        return myExternalizationSession;
    }

    @NotNull
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "startSave"));
        }
        LOG.assertTrue(this.mySession == externalizationSession);
        StateStorage.SaveSession saveSession = this.mySavingDisabled ? XmlElementStorage.createNullSession() : this.createSaveSession((MyExternalizationSession)externalizationSession);
        this.mySession = saveSession;
        StateStorage.SaveSession saveSession2 = saveSession;
        if (saveSession2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "startSave"));
        }
        return saveSession2;
    }

    private static StateStorage.SaveSession createNullSession() {
        return new StateStorage.SaveSession(){

            public void save() throws StateStorageException {
            }

            public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> changedFiles) {
                if (changedFiles == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage$2", "analyzeExternalChanges"));
                }
                return Collections.emptySet();
            }

            @NotNull
            public Collection<IFile> getStorageFilesToSave() throws StateStorageException {
                Set<IFile> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage$2", "getStorageFilesToSave"));
                }
                return set;
            }

            @NotNull
            public List<IFile> getAllStorageFiles() {
                List<IFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage$2", "getAllStorageFiles"));
                }
                return list;
            }
        };
    }

    protected abstract MySaveSession createSaveSession(MyExternalizationSession var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSave(@NotNull StateStorage.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "finishSave"));
        }
        try {
            if (this.mySession != saveSession) {
                LOG.error("mySession=" + this.mySession + " saveSession=" + saveSession);
            }
        }
        finally {
            this.mySession = null;
        }
    }

    public void disableSaving() {
        this.mySavingDisabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getDocument(StorageData data) {
        Element element = data.save();
        if (this.myPathMacroSubstitutor != null) {
            try {
                this.myPathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.myPathMacroSubstitutor.reset();
            }
        }
        return new Document(element);
    }

    private TObjectLongHashMap<String> loadVersions(List<Element> elements) {
        TObjectLongHashMap result = new TObjectLongHashMap();
        for (Element component : elements) {
            long version;
            String name = component.getAttributeValue(ATTR_NAME);
            if (name == null || (version = this.myLocalVersionProvider.getVersion(name)) <= 0L) continue;
            result.put((Object)name, version);
        }
        return result;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public void resetData() {
        this.myLoadedData = null;
    }

    public void reload(@NotNull Set<String> changedComponents) throws StateStorageException {
        if (changedComponents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "reload"));
        }
        StorageData storageData = this.loadData(false);
        StorageData oldLoadedData = this.myLoadedData;
        if (oldLoadedData != null) {
            HashSet<String> componentsToRetain = new HashSet<String>(oldLoadedData.myComponentStates.keySet());
            componentsToRetain.addAll(changedComponents);
            for (String componentToRetain : componentsToRetain) {
                if (storageData.myComponentStates.containsKey(componentToRetain) || !this.myStorageComponentStates.containsKey(componentToRetain)) continue;
                Element emptyElement = new Element("component");
                LOG.info("Create empty component element for " + componentsToRetain);
                emptyElement.setAttribute(ATTR_NAME, componentToRetain);
                storageData.myComponentStates.put(componentToRetain, emptyElement);
            }
            storageData.myComponentStates.keySet().retainAll(componentsToRetain);
        }
        this.myLoadedData = storageData;
    }

    private void filterOutOfDate(Element element) {
        if (this.myRemoteVersionProvider == null) {
            return;
        }
        Iterator iterator = element.getContent((Filter)new ElementFilter("component")).iterator();
        while (iterator.hasNext()) {
            String name = ((Element)iterator.next()).getAttributeValue(ATTR_NAME);
            long remoteVersion = this.myRemoteVersionProvider.getVersion(name);
            if (remoteVersion <= this.myLocalVersionProvider.getVersion(name)) {
                iterator.remove();
                continue;
            }
            this.myLocalVersionProvider.changeVersion(name, remoteVersion);
        }
    }

    @Nullable
    Document logComponents() throws StateStorageException {
        return this.mySession instanceof MySaveSession ? this.getDocument(((MySaveSession)this.mySession).myStorageData) : null;
    }

    protected class RemoteComponentVersionProvider
    implements ComponentVersionProvider {
        protected TObjectLongHashMap<String> myProviderVersions;

        protected RemoteComponentVersionProvider() {
        }

        @Override
        public long getVersion(String name) {
            if (this.myProviderVersions == null) {
                this.loadProviderVersions();
            }
            return this.myProviderVersions == null ? -1L : this.myProviderVersions.get((Object)name);
        }

        @Override
        public void changeVersion(String name, long version) {
            if (this.myProviderVersions == null) {
                this.loadProviderVersions();
            }
            if (this.myProviderVersions != null) {
                this.myProviderVersions.put((Object)name, version);
            }
        }

        private void loadProviderVersions() {
            assert (XmlElementStorage.this.myStreamProvider != null);
            if (!XmlElementStorage.this.myStreamProvider.isEnabled()) {
                return;
            }
            this.myProviderVersions = new TObjectLongHashMap();
            for (RoamingType type : RoamingType.values()) {
                try {
                    Document doc = StorageUtil.loadDocument(XmlElementStorage.this.myStreamProvider.loadContent(XmlElementStorage.this.myFileSpec + XmlElementStorage.VERSION_FILE_SUFFIX, type));
                    if (doc == null) continue;
                    StateStorageManagerImpl.loadComponentVersions(this.myProviderVersions, doc);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    protected abstract class MySaveSession
    implements StateStorage.SaveSession,
    SafeWriteRequestor {
        final StorageData myStorageData;
        private Document myDocumentToSave;

        public MySaveSession(MyExternalizationSession externalizationSession) {
            this.myStorageData = externalizationSession.myStorageData;
        }

        public final boolean needsSave() throws StateStorageException {
            assert (XmlElementStorage.this.mySession == this);
            return this._needsSave(this.calcHash());
        }

        private boolean _needsSave(int hash) {
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return false;
            }
            if (XmlElementStorage.this.myUpToDateHash == -1) {
                if (hash != -1) {
                    if (!this.physicalContentNeedsSave()) {
                        XmlElementStorage.this.myUpToDateHash = hash;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            if (hash != -1) {
                if (hash == XmlElementStorage.this.myUpToDateHash) {
                    return false;
                }
                if (!this.physicalContentNeedsSave()) {
                    XmlElementStorage.this.myUpToDateHash = hash;
                    return false;
                }
                return true;
            }
            return this.physicalContentNeedsSave();
        }

        protected boolean physicalContentNeedsSave() {
            return true;
        }

        protected abstract void doSave() throws StateStorageException;

        protected int calcHash() {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void save() throws StateStorageException {
            block10: {
                assert (XmlElementStorage.this.mySession == this);
                if (XmlElementStorage.this.myBlockSavingTheContent) {
                    return;
                }
                int hash = this.calcHash();
                try {
                    if (XmlElementStorage.this.myStreamProvider == null || !XmlElementStorage.this.myStreamProvider.isEnabled() || XmlElementStorage.this.myProviderUpToDateHash != -1 && XmlElementStorage.this.myProviderUpToDateHash == hash) break block10;
                    try {
                        if (this.saveForProvider(XmlElementStorage.this.myStreamProvider)) {
                            return;
                        }
                    }
                    finally {
                        XmlElementStorage.this.myProviderUpToDateHash = hash;
                    }
                }
                finally {
                    this.saveLocally(hash);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveLocally(Integer hash) {
            try {
                if (!this.isHashUpToDate(hash) && this._needsSave(hash)) {
                    this.doSave();
                }
            }
            finally {
                XmlElementStorage.this.myUpToDateHash = hash;
            }
        }

        private boolean saveForProvider(@NotNull StreamProvider streamProvider) {
            if (streamProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage$MySaveSession", "saveForProvider"));
            }
            if (!streamProvider.isApplicable(XmlElementStorage.this.myFileSpec, RoamingType.PER_USER)) {
                return false;
            }
            Document document = this.getDocumentToSave();
            Element rootElement = document.getRootElement();
            if (rootElement.getChildren().isEmpty()) {
                return false;
            }
            if (!XmlElementStorage.this.myFileSpec.equals("$WORKSPACE_FILE$") && rootElement.getContent((Filter)new RoamingElementFilter(RoamingType.DISABLED)).iterator().hasNext()) {
                return false;
            }
            RoamingElementFilter perPlatformFilter = new RoamingElementFilter(RoamingType.PER_PLATFORM);
            if (rootElement.getContent((Filter)perPlatformFilter).iterator().hasNext()) {
                return this.doSaveForProvider(rootElement, new RoamingElementFilter(RoamingType.PER_USER)) || this.doSaveForProvider(rootElement, perPlatformFilter);
            }
            return this.doSaveForProvider(document, RoamingType.PER_USER, streamProvider);
        }

        private boolean doSaveForProvider(Element element, RoamingElementFilter filter) {
            Element copiedElement = JDOMUtil.cloneElement((Element)element, (ElementFilter)filter);
            return copiedElement != null && this.doSaveForProvider(new Document(copiedElement), filter.myRoamingType, XmlElementStorage.this.myStreamProvider);
        }

        private boolean doSaveForProvider(Document actualDocument, RoamingType roamingType, StreamProvider streamProvider) {
            try {
                TObjectLongHashMap versions;
                boolean result = StorageUtil.doSendContent(streamProvider, XmlElementStorage.this.myFileSpec, actualDocument, roamingType, true);
                if (streamProvider.isVersioningRequired() && !(versions = XmlElementStorage.this.loadVersions(actualDocument.getRootElement().getChildren("component"))).isEmpty()) {
                    Document versionDoc = new Document(StateStorageManagerImpl.createComponentVersionsXml((TObjectLongHashMap<String>)versions));
                    StorageUtil.doSendContent(streamProvider, XmlElementStorage.this.myFileSpec + XmlElementStorage.VERSION_FILE_SUFFIX, versionDoc, roamingType, true);
                }
                return result;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return false;
            }
        }

        private boolean isHashUpToDate(Integer hash) {
            return XmlElementStorage.this.myUpToDateHash != -1 && XmlElementStorage.this.myUpToDateHash == hash;
        }

        protected Document getDocumentToSave() {
            if (this.myDocumentToSave != null) {
                return this.myDocumentToSave;
            }
            Element element = this.myStorageData.save();
            this.myDocumentToSave = new Document(element);
            if (XmlElementStorage.this.myPathMacroSubstitutor != null) {
                XmlElementStorage.this.myPathMacroSubstitutor.collapsePaths(element);
            }
            return this.myDocumentToSave;
        }

        public StorageData getData() {
            return this.myStorageData;
        }

        @Nullable
        public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            if (changedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage$MySaveSession", "analyzeExternalChanges"));
            }
            try {
                Document document = XmlElementStorage.this.loadDocument();
                StorageData storageData = XmlElementStorage.this.createStorageData();
                if (document == null) {
                    return Collections.emptySet();
                }
                XmlElementStorage.this.loadState(storageData, document.getRootElement());
                return storageData.getDifference(this.myStorageData, XmlElementStorage.this.myPathMacroSubstitutor);
            }
            catch (StateStorageException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }

        private class RoamingElementFilter
        extends ElementFilter {
            final RoamingType myRoamingType;

            public RoamingElementFilter(RoamingType roamingType) {
                super("component");
                this.myRoamingType = roamingType;
            }

            public boolean matches(Object obj) {
                return super.matches(obj) && XmlElementStorage.this.myComponentRoamingManager.getRoamingType(((Element)obj).getAttributeValue(XmlElementStorage.ATTR_NAME)) == this.myRoamingType;
            }
        }
    }

    protected class MyExternalizationSession
    implements StateStorage.ExternalizationSession {
        private final StorageData myStorageData;
        private final ComponentVersionListener myListener;

        public MyExternalizationSession(StorageData storageData, ComponentVersionListener listener) {
            this.myStorageData = storageData;
            this.myListener = listener;
        }

        public void setState(@NotNull Object component, String componentName, @NotNull Object state, Storage storageSpec) throws StateStorageException {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/XmlElementStorage$MyExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/XmlElementStorage$MyExternalizationSession", "setState"));
            }
            assert (XmlElementStorage.this.mySession == this);
            try {
                this.setState(componentName, DefaultStateSerializer.serializeState(state, storageSpec));
            }
            catch (WriteExternalException e) {
                LOG.debug((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void setState(String componentName, Element element) {
            if (element.getAttributes().isEmpty() && element.getChildren().isEmpty()) {
                return;
            }
            this.myStorageData.setState(componentName, element);
            int hash = JDOMUtil.getTreeHash((Element)element);
            try {
                Object oldElementState = XmlElementStorage.this.myStorageComponentStates.get(componentName);
                if (oldElementState instanceof Element && !JDOMUtil.areElementsEqual((Element)((Element)oldElementState), (Element)element) || oldElementState instanceof Integer && hash != (Integer)oldElementState) {
                    this.myListener.componentStateChanged(componentName);
                }
            }
            finally {
                XmlElementStorage.this.myStorageComponentStates.put(componentName, hash);
            }
        }
    }
}

