/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.UniqueFileNamesProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.StorageUtil");
    private static final boolean DUMP_COMPONENT_STATES = SystemProperties.getBooleanProperty((String)"idea.log.externally.changed.component.states", (boolean)false);
    private static final SimpleDateFormat LOG_DIR_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    private StorageUtil() {
    }

    public static void notifyUnknownMacros(@NotNull TrackingPathMacroSubstitutor substitutor, final @NotNull Project project, @Nullable String componentName) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        final LinkedHashSet<String> macros = new LinkedHashSet<String>(substitutor.getUnknownMacros(componentName));
        if (macros.isEmpty()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                macros.removeAll(StorageUtil.getMacrosFromExistingNotifications(project));
                if (!macros.isEmpty()) {
                    String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
                    String productName = ApplicationNamesInfo.getInstance().getProductName();
                    String content = String.format(format, StringUtil.join((Collection)macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
                    new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil$1$1", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StorageUtil$1$1", "hyperlinkUpdate"));
                            }
                            ((ProjectEx)project).checkUnknownMacros(true);
                        }
                    }, macros).notify(project);
                }
            }
        });
    }

    private static List<String> getMacrosFromExistingNotifications(Project project) {
        ArrayList notified = ContainerUtil.newArrayList();
        NotificationsManager manager = NotificationsManager.getNotificationsManager();
        for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, project)) {
            notified.addAll(notification.getMacros());
        }
        return notified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static VirtualFile save(@NotNull IFile file, Parent element, Object requestor) throws StateStorageException {
        VirtualFile virtualFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "save"));
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        Pair<String, String> pair = StorageUtil.loadFile(vFile);
        String text = JDOMUtil.writeParent((Parent)element, (String)((String)pair.second));
        if (file.exists()) {
            if (text.equals(pair.first)) {
                return null;
            }
        } else {
            file.createParentDirs();
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
        try {
            VirtualFile virtualFile2 = StorageUtil.getOrCreateVirtualFile(requestor, file);
            byte[] bytes = text.getBytes("UTF-8");
            virtualFile2.setBinaryContent(bytes, -1L, -1L, requestor);
            virtualFile = virtualFile2;
        }
        catch (Throwable throwable) {
            try {
                token.finish();
                throw throwable;
            }
            catch (IOException e) {
                throw new StateStorageException((Throwable)e);
            }
        }
        token.finish();
        return virtualFile;
    }

    @NotNull
    static VirtualFile getOrCreateVirtualFile(Object requestor, IFile ioFile) throws IOException {
        VirtualFile vFile = StorageUtil.getVirtualFile(ioFile);
        if (vFile == null) {
            vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
        }
        if (vFile == null) {
            IFile parentFile = ioFile.getParentFile();
            VirtualFile parentVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
            if (parentVFile == null) {
                throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile.getPath()}));
            }
            vFile = parentVFile.createChildData(requestor, ioFile.getName());
        }
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        return virtualFile;
    }

    @Nullable
    static VirtualFile getVirtualFile(IFile ioFile) {
        return LocalFileSystem.getInstance().findFileByIoFile(ioFile);
    }

    private static Pair<String, String> loadFile(@Nullable VirtualFile file) throws IOException {
        String fileText;
        if (file == null || !file.exists()) {
            return Pair.create(null, (Object)SystemProperties.getLineSeparator());
        }
        int index = (fileText = new String(file.contentsToByteArray(), "UTF-8")).indexOf(10);
        return Pair.create((Object)fileText, (Object)(index == -1 ? SystemProperties.getLineSeparator() : (index - 1 >= 0 ? (fileText.charAt(index - 1) == '\r' ? "\r\n" : "\n") : "\n")));
    }

    public static boolean contentEquals(@NotNull Document document, @NotNull VirtualFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "contentEquals"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StorageUtil", "contentEquals"));
        }
        try {
            Pair<String, String> pair = StorageUtil.loadFile(file);
            return pair.first != null && ((String)pair.first).equals(JDOMUtil.writeDocument((Document)document, (String)((String)pair.second)));
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static boolean contentEquals(@NotNull Element element, @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "contentEquals"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StorageUtil", "contentEquals"));
        }
        try {
            Pair<String, String> pair = StorageUtil.loadFile(file);
            return pair.first != null && ((String)pair.first).equals(StorageUtil.printElement(element, (String)pair.second));
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    static String printElement(Element element, String lineSeparator) throws StateStorageException {
        return JDOMUtil.writeElement((Element)element, (String)lineSeparator);
    }

    @Nullable
    public static Document loadDocument(byte[] bytes) {
        try {
            return bytes == null || bytes.length == 0 ? null : JDOMUtil.loadDocument((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (JDOMException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document loadDocument(@Nullable InputStream stream) {
        Document document;
        if (stream == null) {
            return null;
        }
        try {
            document = JDOMUtil.loadDocument((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (JDOMException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        stream.close();
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferExposingByteArrayOutputStream documentToBytes(@NotNull Document document, boolean useSystemLineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "documentToBytes"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, CharsetToolkit.UTF8_CHARSET);
        try {
            JDOMUtil.writeDocument((Document)document, (Writer)writer, (String)(useSystemLineSeparator ? SystemProperties.getLineSeparator() : "\n"));
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = out;
            return bufferExposingByteArrayOutputStream;
        }
        finally {
            writer.close();
        }
    }

    public static boolean sendContent(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull Document copy, @NotNull RoamingType type, boolean async) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (!provider.isApplicable(fileSpec, type)) {
            return false;
        }
        try {
            return StorageUtil.doSendContent(provider, fileSpec, copy, type, async);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public static void deleteContent(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull RoamingType type) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteContent"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteContent"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteContent"));
        }
        if (provider.isApplicable(fileSpec, type)) {
            provider.deleteFile(fileSpec, type);
        }
    }

    public static boolean doSendContent(StreamProvider provider, String fileSpec, Document copy, RoamingType type, boolean async) throws IOException {
        BufferExposingByteArrayOutputStream content = StorageUtil.documentToBytes(copy, false);
        return provider.saveContent(fileSpec, content.getInternalBuffer(), content.size(), type, async);
    }

    public static void logStateDiffInfo(Set<Pair<VirtualFile, StateStorage>> changedFiles, Set<String> componentNames) {
        if (componentNames.isEmpty() || !DUMP_COMPONENT_STATES && !ApplicationManager.getApplication().isInternal()) {
            return;
        }
        try {
            File logDirectory = StorageUtil.createLogDirectory();
            if (!logDirectory.mkdirs()) {
                throw new IOException("Cannot create " + logDirectory);
            }
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                Document state;
                File file = new File(((VirtualFile)pair.first).getPath());
                StateStorage storage = (StateStorage)pair.second;
                if (storage instanceof XmlElementStorage && (state = ((XmlElementStorage)storage).logComponents()) != null) {
                    File logFile = new File(logDirectory, "prev_" + file.getName());
                    JDOMUtil.writeDocument((Document)state, (File)logFile, (String)"\n");
                }
                if (!file.exists()) continue;
                File logFile = new File(logDirectory, "new_" + file.getName());
                FileUtil.copy((File)file, (File)logFile);
            }
            File logFile = new File(logDirectory, "components.txt");
            FileUtil.writeToFile((File)logFile, (String)(componentNames.toString() + "\n"));
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    private static File createLogDirectory() {
        UniqueFileNamesProvider namesProvider = new UniqueFileNamesProvider();
        File statesDir = new File(PathManager.getSystemPath(), "log/componentStates");
        File[] children = statesDir.listFiles();
        if (children != null) {
            if (children.length > 10) {
                File childToDelete = null;
                for (File child : children) {
                    if (childToDelete != null && childToDelete.lastModified() <= child.lastModified()) continue;
                    childToDelete = child;
                }
                if (childToDelete != null) {
                    FileUtil.delete(childToDelete);
                }
            }
            for (File child : children) {
                namesProvider.reserveFileName(child.getName());
            }
        }
        String name = "state-" + LOG_DIR_FORMAT.format(new Date()) + "-" + ApplicationInfo.getInstance().getBuild().asString();
        return new File(statesDir, namesProvider.suggestName(name));
    }

    public static boolean isProjectOrModuleFile(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageUtil", "isProjectOrModuleFile"));
        }
        return "$PROJECT_FILE$".equals(fileSpec) || fileSpec.startsWith("$PROJECT_CONFIG_DIR$") || fileSpec.equals("$MODULE_FILE$");
    }
}

