/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageAnnotationsDefaultValues;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.CompoundExternalizationSession;
import com.intellij.openapi.components.impl.stores.CompoundSaveSession;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.OldStreamProviderAdapter;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CurrentUserHolder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class StateStorageManagerImpl
implements StateStorageManager,
Disposable,
ComponentVersionProvider {
    private static final Logger LOG = Logger.getInstance(StateStorageManagerImpl.class);
    private static final boolean ourHeadlessEnvironment;
    private final Map<String, String> myMacros = new LinkedHashMap<String, String>();
    private final Lock myStorageLock = new ReentrantLock();
    private final Map<String, StateStorage> myStorages = new THashMap();
    private final Map<String, StateStorage> myPathToStorage = new THashMap();
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final String myRootTagName;
    private Object mySession;
    private final PicoContainer myPicoContainer;
    private TObjectLongHashMap<String> myComponentVersions;
    private final Object myComponentVersionsLock = new Object();
    private String myVersionsFilePath;
    private boolean isDirty;
    private StreamProvider myStreamProvider;
    private final OldStreamProviderManager myOldStreamProvider = new OldStreamProviderManager();
    private static final Pattern MACRO_PATTERN;

    public StateStorageManagerImpl(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, String rootTagName, @Nullable Disposable parentDisposable, PicoContainer picoContainer) {
        this.myPicoContainer = picoContainer;
        this.myRootTagName = rootTagName;
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    @Override
    public TrackingPathMacroSubstitutor getMacroSubstitutor() {
        return this.myPathMacroSubstitutor;
    }

    @Override
    public synchronized void addMacro(String macro, String expansion) {
        this.myMacros.put(("$" + macro + "$").intern(), expansion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorageException {
        if (storageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        String key = StateStorageManagerImpl.getStorageSpecId(storageSpec);
        this.myStorageLock.lock();
        try {
            StateStorage stateStorage = this.myStorages.get(key);
            if (stateStorage == null) {
                stateStorage = this.createStateStorage(storageSpec);
                this.putStorageToMap(key, stateStorage);
            }
            StateStorage stateStorage2 = stateStorage;
            return stateStorage2;
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StateStorage getFileStateStorage(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getFileStateStorage"));
        }
        this.myStorageLock.lock();
        try {
            StateStorage stateStorage = this.myStorages.get(fileName);
            if (stateStorage == null) {
                stateStorage = this.createFileStateStorage(fileName);
                this.putStorageToMap(fileName, stateStorage);
            }
            StateStorage stateStorage2 = stateStorage;
            return stateStorage2;
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getStorageFileNames() {
        this.myStorageLock.lock();
        try {
            if (this.myStorages.isEmpty()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(this.myStorages.keySet());
            return collection;
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    private void putStorageToMap(String key, StateStorage stateStorage) {
        if (stateStorage != null) {
            if (stateStorage instanceof FileBasedStorage) {
                String filePath = ((FileBasedStorage)stateStorage).getFilePath();
                if (this.myPathToStorage.containsKey(filePath)) {
                    StateStorage existing = this.myPathToStorage.get(filePath);
                    this.myStorages.put(key, existing);
                } else {
                    this.myPathToStorage.put(filePath, stateStorage);
                    this.myStorages.put(key, stateStorage);
                }
            } else {
                this.myStorages.put(key, stateStorage);
            }
        }
    }

    @Nullable
    private StateStorage createStateStorage(Storage storageSpec) throws StateStorageException {
        if (!storageSpec.storageClass().equals(StorageAnnotationsDefaultValues.NullStateStorage.class)) {
            String key = UUID.randomUUID().toString();
            ((MutablePicoContainer)this.myPicoContainer).registerComponentImplementation((Object)key, storageSpec.storageClass());
            return (StateStorage)this.myPicoContainer.getComponentInstance((Object)key);
        }
        if (!storageSpec.stateSplitter().equals(StorageAnnotationsDefaultValues.NullStateSplitter.class)) {
            return this.createDirectoryStateStorage(storageSpec.file(), storageSpec.stateSplitter());
        }
        return this.createFileStateStorage(storageSpec.file());
    }

    private static String getStorageSpecId(Storage storageSpec) {
        if (!storageSpec.storageClass().equals(StorageAnnotationsDefaultValues.NullStateStorage.class)) {
            return storageSpec.storageClass().getName();
        }
        return storageSpec.file();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStateStorage(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "clearStateStorage"));
        }
        this.myStorageLock.lock();
        try {
            this.myStorages.remove(file);
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    @Nullable
    private StateStorage createDirectoryStateStorage(String file, Class<? extends StateSplitter> splitterClass) throws StateStorageException {
        StateSplitter splitter;
        String expandedFile = this.expandMacros(file);
        if (expandedFile == null) {
            this.myStorages.put(file, null);
            return null;
        }
        try {
            splitter = splitterClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new StateStorageException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StateStorageException((Throwable)e);
        }
        return new DirectoryBasedStorage(this.myPathMacroSubstitutor, expandedFile, splitter, this, this.myPicoContainer);
    }

    @Nullable
    private StateStorage createFileStateStorage(final @NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createFileStateStorage"));
        }
        String expandedFile = this.expandMacros(fileSpec);
        if (expandedFile == null) {
            this.myStorages.put(fileSpec, null);
            return null;
        }
        String extension = FileUtilRt.getExtension((String)new File(expandedFile).getName());
        if (!ourHeadlessEnvironment && extension.isEmpty()) {
            throw new IllegalArgumentException("Extension is missing for storage file: " + expandedFile);
        }
        return new FileBasedStorage(this.getMacroSubstitutor(fileSpec), this.getStreamProvider(), expandedFile, fileSpec, this.myRootTagName, this, this.myPicoContainer, ComponentRoamingManager.getInstance(), this){

            @Override
            @NotNull
            protected StorageData createStorageData() {
                StorageData storageData = StateStorageManagerImpl.this.createStorageData(fileSpec);
                if (storageData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$1", "createStorageData"));
                }
                return storageData;
            }
        };
    }

    @Override
    public long getVersion(String name) {
        return this.getComponentVersions().get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVersionsFilePath(String newPath) {
        this.myVersionsFilePath = newPath;
        Object object = this.myComponentVersionsLock;
        synchronized (object) {
            this.myComponentVersions = null;
        }
        this.isDirty = false;
    }

    private TObjectLongHashMap<String> loadVersions() {
        TObjectLongHashMap result = new TObjectLongHashMap();
        String filePath = this.getNotNullVersionsFilePath();
        if (filePath != null) {
            try {
                Document document = JDOMUtil.loadDocument((File)new File(filePath));
                StateStorageManagerImpl.loadComponentVersions((TObjectLongHashMap<String>)result, document);
            }
            catch (JDOMException e) {
                LOG.debug((Throwable)e);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return result;
    }

    private String getNotNullVersionsFilePath() {
        if (this.myVersionsFilePath == null) {
            this.myVersionsFilePath = this.getVersionsFilePath();
        }
        return this.myVersionsFilePath;
    }

    public static void loadComponentVersions(TObjectLongHashMap<String> result, Document document) {
        List componentObjects = document.getRootElement().getChildren("component");
        for (Element component : componentObjects) {
            String name = component.getAttributeValue("name");
            String version = component.getAttributeValue("version");
            if (name == null || version == null) continue;
            try {
                result.put((Object)name, Long.parseLong(version));
            }
            catch (NumberFormatException ignored) {}
        }
    }

    protected abstract String getVersionsFilePath();

    @Override
    public void changeVersion(String name, long version) {
        this.getComponentVersions().put((Object)name, version);
        this.isDirty = true;
    }

    @Override
    @Nullable
    public StreamProvider getStreamProvider() {
        return (StreamProvider)ObjectUtils.chooseNotNull((Object)this.myStreamProvider, (Object)this.myOldStreamProvider);
    }

    protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getMacroSubstitutor"));
        }
        return this.myPathMacroSubstitutor;
    }

    protected abstract StorageData createStorageData(String var1);

    @Override
    @Nullable
    public synchronized String expandMacros(String file) {
        Matcher matcher = MACRO_PATTERN.matcher(file);
        while (matcher.find()) {
            String m = matcher.group(1);
            if (this.myMacros.containsKey(m) && (ApplicationManager.getApplication().isUnitTestMode() || this.myMacros.get(m) != null)) continue;
            throw new IllegalArgumentException("Unknown macro: " + m + " in storage spec: " + file);
        }
        String actualFile = file;
        for (String macro : this.myMacros.keySet()) {
            String replacement = this.myMacros.get(macro);
            if (replacement == null) continue;
            actualFile = StringUtil.replace((String)actualFile, (String)macro, (String)replacement);
        }
        return actualFile;
    }

    @Override
    @NotNull
    public StateStorageManager.ExternalizationSession startExternalization() {
        if (this.mySession != null) {
            LOG.error("Starting duplicate externalization session: " + this.mySession);
        }
        MyExternalizationSession session = new MyExternalizationSession();
        this.mySession = session;
        MyExternalizationSession myExternalizationSession = session;
        if (myExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "startExternalization"));
        }
        return myExternalizationSession;
    }

    @Override
    @NotNull
    public StateStorageManager.SaveSession startSave(@NotNull StateStorageManager.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "startSave"));
        }
        assert (this.mySession == externalizationSession);
        MySaveSession session = this.createSaveSession(externalizationSession);
        this.mySession = session;
        MySaveSession mySaveSession = session;
        if (mySaveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "startSave"));
        }
        return mySaveSession;
    }

    @NotNull
    protected MySaveSession createSaveSession(StateStorageManager.ExternalizationSession externalizationSession) {
        MySaveSession mySaveSession = new MySaveSession((MyExternalizationSession)externalizationSession);
        if (mySaveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createSaveSession"));
        }
        return mySaveSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSave(@NotNull StateStorageManager.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "finishSave"));
        }
        try {
            assert (this.mySession == saveSession) : "mySession=" + this.mySession + " saveSession=" + saveSession;
            ((MySaveSession)saveSession).finishSave();
        }
        finally {
            this.mySession = null;
            this.save();
        }
    }

    @Override
    public void reset() {
        this.mySession = null;
    }

    @Override
    @Nullable
    public StateStorage getOldStorage(Object component, String componentName, StateStorageOperation operation) throws StateStorageException {
        return this.getFileStateStorage(this.getOldStorageSpec(component, componentName, operation));
    }

    protected abstract String getOldStorageSpec(Object var1, String var2, StateStorageOperation var3) throws StateStorageException;

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStreamProvider(com.intellij.openapi.options.StreamProvider streamProvider, RoamingType type) {
        OldStreamProviderManager oldStreamProviderManager = this.myOldStreamProvider;
        synchronized (oldStreamProviderManager) {
            this.myOldStreamProvider.myStreamProviders.add(new OldStreamProviderAdapter(streamProvider, type));
        }
    }

    @Override
    public void setStreamProvider(@Nullable StreamProvider streamProvider) {
        this.myStreamProvider = streamProvider;
    }

    public void save() {
        if (!this.isDirty) {
            return;
        }
        String filePath = this.getNotNullVersionsFilePath();
        if (filePath != null) {
            File dir = new File(filePath).getParentFile();
            if (!dir.isDirectory() && !dir.mkdirs()) {
                LOG.warn("Unable to create: " + dir);
            }
            try {
                JDOMUtil.writeDocument((Document)new Document(StateStorageManagerImpl.createComponentVersionsXml(this.getComponentVersions())), (String)filePath, (String)"\n");
                this.isDirty = false;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TObjectLongHashMap<String> getComponentVersions() {
        Object object = this.myComponentVersionsLock;
        synchronized (object) {
            if (this.myComponentVersions == null) {
                this.myComponentVersions = this.loadVersions();
            }
            return this.myComponentVersions;
        }
    }

    public static Element createComponentVersionsXml(TObjectLongHashMap<String> versions) {
        Element root = new Element("versions");
        Object[] componentNames = versions.keys();
        Arrays.sort(componentNames);
        for (Object key : componentNames) {
            String name = (String)key;
            long version = versions.get((Object)name);
            if (version == 0L) continue;
            Element element = new Element("component");
            root.addContent(element);
            element.setAttribute("name", name);
            element.setAttribute("version", String.valueOf(version));
        }
        return root;
    }

    static {
        Application app = ApplicationManager.getApplication();
        ourHeadlessEnvironment = app.isHeadlessEnvironment() || app.isUnitTestMode();
        MACRO_PATTERN = Pattern.compile("(\\$[^\\$]*\\$)");
    }

    private static class OldStreamProviderManager
    extends StreamProvider
    implements CurrentUserHolder {
        private final List<OldStreamProviderAdapter> myStreamProviders = new SmartList();

        private OldStreamProviderManager() {
        }

        @Override
        public boolean isVersioningRequired() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            for (OldStreamProviderAdapter provider : this.myStreamProviders) {
                if (!((StreamProvider)provider).isEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "isApplicable"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "isApplicable"));
            }
            for (OldStreamProviderAdapter provider : this.myStreamProviders) {
                if (!((StreamProvider)provider).isApplicable(fileSpec, roamingType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean saveContent(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType, boolean async) throws IOException {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "saveContent"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "saveContent"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "saveContent"));
            }
            boolean result = false;
            for (OldStreamProviderAdapter streamProvider : this.myStreamProviders) {
                try {
                    if (!((StreamProvider)streamProvider).isEnabled() || !((StreamProvider)streamProvider).isApplicable(fileSpec, roamingType) || !((StreamProvider)streamProvider).saveContent(fileSpec, content, size, roamingType, async)) continue;
                    result = true;
                }
                catch (ConnectException e) {
                    LOG.debug("Cannot send user profile to server: " + e.getLocalizedMessage());
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            return result;
        }

        @Override
        public InputStream loadContent(@NotNull String fileSpec, @NotNull RoamingType roamingType) throws IOException {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "loadContent"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "loadContent"));
            }
            for (OldStreamProviderAdapter streamProvider : this.myStreamProviders) {
                try {
                    InputStream content;
                    if (!((StreamProvider)streamProvider).isEnabled() || !((StreamProvider)streamProvider).isApplicable(fileSpec, roamingType) || (content = ((StreamProvider)streamProvider).loadContent(fileSpec, roamingType)) == null) continue;
                    return content;
                }
                catch (ConnectException e) {
                    LOG.debug("Cannot send user profile o server: " + e.getLocalizedMessage());
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            return null;
        }

        @Override
        public void deleteFile(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            if (fileSpec == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "deleteFile"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$OldStreamProviderManager", "deleteFile"));
            }
            for (OldStreamProviderAdapter streamProvider : this.myStreamProviders) {
                try {
                    if (!((StreamProvider)streamProvider).isEnabled() || !((StreamProvider)streamProvider).isApplicable(fileSpec, roamingType)) continue;
                    ((StreamProvider)streamProvider).deleteFile(fileSpec, roamingType);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        public String getCurrentUserName() {
            for (OldStreamProviderAdapter provider : this.myStreamProviders) {
                String userName;
                if (!provider.isEnabled() || (userName = provider.getCurrentUserName()) == null) continue;
                return userName;
            }
            return null;
        }
    }

    protected class MySaveSession
    implements StateStorageManager.SaveSession {
        CompoundSaveSession myCompoundSaveSession;

        public MySaveSession(MyExternalizationSession externalizationSession) {
            this.myCompoundSaveSession = new CompoundSaveSession(externalizationSession.myCompoundExternalizationSession);
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFilesToSave() throws StateStorageException {
            assert (StateStorageManagerImpl.this.mySession == this);
            List<IFile> list = this.myCompoundSaveSession.getAllStorageFilesToSave();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MySaveSession", "getAllStorageFilesToSave"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFiles() {
            List<IFile> list = this.myCompoundSaveSession.getAllStorageFiles();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MySaveSession", "getAllStorageFiles"));
            }
            return list;
        }

        @Override
        public void save() throws StateStorageException {
            assert (StateStorageManagerImpl.this.mySession == this);
            this.myCompoundSaveSession.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishSave() {
            try {
                LOG.assertTrue(StateStorageManagerImpl.this.mySession == this);
            }
            finally {
                this.myCompoundSaveSession.finishSave();
            }
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            if (changedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MySaveSession", "analyzeExternalChanges"));
            }
            THashSet result = new THashSet();
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                StateStorage.SaveSession saveSession = this.myCompoundSaveSession.getSaveSession((StateStorage)pair.second);
                if (saveSession == null) continue;
                Set changes = saveSession.analyzeExternalChanges(changedFiles);
                if (changes == null) {
                    return null;
                }
                result.addAll(changes);
            }
            return result;
        }
    }

    protected class MyExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        CompoundExternalizationSession myCompoundExternalizationSession = new CompoundExternalizationSession();

        protected MyExternalizationSession() {
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, String componentName, @NotNull Object state) throws StateStorageException {
            if (storageSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession", "setState"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession", "setState"));
            }
            assert (StateStorageManagerImpl.this.mySession == this);
            for (Storage storageSpec : storageSpecs) {
                StateStorage stateStorage = StateStorageManagerImpl.this.getStateStorage(storageSpec);
                if (stateStorage == null) continue;
                StateStorage.ExternalizationSession extSession = this.myCompoundExternalizationSession.getExternalizationSession(stateStorage);
                extSession.setState(component, componentName, state, storageSpec);
            }
        }

        @Override
        public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state) throws StateStorageException {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            assert (StateStorageManagerImpl.this.mySession == this);
            StateStorage stateStorage = StateStorageManagerImpl.this.getOldStorage(component, componentName, StateStorageOperation.WRITE);
            if (stateStorage != null) {
                this.myCompoundExternalizationSession.getExternalizationSession(stateStorage).setState(component, componentName, state, null);
            }
        }
    }
}

