/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IModuleStore;
import com.intellij.openapi.components.impl.stores.ModuleStateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleStoreImpl
extends BaseFileConfigurableStoreImpl
implements IModuleStore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.ModuleStoreImpl");
    @NonNls
    private static final String MODULE_FILE_MACRO = "MODULE_FILE";
    private final ModuleImpl myModule;
    public static final String DEFAULT_STATE_STORAGE = "$MODULE_FILE$";

    public ModuleStoreImpl(ComponentManagerImpl componentManager, ModuleImpl module) {
        super(componentManager);
        this.myModule = module;
    }

    @Override
    protected XmlElementStorage getMainStorage() {
        XmlElementStorage storage = (XmlElementStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        return storage;
    }

    @Override
    protected Project getProject() {
        return this.myModule.getProject();
    }

    @Override
    public void load() throws IOException, StateStorageException {
        Collection<String> macros;
        super.load();
        ModuleFileData storageData = this.getMainStorageData();
        String moduleTypeId = (String)storageData.myOptions.get("type");
        this.myModule.setOption("type", ModuleTypeManager.getInstance().findByID(moduleTypeId).getId());
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final TrackingPathMacroSubstitutor substitutor = this.getStateStorageManager().getMacroSubstitutor();
        if (substitutor != null && !(macros = substitutor.getUnknownMacros(null)).isEmpty()) {
            final Project project = this.myModule.getProject();
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    StorageUtil.notifyUnknownMacros(substitutor, project, null);
                }
            });
        }
    }

    @Override
    public ModuleFileData getMainStorageData() throws StateStorageException {
        return (ModuleFileData)super.getMainStorageData();
    }

    @Override
    public void setModuleFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "setModuleFilePath"));
        }
        String path = filePath.replace(File.separatorChar, '/');
        LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        StateStorageManager storageManager = this.getStateStorageManager();
        storageManager.clearStateStorage(DEFAULT_STATE_STORAGE);
        storageManager.addMacro(MODULE_FILE_MACRO, path);
    }

    @Override
    @Nullable
    public VirtualFile getModuleFile() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        return storage.getVirtualFile();
    }

    @Override
    @NotNull
    public String getModuleFilePath() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        String string = storage.getFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getModuleFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getModuleFileName() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        String string = storage.getFileName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getModuleFileName"));
        }
        return string;
    }

    @Override
    public void setOption(String optionName, String optionValue) {
        try {
            this.getMainStorageData().setOption(optionName, optionValue);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void clearOption(String optionName) {
        try {
            this.getMainStorageData().clearOption(optionName);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public String getOptionValue(String optionName) {
        try {
            return this.getMainStorageData().getOptionValue(optionName);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean optimizeTestLoading() {
        return ((ProjectEx)this.myModule.getProject()).isOptimiseTestLoadSpeed();
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ModuleStateStorageManager moduleStateStorageManager = new ModuleStateStorageManager(PathMacroManager.getInstance(this.getComponentManager()).createTrackingSubstitutor(), this.myModule);
        if (moduleStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "createStateStorageManager"));
        }
        return moduleStateStorageManager;
    }

    static class ModuleFileData
    extends BaseFileConfigurableStoreImpl.BaseStorageData {
        private final Map<String, String> myOptions;
        private final Module myModule;

        public ModuleFileData(String rootElementName, Module module) {
            super(rootElementName);
            this.myModule = module;
            this.myOptions = new THashMap(2);
        }

        protected ModuleFileData(ModuleFileData storageData) {
            super(storageData);
            this.myOptions = new THashMap(storageData.myOptions);
            this.myModule = storageData.myModule;
        }

        @Override
        public void load(@NotNull Element rootElement) throws IOException {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "load"));
            }
            super.load(rootElement);
            for (Attribute attribute : rootElement.getAttributes()) {
                this.myOptions.put(attribute.getName(), attribute.getValue());
            }
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && this.myOptions.isEmpty();
        }

        @Override
        @NotNull
        protected Element save() {
            Element root = super.save();
            this.myOptions.put("version", Integer.toString(this.myVersion));
            Object[] options = ArrayUtil.toStringArray(this.myOptions.keySet());
            Arrays.sort(options);
            for (Object option : options) {
                root.setAttribute((String)option, this.myOptions.get(option));
            }
            root.removeAttribute("version");
            root.setAttribute("version", Integer.toString(this.myVersion));
            Element element = root;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "save"));
            }
            return element;
        }

        @Override
        public StorageData clone() {
            return new ModuleFileData(this);
        }

        @Override
        protected int computeHash() {
            return super.computeHash() * 31 + ((Object)this.myOptions).hashCode();
        }

        @Override
        @Nullable
        public Set<String> getDifference(StorageData storageData, PathMacroSubstitutor substitutor) {
            ModuleFileData data = (ModuleFileData)storageData;
            if (!((Object)this.myOptions).equals(data.myOptions)) {
                return null;
            }
            return super.getDifference(storageData, substitutor);
        }

        public void setOption(String optionName, String optionValue) {
            this.clearHash();
            this.myOptions.put(optionName, optionValue);
        }

        public void clearOption(String optionName) {
            this.clearHash();
            this.myOptions.remove(optionName);
        }

        public String getOptionValue(String optionName) {
            return this.myOptions.get(optionName);
        }
    }
}

