/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class FileBasedStorage
extends XmlElementStorage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.FileBasedStorage");
    private final String myFilePath;
    private final IFile myFile;
    protected final String myRootElementName;
    private static boolean myConfigDirectoryRefreshed = false;
    private volatile VirtualFile myCachedVirtualFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedStorage(@Nullable TrackingPathMacroSubstitutor pathMacroManager, StreamProvider streamProvider, String filePath, String fileSpec, String rootElementName, @NotNull Disposable parentDisposable, PicoContainer picoContainer, ComponentRoamingManager componentRoamingManager, ComponentVersionProvider localComponentVersionProvider) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        super(pathMacroManager, parentDisposable, rootElementName, streamProvider, fileSpec, componentRoamingManager, localComponentVersionProvider);
        Application app = ApplicationManager.getApplication();
        if (!myConfigDirectoryRefreshed && (app.isUnitTestMode() || app.isDispatchThread())) {
            try {
                FileBasedStorage.syncRefreshPathRecursively(PathManager.getConfigPath(), "componentVersions");
            }
            finally {
                myConfigDirectoryRefreshed = true;
            }
        }
        this.myRootElementName = rootElementName;
        this.myFilePath = filePath;
        this.myFile = FileSystem.FILE_SYSTEM.createFile(this.myFilePath);
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)picoContainer.getComponentInstanceOfType(VirtualFileTracker.class);
        MessageBus messageBus = (MessageBus)picoContainer.getComponentInstanceOfType(MessageBus.class);
        if (virtualFileTracker != null && messageBus != null) {
            String path = this.myFile.getAbsolutePath();
            String fileUrl = "file://" + path.replace(File.separatorChar, '/');
            final StateStorage.Listener listener = (StateStorage.Listener)messageBus.syncPublisher(STORAGE_TOPIC);
            virtualFileTracker.addTracker(fileUrl, (VirtualFileListener)new VirtualFileAdapter(){

                public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "fileMoved"));
                    }
                    FileBasedStorage.this.myCachedVirtualFile = null;
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "fileDeleted"));
                    }
                    FileBasedStorage.this.myCachedVirtualFile = null;
                }

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "contentsChanged"));
                    }
                    if (!FileBasedStorage.this.isDisposed()) {
                        listener.storageFileChanged(event, (StateStorage)FileBasedStorage.this);
                    }
                }
            }, false, (Disposable)this);
        }
    }

    private static void syncRefreshPathRecursively(@NotNull String configDirectoryPath, @Nullable String excludeDir) {
        if (configDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "syncRefreshPathRecursively"));
        }
        VirtualFile configDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(configDirectoryPath);
        if (configDir != null) {
            FileBasedStorage.requestAllChildren(configDir, excludeDir);
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{configDir});
        }
    }

    private static void requestAllChildren(VirtualFile configDir, final @Nullable String excludeDir) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)configDir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/FileBasedStorage$2", "visitFile"));
                }
                return excludeDir == null || !excludeDir.equals(file.getName());
            }
        });
    }

    @Override
    protected XmlElementStorage.MySaveSession createSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
        return new FileSaveSession(externalizationSession);
    }

    public void resetProviderCache() {
        this.myProviderUpToDateHash = -1;
        if (this.myRemoteVersionProvider != null) {
            this.myRemoteVersionProvider.myProviderVersions = null;
        }
    }

    @Override
    protected void loadState(StorageData result, Element element) throws StateStorageException {
        ((FileStorageData)result).myFilePath = this.myFile.getAbsolutePath();
        super.loadState(result, element);
    }

    @Override
    @NotNull
    protected StorageData createStorageData() {
        FileStorageData fileStorageData = new FileStorageData(this.myRootElementName);
        if (fileStorageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "createStorageData"));
        }
        return fileStorageData;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myCachedVirtualFile;
        if (virtualFile == null) {
            this.myCachedVirtualFile = virtualFile = StorageUtil.getVirtualFile(this.myFile);
        }
        return virtualFile;
    }

    public File getFile() {
        return new File(this.myFile.getPath());
    }

    @Override
    @Nullable
    protected Document loadDocument() throws StateStorageException {
        this.myBlockSavingTheContent = false;
        try {
            VirtualFile file = this.getVirtualFile();
            if (file == null || file.isDirectory() || !file.isValid()) {
                LOG.info("Document was not loaded for " + this.myFileSpec + " file is " + (file == null ? "null" : "directory"));
                return null;
            }
            if (file.getLength() == 0L) {
                return this.processReadException(null);
            }
            return FileBasedStorage.loadDocumentImpl(file);
        }
        catch (JDOMException e) {
            return this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            return this.processReadException(e);
        }
    }

    @Nullable
    private Document processReadException(@Nullable Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.myBlockSavingTheContent = this.isProjectOrModuleOrWorkspaceFile() && !contentTruncated;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (e != null) {
                LOG.info((Throwable)e);
            }
            String message = "Cannot load settings from file '" + this.myFile.getPath() + "': " + (e == null ? "content truncated" : e.getLocalizedMessage()) + "\n" + this.getInvalidContentMessage(contentTruncated);
            Notifications.Bus.notify((Notification)new Notification("System Messages", "Load Settings", message, NotificationType.WARNING));
        }
        return null;
    }

    private boolean isProjectOrModuleOrWorkspaceFile() {
        return StorageUtil.isProjectOrModuleFile(this.myFileSpec) || this.myFileSpec.equals("$WORKSPACE_FILE$");
    }

    private String getInvalidContentMessage(boolean contentTruncated) {
        return this.isProjectOrModuleOrWorkspaceFile() && !contentTruncated ? "Please correct the file content" : "File content will be recreated";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDocumentImpl(VirtualFile file) throws IOException, JDOMException {
        InputStream stream = file.getInputStream();
        try {
            Document document = JDOMUtil.loadDocument((InputStream)stream);
            return document;
        }
        finally {
            stream.close();
        }
    }

    public String getFileName() {
        return this.myFile.getName();
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    @Override
    public void setDefaultState(Element element) {
        element.setName(this.myRootElementName);
        super.setDefaultState(element);
    }

    protected boolean physicalContentNeedsSave(Document doc) {
        VirtualFile file = this.getVirtualFile();
        return file == null || !file.exists() || !StorageUtil.contentEquals(doc, file);
    }

    @Nullable
    public File updateFileExternallyFromStreamProviders() throws IOException {
        StorageData loadedData = this.loadData(true);
        Document document = this.getDocument(loadedData);
        if (this.physicalContentNeedsSave(document)) {
            File file = new File(this.myFile.getAbsolutePath());
            JDOMUtil.writeDocument((Document)document, (File)file, (String)"\n");
            return file;
        }
        return null;
    }

    public static class FileStorageData
    extends StorageData {
        String myFilePath;

        public FileStorageData(String rootElementName) {
            super(rootElementName);
        }

        protected FileStorageData(FileStorageData storageData) {
            super(storageData);
            this.myFilePath = storageData.myFilePath;
        }

        @Override
        public StorageData clone() {
            return new FileStorageData(this);
        }

        @NonNls
        public String toString() {
            return "FileStorageData[" + this.myFilePath + "]";
        }
    }

    private class FileSaveSession
    extends XmlElementStorage.MySaveSession {
        protected FileSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
            super(FileBasedStorage.this, externalizationSession);
        }

        @Override
        protected boolean physicalContentNeedsSave() {
            VirtualFile file = FileBasedStorage.this.getVirtualFile();
            if (file == null || !file.exists()) {
                return !this.myStorageData.isEmpty();
            }
            return !StorageUtil.contentEquals(this.getDocumentToSave(), file);
        }

        @Override
        protected int calcHash() {
            int hash = this.myStorageData.getHash();
            if (FileBasedStorage.this.myPathMacroSubstitutor != null) {
                hash = 31 * hash + FileBasedStorage.this.myPathMacroSubstitutor.hashCode();
            }
            return hash;
        }

        @Override
        protected void doSave() throws StateStorageException {
            if (FileBasedStorage.this.myBlockSavingTheContent) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode() && FileBasedStorage.this.myFile != null && StringUtil.startsWithChar((CharSequence)FileBasedStorage.this.myFile.getPath(), (char)'$')) {
                throw new StateStorageException("It seems like some macros were not expanded for path: " + FileBasedStorage.this.myFile.getPath());
            }
            LOG.assertTrue(FileBasedStorage.this.myFile != null);
            FileBasedStorage.this.myCachedVirtualFile = StorageUtil.save(FileBasedStorage.this.myFile, (Parent)this.getDocumentToSave(), this);
        }

        @NotNull
        public Collection<IFile> getStorageFilesToSave() throws StateStorageException {
            boolean needsSave = this.needsSave();
            if (needsSave) {
                if (LOG.isDebugEnabled()) {
                    LOG.info("File " + FileBasedStorage.this.myFileSpec + " needs save; hash=" + FileBasedStorage.this.myUpToDateHash + "; currentHash=" + this.calcHash() + "; " + "content needs save=" + this.physicalContentNeedsSave());
                }
                List<IFile> list = this.getAllStorageFiles();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage$FileSaveSession", "getStorageFilesToSave"));
                }
                return list;
            }
            List<IFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage$FileSaveSession", "getStorageFilesToSave"));
            }
            return list;
        }

        @NotNull
        public List<IFile> getAllStorageFiles() {
            List<IFile> list = Collections.singletonList(FileBasedStorage.this.myFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage$FileSaveSession", "getAllStorageFiles"));
            }
            return list;
        }
    }
}

