/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class DirectoryBasedStorage
implements StateStorage,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DirectoryBasedStorage");
    private static final IFile[] EMPTY_FILES = new IFile[0];
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final IFile myDir;
    private final StateSplitter mySplitter;
    private final FileTypeManager myFileTypeManager;
    private Object mySession;
    private DirectoryStorageData myStorageData;

    public DirectoryBasedStorage(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull String dir, @NotNull StateSplitter splitter, @NotNull Disposable parentDisposable, @NotNull PicoContainer picoContainer) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (picoContainer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        this.myStorageData = null;
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        this.myDir = FileSystem.FILE_SYSTEM.createFile(dir);
        this.mySplitter = splitter;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)picoContainer.getComponentInstanceOfType(VirtualFileTracker.class);
        MessageBus messageBus = (MessageBus)picoContainer.getComponentInstanceOfType(MessageBus.class);
        if (virtualFileTracker != null && messageBus != null) {
            String path = this.myDir.getAbsolutePath();
            String fileUrl = "file://" + path.replace(File.separatorChar, '/');
            final StateStorage.Listener listener = (StateStorage.Listener)messageBus.syncPublisher(STORAGE_TOPIC);
            virtualFileTracker.addTracker(fileUrl, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "contentsChanged"));
                    }
                    if (!StringUtil.endsWithIgnoreCase((String)event.getFile().getName(), (String)".xml")) {
                        return;
                    }
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "fileDeleted"));
                    }
                    if (!StringUtil.endsWithIgnoreCase((String)event.getFile().getName(), (String)".xml")) {
                        return;
                    }
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "fileCreated"));
                    }
                    if (!StringUtil.endsWithIgnoreCase((String)event.getFile().getName(), (String)".xml")) {
                        return;
                    }
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }
            }, false, (Disposable)this);
        }
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    @Nullable
    public <T> T getState(Object component, String componentName, Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        if (this.myStorageData == null) {
            this.myStorageData = this.loadState();
        }
        if (!this.myStorageData.containsComponent(componentName)) {
            return DefaultStateSerializer.deserializeState(new Element("component"), stateClass, mergeInto);
        }
        return this.myStorageData.getMergedState(componentName, stateClass, this.mySplitter, mergeInto);
    }

    private DirectoryStorageData loadState() throws StateStorageException {
        DirectoryStorageData storageData = new DirectoryStorageData();
        storageData.loadFrom(LocalFileSystem.getInstance().findFileByIoFile(this.myDir), this.myPathMacroSubstitutor);
        return storageData;
    }

    public boolean hasState(Object component, String componentName, Class<?> aClass, boolean reloadData) throws StateStorageException {
        if (!this.myDir.exists()) {
            return false;
        }
        if (reloadData) {
            this.myStorageData = null;
        }
        return true;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        if (this.myStorageData == null) {
            try {
                this.myStorageData = this.loadState();
            }
            catch (StateStorageException e) {
                LOG.error((Throwable)e);
            }
        }
        MyExternalizationSession session = new MyExternalizationSession(this.myStorageData.clone());
        this.mySession = session;
        MyExternalizationSession myExternalizationSession = session;
        if (myExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "startExternalization"));
        }
        return myExternalizationSession;
    }

    @NotNull
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "startSave"));
        }
        assert (this.mySession == externalizationSession);
        MySaveSession session = new MySaveSession(((MyExternalizationSession)externalizationSession).myStorageData, this.myPathMacroSubstitutor);
        this.mySession = session;
        MySaveSession mySaveSession = session;
        if (mySaveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "startSave"));
        }
        return mySaveSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSave(@NotNull StateStorage.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "finishSave"));
        }
        try {
            LOG.assertTrue(this.mySession == saveSession);
        }
        finally {
            this.mySession = null;
        }
    }

    public void reload(@NotNull Set<String> changedComponents) throws StateStorageException {
        if (changedComponents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "reload"));
        }
        this.myStorageData = this.loadState();
    }

    public void dispose() {
    }

    private class MyExternalizationSession
    implements StateStorage.ExternalizationSession {
        private final DirectoryStorageData myStorageData;

        private MyExternalizationSession(DirectoryStorageData storageData) {
            this.myStorageData = storageData;
        }

        public void setState(@NotNull Object component, String componentName, @NotNull Object state, Storage storageSpec) throws StateStorageException {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyExternalizationSession", "setState"));
            }
            assert (DirectoryBasedStorage.this.mySession == this);
            this.setState(componentName, state, storageSpec);
        }

        private void setState(String componentName, @NotNull Object state, Storage storageSpec) throws StateStorageException {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyExternalizationSession", "setState"));
            }
            try {
                Element element = DefaultStateSerializer.serializeState(state, storageSpec);
                for (Pair pair : DirectoryBasedStorage.this.mySplitter.splitState(element)) {
                    Element e = (Element)pair.first;
                    String name = (String)pair.second;
                    Element statePart = new Element("component");
                    statePart.setAttribute("name", componentName);
                    statePart.addContent(e.detach());
                    this.myStorageData.put(componentName, DirectoryBasedStorage.this.myDir.getChild(name), statePart, false);
                }
            }
            catch (WriteExternalException e) {
                throw new StateStorageException((Throwable)e);
            }
        }
    }

    private class MySaveSession
    implements StateStorage.SaveSession,
    SafeWriteRequestor {
        private final DirectoryStorageData myStorageData;
        private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

        private MySaveSession(DirectoryStorageData storageData, TrackingPathMacroSubstitutor pathMacroSubstitutor) {
            this.myStorageData = storageData;
            this.myPathMacroSubstitutor = pathMacroSubstitutor;
        }

        public void save() throws StateStorageException {
            IFile[] children;
            assert (DirectoryBasedStorage.this.mySession == this);
            final HashSet<String> currentNames = new HashSet<String>();
            for (IFile child : children = DirectoryBasedStorage.this.myDir.exists() ? DirectoryBasedStorage.this.myDir.listFiles() : EMPTY_FILES) {
                String fileName = child.getName();
                if (DirectoryBasedStorage.this.myFileTypeManager.isFileIgnored(fileName) || !StringUtil.endsWithIgnoreCase((String)fileName, (String)".xml")) continue;
                currentNames.add(fileName);
            }
            this.myStorageData.process(new DirectoryStorageData.StorageDataProcessor(){

                @Override
                public void process(String componentName, IFile file, Element element) {
                    currentNames.remove(file.getName());
                    if (MySaveSession.this.myPathMacroSubstitutor != null) {
                        MySaveSession.this.myPathMacroSubstitutor.collapsePaths(element);
                    }
                    if (file.getTimeStamp() <= MySaveSession.this.myStorageData.getLastTimeStamp()) {
                        if (!DirectoryBasedStorage.this.myDir.exists()) {
                            DirectoryBasedStorage.this.myDir.createParentDirs();
                            DirectoryBasedStorage.this.myDir.mkDir();
                        }
                        StorageUtil.save(file, (Parent)element, MySaveSession.this);
                        MySaveSession.this.myStorageData.updateLastTimestamp(file);
                    }
                }
            });
            if (DirectoryBasedStorage.this.myDir.exists() && !currentNames.isEmpty()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (DirectoryBasedStorage.this.myDir.exists()) {
                            for (String name : currentNames) {
                                IFile child = DirectoryBasedStorage.this.myDir.getChild(name);
                                if (child.getTimeStamp() > MySaveSession.this.myStorageData.getLastTimeStamp()) {
                                    return;
                                }
                                VirtualFile virtualFile = StorageUtil.getVirtualFile(child);
                                if (virtualFile == null) continue;
                                try {
                                    LOG.debug("Removing configuration file: " + virtualFile.getPresentableUrl());
                                    virtualFile.delete((Object)MySaveSession.this);
                                }
                                catch (IOException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
            this.myStorageData.clear();
        }

        @Nullable
        public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            if (changedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "analyzeExternalChanges"));
            }
            boolean containsSelf = false;
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                VirtualFile file;
                if (pair.second != DirectoryBasedStorage.this || !"xml".equalsIgnoreCase((file = (VirtualFile)pair.first).getExtension())) continue;
                containsSelf = true;
                break;
            }
            if (!containsSelf) {
                return Collections.emptySet();
            }
            if (this.myStorageData.getComponentNames().size() == 0) {
                DirectoryStorageData storageData = DirectoryBasedStorage.this.loadState();
                return new HashSet<String>(storageData.getComponentNames());
            }
            return new HashSet<String>(this.myStorageData.getComponentNames());
        }

        @NotNull
        public Collection<IFile> getStorageFilesToSave() throws StateStorageException {
            assert (DirectoryBasedStorage.this.mySession == this);
            if (!DirectoryBasedStorage.this.myDir.exists()) {
                List<IFile> list = this.getAllStorageFiles();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "getStorageFilesToSave"));
                }
                return list;
            }
            assert (DirectoryBasedStorage.this.myDir.isDirectory()) : DirectoryBasedStorage.access$400(DirectoryBasedStorage.this).getPath();
            final ArrayList<IFile> filesToSave = new ArrayList<IFile>();
            IFile[] children = DirectoryBasedStorage.this.myDir.listFiles();
            final HashSet<String> currentChildNames = new HashSet<String>();
            for (IFile child : children) {
                if (DirectoryBasedStorage.this.myFileTypeManager.isFileIgnored(child.getName())) continue;
                currentChildNames.add(child.getName());
            }
            this.myStorageData.process(new DirectoryStorageData.StorageDataProcessor(){

                @Override
                public void process(String componentName, IFile file, Element element) {
                    if (currentChildNames.contains(file.getName())) {
                        VirtualFile virtualFile;
                        currentChildNames.remove(file.getName());
                        if (MySaveSession.this.myPathMacroSubstitutor != null) {
                            MySaveSession.this.myPathMacroSubstitutor.collapsePaths(element);
                        }
                        if ((virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file)) == null || !StorageUtil.contentEquals(element, virtualFile)) {
                            filesToSave.add(file);
                        }
                    }
                }
            });
            for (String childName : currentChildNames) {
                IFile child = DirectoryBasedStorage.this.myDir.getChild(childName);
                filesToSave.add(child);
            }
            ArrayList<IFile> arrayList = filesToSave;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "getStorageFilesToSave"));
            }
            return arrayList;
        }

        @NotNull
        public List<IFile> getAllStorageFiles() {
            ArrayList<IFile> arrayList = new ArrayList<IFile>(this.myStorageData.getAllStorageFiles().keySet());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "getAllStorageFiles"));
            }
            return arrayList;
        }
    }
}

