/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.annotation.Annotation;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

class DefaultStateSerializer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DefaultStateSerializer");

    private DefaultStateSerializer() {
    }

    static Element serializeState(Object state, final Storage storage) throws WriteExternalException {
        if (state instanceof Element) {
            return (Element)state;
        }
        if (state instanceof JDOMExternalizable) {
            JDOMExternalizable jdomExternalizable = (JDOMExternalizable)state;
            Element element = new Element("temp_element");
            try {
                jdomExternalizable.writeExternal(element);
            }
            catch (WriteExternalException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.info("Unable to serialize component state!", e);
                return new Element("empty");
            }
            return element;
        }
        return XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters(){

            public boolean accepts(Accessor accessor, Object bean) {
                if (!super.accepts(accessor, bean)) {
                    return false;
                }
                if (storage != null) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = accessor.getAnnotations()) {
                        StorageId storageId;
                        if (!StorageId.class.isAssignableFrom(annotation.annotationType()) || (storageId = (StorageId)annotation).value().equals(storage.id())) continue;
                        return false;
                    }
                    return storage.isDefault();
                }
                return true;
            }
        });
    }

    @Nullable
    static <T> T deserializeState(@Nullable Element stateElement, Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        if (stateElement == null) {
            return mergeInto;
        }
        if (stateClass.equals(Element.class)) {
            return (T)stateElement;
        }
        if (JDOMExternalizable.class.isAssignableFrom(stateClass)) {
            if (mergeInto != null) {
                String elementText = JDOMUtil.writeElement((Element)stateElement, (String)"\n");
                LOG.error("State is " + stateClass.getName() + ", merge into is " + mergeInto.toString() + ", state element text is " + elementText);
            }
            try {
                T t = stateClass.newInstance();
                try {
                    ((JDOMExternalizable)t).readExternal(stateElement);
                    return t;
                }
                catch (InvalidDataException e) {
                    throw new StateStorageException((Throwable)e);
                }
            }
            catch (InstantiationException e) {
                throw new StateStorageException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new StateStorageException((Throwable)e);
            }
        }
        if (mergeInto == null) {
            return (T)XmlSerializer.deserialize((Element)stateElement, stateClass);
        }
        XmlSerializer.deserializeInto(mergeInto, (Element)stateElement);
        return mergeInto;
    }
}

