/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.fs.IFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultProjectStoreImpl
extends ProjectStoreImpl {
    @Nullable
    private final Element myElement;
    private final ProjectManagerImpl myProjectManager;
    @NonNls
    private static final String ROOT_TAG_NAME = "defaultProject";

    public DefaultProjectStoreImpl(ProjectImpl project, ProjectManagerImpl projectManager) {
        super(project);
        this.myProjectManager = projectManager;
        this.myElement = projectManager.getDefaultProjectRootElement();
    }

    @Nullable
    Element getStateCopy() {
        Element element = this.myProjectManager.getDefaultProjectRootElement();
        return element != null ? element.clone() : null;
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        Document _d = null;
        if (this.myElement != null) {
            this.myElement.detach();
            _d = new Document(this.myElement);
        }
        ComponentManager componentManager = this.getComponentManager();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance(componentManager);
        final Document document = _d;
        final XmlElementStorage storage = new XmlElementStorage(pathMacroManager.createTrackingSubstitutor(), (Disposable)componentManager, ROOT_TAG_NAME, null, "", ComponentRoamingManager.getInstance(), ComponentVersionProvider.EMPTY){

            @Override
            @Nullable
            protected Document loadDocument() throws StateStorageException {
                return document;
            }

            @Override
            protected XmlElementStorage.MySaveSession createSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
                return new DefaultSaveSession(externalizationSession);
            }

            @Override
            @NotNull
            protected StorageData createStorageData() {
                BaseFileConfigurableStoreImpl.BaseStorageData baseStorageData = new BaseFileConfigurableStoreImpl.BaseStorageData(DefaultProjectStoreImpl.ROOT_TAG_NAME);
                if (baseStorageData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$1", "createStorageData"));
                }
                return baseStorageData;
            }

            class DefaultSaveSession
            extends XmlElementStorage.MySaveSession {
                public DefaultSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
                    super(this, externalizationSession);
                }

                @Override
                protected void doSave() throws StateStorageException {
                    DefaultProjectStoreImpl.this.myProjectManager.setDefaultProjectRootElement(this.getDocumentToSave().getRootElement());
                }

                @NotNull
                public Collection<IFile> getStorageFilesToSave() throws StateStorageException {
                    List<IFile> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$1$DefaultSaveSession", "getStorageFilesToSave"));
                    }
                    return list;
                }

                @NotNull
                public List<IFile> getAllStorageFiles() {
                    List<IFile> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$1$DefaultSaveSession", "getAllStorageFiles"));
                    }
                    return list;
                }
            }
        };
        StateStorageManager stateStorageManager = new StateStorageManager(){

            @Override
            public void addMacro(String macro, String expansion) {
                throw new UnsupportedOperationException("Method addMacro not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public TrackingPathMacroSubstitutor getMacroSubstitutor() {
                return null;
            }

            @Override
            @Nullable
            public StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorageException {
                if (storageSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getStateStorage"));
                }
                return storage;
            }

            @Override
            @Nullable
            public StateStorage getFileStateStorage(@NotNull String fileSpec) {
                if (fileSpec == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "getFileStateStorage"));
                }
                return storage;
            }

            @Override
            public void clearStateStorage(@NotNull String file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "clearStateStorage"));
                }
            }

            @Override
            @NotNull
            public StateStorageManager.ExternalizationSession startExternalization() {
                MyExternalizationSession myExternalizationSession = new MyExternalizationSession(storage);
                if (myExternalizationSession == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "startExternalization"));
                }
                return myExternalizationSession;
            }

            @Override
            @NotNull
            public StateStorageManager.SaveSession startSave(@NotNull StateStorageManager.ExternalizationSession externalizationSession) {
                if (externalizationSession == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "startSave"));
                }
                MySaveSession mySaveSession = new MySaveSession(storage, externalizationSession);
                if (mySaveSession == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "startSave"));
                }
                return mySaveSession;
            }

            @Override
            public void finishSave(@NotNull StateStorageManager.SaveSession saveSession) {
                if (saveSession == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2", "finishSave"));
                }
                storage.finishSave(((MySaveSession)saveSession).saveSession);
            }

            @Override
            public String expandMacros(String file) {
                throw new UnsupportedOperationException("Method expandMacroses not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public StateStorage getOldStorage(Object component, String componentName, StateStorageOperation operation) throws StateStorageException {
                return storage;
            }

            @Override
            public void registerStreamProvider(com.intellij.openapi.options.StreamProvider streamProvider, RoamingType type) {
                throw new UnsupportedOperationException("Method registerStreamProvider not implemented in " + this.getClass());
            }

            @Override
            public void setStreamProvider(@Nullable StreamProvider streamProvider) {
                throw new UnsupportedOperationException("Method setStreamProvider not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public StreamProvider getStreamProvider() {
                throw new UnsupportedOperationException("Method getStreamProviders not implemented in " + this.getClass());
            }

            @Override
            public Collection<String> getStorageFileNames() {
                throw new UnsupportedOperationException("Method getStorageFileNames not implemented in " + this.getClass());
            }

            @Override
            public void reset() {
            }
        };
        if (stateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl", "createStateStorageManager"));
        }
        return stateStorageManager;
    }

    @Override
    public void load() throws IOException, StateStorageException {
        if (this.myElement == null) {
            return;
        }
        super.load();
    }

    private static class MySaveSession
    implements StateStorageManager.SaveSession {
        @NotNull
        private final StateStorage.SaveSession saveSession;

        public MySaveSession(@NotNull XmlElementStorage storage, @NotNull StateStorageManager.ExternalizationSession externalizationSession) {
            if (storage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MySaveSession", "<init>"));
            }
            if (externalizationSession == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MySaveSession", "<init>"));
            }
            this.saveSession = storage.startSave(((MyExternalizationSession)externalizationSession).externalizationSession);
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MySaveSession", "analyzeExternalChanges"));
            }
            throw new UnsupportedOperationException("Method analyzeExternalChanges not implemented in " + this.getClass());
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFilesToSave() throws StateStorageException {
            List<IFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MySaveSession", "getAllStorageFilesToSave"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFiles() {
            List<IFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MySaveSession", "getAllStorageFiles"));
            }
            return list;
        }

        @Override
        public void save() throws StateStorageException {
            this.saveSession.save();
        }
    }

    private static class MyExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        @NotNull
        final StateStorage.ExternalizationSession externalizationSession;

        public MyExternalizationSession(@NotNull XmlElementStorage storage) {
            if (storage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "<init>"));
            }
            this.externalizationSession = storage.startExternalization();
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, String componentName, @NotNull Object state) throws StateStorageException {
            if (storageSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setState"));
            }
            this.externalizationSession.setState(component, componentName, state, null);
        }

        @Override
        public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state) throws StateStorageException {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession", "setStateInOldStorage"));
            }
            this.externalizationSession.setState(component, componentName, state, null);
        }
    }
}

