/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.CompoundExternalizationSession;
import com.intellij.util.SmartList;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;

public class CompoundSaveSession {
    private final Map<StateStorage, StateStorage.SaveSession> mySaveSessions = new THashMap();

    public CompoundSaveSession(CompoundExternalizationSession compoundExternalizationSession) {
        for (StateStorage stateStorage : compoundExternalizationSession.getStateStorages()) {
            this.mySaveSessions.put(stateStorage, stateStorage.startSave(compoundExternalizationSession.getExternalizationSession(stateStorage)));
        }
    }

    public List<IFile> getAllStorageFilesToSave() throws StateStorageException {
        SmartList result = new SmartList();
        for (StateStorage.SaveSession saveSession : this.mySaveSessions.values()) {
            result.addAll(saveSession.getStorageFilesToSave());
        }
        return result;
    }

    public void save() throws StateStorageException {
        for (StateStorage.SaveSession saveSession : this.mySaveSessions.values()) {
            saveSession.save();
        }
    }

    public void finishSave() {
        RuntimeException re = null;
        for (StateStorage stateStorage : this.mySaveSessions.keySet()) {
            try {
                stateStorage.finishSave(this.mySaveSessions.get(stateStorage));
            }
            catch (RuntimeException e) {
                re = e;
            }
        }
        if (re != null) {
            throw re;
        }
    }

    public StateStorage.SaveSession getSaveSession(StateStorage storage) {
        return this.mySaveSessions.get(storage);
    }

    public List<IFile> getAllStorageFiles() {
        SmartList result = new SmartList();
        for (StateStorage.SaveSession saveSession : this.mySaveSessions.values()) {
            result.addAll(saveSession.getAllStorageFiles());
        }
        return result;
    }
}

