/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageAnnotationsDefaultValues;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.InvalidComponentDataException;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashMap;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentStoreImpl
implements IComponentStore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.components.ComponentStoreImpl");
    private final Map<String, Object> myComponents = Collections.synchronizedMap(new THashMap());
    private final List<SettingsSavingComponent> mySettingsSavingComponents = Collections.synchronizedList(new ArrayList());
    @Nullable
    private SaveSessionImpl mySession;

    @Deprecated
    @Nullable
    private StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorageException {
        if (storageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateStorage"));
        }
        return this.getStateStorageManager().getStateStorage(storageSpec);
    }

    protected StateStorage getDefaultsStorage() {
        throw new UnsupportedOperationException("Method getDefaultsStorage is not supported in " + this.getClass());
    }

    @Override
    public void initComponent(final @NotNull Object component, boolean service) {
        boolean isSerializable;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initComponent"));
        }
        if (component instanceof SettingsSavingComponent) {
            SettingsSavingComponent settingsSavingComponent = (SettingsSavingComponent)component;
            this.mySettingsSavingComponents.add(settingsSavingComponent);
        }
        boolean bl = isSerializable = component instanceof JDOMExternalizable || component instanceof PersistentStateComponent;
        if (!isSerializable) {
            return;
        }
        try {
            ApplicationManagerEx.getApplicationEx().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (component instanceof PersistentStateComponent) {
                        ComponentStoreImpl.this.initPersistentComponent((PersistentStateComponent)component, false);
                    } else {
                        ComponentStoreImpl.this.initJdomExternalizable((JDOMExternalizable)component);
                    }
                }
            });
        }
        catch (StateStorageException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean isSaving() {
        return this.mySession != null;
    }

    @Override
    @NotNull
    public IComponentStore.SaveSession startSave() throws IOException {
        SaveSessionImpl saveSessionImpl;
        try {
            SaveSessionImpl session = this.createSaveSession();
            try {
                session.commit();
            }
            catch (Throwable e) {
                try {
                    session.reset();
                }
                catch (Exception e1_ignored) {
                    LOG.info((Throwable)e1_ignored);
                }
                PluginId pluginId = IdeErrorsDialog.findPluginId(e);
                if (pluginId != null) {
                    throw new PluginException(e, pluginId);
                }
                LOG.info(e);
                IOException ioException = new IOException(e.getMessage());
                ioException.initCause(e);
                throw ioException;
            }
            saveSessionImpl = this.mySession = session;
        }
        catch (StateStorageException e) {
            LOG.info((Throwable)e);
            throw new IOException(e.getMessage());
        }
        if (saveSessionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "startSave"));
        }
        return saveSessionImpl;
    }

    protected SaveSessionImpl createSaveSession() throws StateStorageException {
        return new SaveSessionImpl();
    }

    public void finishSave(@NotNull IComponentStore.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "finishSave"));
        }
        assert (this.mySession == saveSession);
        this.mySession.finishSave();
        this.mySession = null;
    }

    private <T> void commitPersistentComponent(@NotNull PersistentStateComponent<T> persistentStateComponent, @NotNull StateStorageManager.ExternalizationSession session) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        Storage[] storageSpecs = this.getComponentStorageSpecs(persistentStateComponent, StateStorageOperation.WRITE);
        Object state = persistentStateComponent.getState();
        if (state != null) {
            session.setState(storageSpecs, persistentStateComponent, ComponentStoreImpl.getComponentName(persistentStateComponent), state);
        }
    }

    @Nullable
    private String initJdomExternalizable(@NotNull JDOMExternalizable component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initJdomExternalizable"));
        }
        String componentName = ComponentManagerImpl.getComponentName(component);
        this.doAddComponent(componentName, component);
        if (this.optimizeTestLoading()) {
            return componentName;
        }
        this.loadJdomDefaults(component, componentName);
        StateStorage stateStorage = this.getStateStorageManager().getOldStorage(component, componentName, StateStorageOperation.READ);
        if (stateStorage == null) {
            return null;
        }
        Element element = ComponentStoreImpl.getJdomState(component, componentName, stateStorage);
        if (element == null) {
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading configuration for " + component.getClass());
            }
            component.readExternal(element);
        }
        catch (InvalidDataException e) {
            throw new InvalidComponentDataException(e);
        }
        this.validateUnusedMacros(componentName, true);
        return componentName;
    }

    private void doAddComponent(String componentName, Object component) {
        Object existing = this.myComponents.get(componentName);
        if (existing != null && existing != component) {
            LOG.error("Conflicting component name '" + componentName + "': " + existing.getClass() + " and " + component.getClass());
        }
        this.myComponents.put(componentName, component);
    }

    private void loadJdomDefaults(@NotNull Object component, String componentName) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        try {
            StateStorage defaultsStorage = this.getDefaultsStorage();
            if (defaultsStorage == null) {
                return;
            }
            Element defaultState = ComponentStoreImpl.getJdomState(component, componentName, defaultsStorage);
            if (defaultState == null) {
                return;
            }
            ((JDOMExternalizable)component).readExternal(defaultState);
        }
        catch (Exception e) {
            LOG.error("Cannot load defaults for " + component.getClass(), (Throwable)e);
        }
    }

    @Nullable
    private static Element getJdomState(Object component, String componentName, @NotNull StateStorage defaultsStorage) throws StateStorageException {
        if (defaultsStorage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getJdomState"));
        }
        ComponentRoamingManager roamingManager = ComponentRoamingManager.getInstance();
        if (component instanceof RoamingTypeDisabled) {
            roamingManager.setRoamingType(componentName, RoamingType.DISABLED);
        }
        return (Element)defaultsStorage.getState(component, componentName, Element.class, null);
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    private void validateUnusedMacros(@Nullable String componentName, boolean service) {
        TrackingPathMacroSubstitutor substitutor;
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() && service && componentName != null && project.isInitialized() && (substitutor = this.getStateStorageManager().getMacroSubstitutor()) != null) {
            StorageUtil.notifyUnknownMacros(substitutor, project, componentName);
        }
    }

    private <T> String initPersistentComponent(@NotNull PersistentStateComponent<T> component, boolean reloadData) {
        Storage[] storageSpecs;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initPersistentComponent"));
        }
        State spec = ComponentStoreImpl.getStateSpec(component);
        String name = spec.name();
        ComponentRoamingManager.getInstance().setRoamingType(name, spec.roamingType());
        this.doAddComponent(name, component);
        if (this.optimizeTestLoading()) {
            return name;
        }
        Class<T> stateClass = ComponentStoreImpl.getComponentStateClass(component);
        Object state = null;
        StateStorage defaultsStorage = this.getDefaultsStorage();
        if (defaultsStorage != null) {
            state = defaultsStorage.getState(component, name, stateClass, null);
        }
        for (Storage storageSpec : storageSpecs = this.getComponentStorageSpecs(component, StateStorageOperation.READ)) {
            StateStorage stateStorage = this.getStateStorage(storageSpec);
            if (stateStorage == null || !stateStorage.hasState(component, name, stateClass, reloadData)) continue;
            state = stateStorage.getState(component, name, stateClass, state);
        }
        if (state != null) {
            component.loadState(state);
        }
        this.validateUnusedMacros(name, true);
        return name;
    }

    @NotNull
    private static <T> Class<T> getComponentStateClass(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStateClass"));
        }
        Class<PersistentStateComponent> persistentStateComponentClass = PersistentStateComponent.class;
        Class<?> componentClass = persistentStateComponent.getClass();
        block0: while (true) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = componentClass.getInterfaces()) {
                if (anInterface.equals(persistentStateComponentClass)) break block0;
            }
            componentClass = componentClass.getSuperclass();
        }
        Type type = ReflectionUtil.resolveVariable(persistentStateComponentClass.getTypeParameters()[0], componentClass);
        Class clazz = ReflectionUtil.getRawType((Type)type);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStateClass"));
        }
        return clazz;
    }

    public static String getComponentName(@NotNull PersistentStateComponent<?> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        return ComponentStoreImpl.getStateSpec(persistentStateComponent).name();
    }

    @NotNull
    private static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateSpec"));
        }
        Class<?> aClass = persistentStateComponent.getClass();
        State stateSpec = aClass.getAnnotation(State.class);
        if (stateSpec == null) {
            PluginId pluginId = PluginManagerCore.getPluginByClassName(aClass.getName());
            if (pluginId != null) {
                throw new PluginException("No @State annotation found in " + aClass, pluginId);
            }
            throw new RuntimeException("No @State annotation found in " + aClass);
        }
        State state = stateSpec;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateSpec"));
        }
        return state;
    }

    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> persistentStateComponent, StateStorageOperation operation) throws StateStorageException {
        Storage[] storageArray;
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        State stateSpec = ComponentStoreImpl.getStateSpec(persistentStateComponent);
        Storage[] storages = stateSpec.storages();
        if (storages.length == 1) {
            if (storages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storages;
        }
        assert (storages.length > 0);
        Class<StorageAnnotationsDefaultValues.NullStateStorageChooser> defaultClass = StorageAnnotationsDefaultValues.NullStateStorageChooser.class;
        Class storageChooserClass = stateSpec.storageChooser();
        StateStorageChooser<PersistentStateComponent<?>> defaultStateStorageChooser = this.getDefaultStateStorageChooser();
        assert (storageChooserClass != defaultClass || defaultStateStorageChooser != null) : "State chooser not specified for: " + persistentStateComponent.getClass();
        if (storageChooserClass == defaultClass) {
            Storage[] storageArray2 = defaultStateStorageChooser.selectStorages(storages, persistentStateComponent, operation);
            if (storageArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storageArray2;
        }
        try {
            StateStorageChooser storageChooser = (StateStorageChooser)storageChooserClass.newInstance();
            storageArray = storageChooser.selectStorages(storages, persistentStateComponent, operation);
        }
        catch (InstantiationException e) {
            throw new StateStorageException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StateStorageException((Throwable)e);
        }
        if (storageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        return storageArray;
    }

    protected boolean optimizeTestLoading() {
        return false;
    }

    @Nullable
    protected StateStorageChooser<PersistentStateComponent<?>> getDefaultStateStorageChooser() {
        return null;
    }

    @Override
    public boolean isReloadPossible(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "isReloadPossible"));
        }
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && ComponentStoreImpl.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reinitComponents(@NotNull Set<String> componentNames, boolean reloadData) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        for (String componentName : componentNames) {
            PersistentStateComponent component = (PersistentStateComponent)this.myComponents.get(componentName);
            if (component == null) continue;
            this.initPersistentComponent(component, reloadData);
        }
    }

    protected void doReload(Set<Pair<VirtualFile, StateStorage>> changedFiles, @NotNull Set<String> componentNames) throws StateStorageException {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "doReload"));
        }
        for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
            assert (pair != null);
            StateStorage storage = (StateStorage)pair.second;
            assert (storage != null) : "Null storage for: " + pair.first;
            storage.reload(componentNames);
        }
    }

    protected class SaveSessionImpl
    implements IComponentStore.SaveSession {
        protected StateStorageManager.SaveSession myStorageManagerSaveSession;

        public SaveSessionImpl() {
            ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFilesToSave(boolean includingSubStructures) throws IOException {
            List<IFile> list;
            try {
                list = this.myStorageManagerSaveSession.getAllStorageFilesToSave();
            }
            catch (StateStorageException e) {
                throw new IOException(e.getMessage());
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "getAllStorageFilesToSave"));
            }
            return list;
        }

        @Override
        @NotNull
        public IComponentStore.SaveSession save() throws IOException {
            try {
                SettingsSavingComponent[] settingsComponents;
                for (SettingsSavingComponent settingsSavingComponent : settingsComponents = ComponentStoreImpl.this.mySettingsSavingComponents.toArray(new SettingsSavingComponent[ComponentStoreImpl.this.mySettingsSavingComponents.size()])) {
                    try {
                        settingsSavingComponent.save();
                    }
                    catch (StateStorageException e) {
                        LOG.info((Throwable)e);
                        throw new IOException(e.getMessage());
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                this.myStorageManagerSaveSession.save();
            }
            catch (StateStorageException e) {
                LOG.info((Throwable)e);
                throw new IOException(e.getMessage());
            }
            SaveSessionImpl saveSessionImpl = this;
            if (saveSessionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "save"));
            }
            return saveSessionImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSave() {
            try {
                ComponentStoreImpl.this.getStateStorageManager().finishSave(this.myStorageManagerSaveSession);
                this.myStorageManagerSaveSession = null;
            }
            finally {
                ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
                ComponentStoreImpl.this.mySession = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            try {
                ComponentStoreImpl.this.getStateStorageManager().reset();
                this.myStorageManagerSaveSession = null;
            }
            finally {
                ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
                ComponentStoreImpl.this.mySession = null;
            }
        }

        protected void commit() throws StateStorageException {
            StateStorageManager storageManager = ComponentStoreImpl.this.getStateStorageManager();
            StateStorageManager.ExternalizationSession session = storageManager.startExternalization();
            Object[] names = ArrayUtil.toStringArray(ComponentStoreImpl.this.myComponents.keySet());
            Arrays.sort(names);
            for (Object name : names) {
                Object component = ComponentStoreImpl.this.myComponents.get(name);
                if (component instanceof PersistentStateComponent) {
                    ComponentStoreImpl.this.commitPersistentComponent((PersistentStateComponent)component, session);
                    continue;
                }
                if (!(component instanceof JDOMExternalizable)) continue;
                session.setStateInOldStorage(component, ComponentManagerImpl.getComponentName(component), component);
            }
            this.myStorageManagerSaveSession = storageManager.startSave(session);
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            if (changedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "analyzeExternalChanges"));
            }
            return this.myStorageManagerSaveSession.analyzeExternalChanges(changedFiles);
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFiles(boolean includingSubStructures) {
            List<IFile> list = this.myStorageManagerSaveSession.getAllStorageFiles();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "getAllStorageFiles"));
            }
            return list;
        }
    }
}

