/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentSerializationUtil {
    public static Class getStateClass(Class<? extends PersistentStateComponent> aClass) {
        TypeVariable variable = PersistentStateComponent.class.getTypeParameters()[0];
        return ReflectionUtil.getRawType((Type)ReflectionUtil.resolveVariableInHierarchy(variable, aClass));
    }

    public static <S> void loadComponentState(@NotNull PersistentStateComponent<S> configuration, @Nullable Element element) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/ComponentSerializationUtil", "loadComponentState"));
        }
        if (element != null) {
            Class stateClass = ComponentSerializationUtil.getStateClass(configuration.getClass());
            configuration.loadState(XmlSerializer.deserialize((Element)element, (Class)stateClass));
        }
    }
}

