/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.AbnormalCommandTerminationException;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandProcessorImpl
extends CommandProcessorEx {
    private CommandDescriptor myCurrentCommand = null;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount = 0;

    public void executeCommand(@NotNull Runnable runnable, String name, Object groupId) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        this.executeCommand(null, runnable, name, groupId);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId, Document document) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/command/impl/CommandProcessorImpl", "executeCommand"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project, name, groupId, confirmationPolicy, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(project, this.myCurrentCommand, throwable);
        }
    }

    @Override
    @Nullable
    public Object startCommand(Project project, @Nls String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null;
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCommand(Project project, Object command, Throwable throwable) {
        boolean failed;
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, (Object)"no current command in progress");
        if (this.myCurrentCommand != command) {
            return;
        }
        try {
            if (throwable instanceof AbnormalCommandTerminationException) {
                AbnormalCommandTerminationException rollback = (AbnormalCommandTerminationException)throwable;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException((Throwable)rollback);
                }
                failed = true;
            } else if (throwable != null) {
                failed = true;
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                CommandLog.LOG.error(throwable);
            } else {
                failed = false;
            }
        }
        finally {
            this.fireCommandFinished();
        }
        if (failed) {
            if (project != null) {
                FileEditor editor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
                UndoManager undoManager = UndoManager.getInstance((Project)project);
                if (undoManager.isUndoAvailable(editor)) {
                    undoManager.undo(editor);
                }
            }
            Messages.showErrorDialog((Project)project, (String)"Cannot perform operation. Too complex, sorry.", (String)"Failed to Perform Operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myDocument);
        try {
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.beforeCommandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
        finally {
            this.myCurrentCommand = null;
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.commandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
    }

    @Override
    public void enterModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push(currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null, (Object)("Command must not run: " + String.valueOf(this.myCurrentCommand)));
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name;
    }

    public void setCurrentCommandGroupId(Object groupId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId;
    }

    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    public void addCommandListener(@NotNull CommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addCommandListener"));
        }
        this.myListeners.add(listener);
    }

    public void addCommandListener(final @NotNull CommandListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addCommandListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addCommandListener"));
        }
        this.addCommandListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CommandProcessorImpl.this.removeCommandListener(listener);
            }
        });
    }

    public void removeCommandListener(@NotNull CommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/impl/CommandProcessorImpl", "removeCommandListener"));
        }
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUndoTransparentAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/impl/CommandProcessorImpl", "runUndoTransparentAction"));
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.fireUndoTransparentStarted();
        }
        try {
            action.run();
        }
        finally {
            if (--this.myUndoTransparentCount == 0) {
                this.fireUndoTransparentFinished();
            }
        }
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(Project project) {
        CommandProcessorImpl.getUndoManager(project).markCurrentCommandAsGlobal();
    }

    private static UndoManagerImpl getUndoManager(Project project) {
        return (UndoManagerImpl)(project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance());
    }

    public void addAffectedDocuments(Project project, Document ... docs) {
        if (docs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addAffectedDocuments"));
        }
        CommandProcessorImpl.getUndoManager(project).addAffectedDocuments(docs);
    }

    public void addAffectedFiles(Project project, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addAffectedFiles"));
        }
        CommandProcessorImpl.getUndoManager(project).addAffectedFiles(files);
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myDocument);
        for (CommandListener listener : this.myListeners) {
            try {
                listener.commandStarted(event);
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentStarted() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionStarted();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentFinished() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionFinished();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private static class CommandDescriptor {
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;

        public CommandDescriptor(Runnable command, Project project, String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
            this.myCommand = command;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myDocument = document;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }
    }
}

