/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.WindowsCommandLineListener;
import com.intellij.ide.WindowsCommandLineProcessor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.ApplicationPathMacroManager;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.components.impl.stores.StoresFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiLock;
import com.intellij.ui.Splash;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ApplicationImpl
extends PlatformComponentManagerImpl
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.impl.ApplicationImpl");
    private final ModalityState MODALITY_STATE_NONE;
    private final ReentrantReadWriteLock myLock;
    private final ModalityInvokator myInvokator;
    private final EventDispatcher<ApplicationListener> myDispatcher;
    private IApplicationStore myComponentStore;
    private boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final String myName;
    private final Stack<Class> myWriteActionsStack;
    private volatile Runnable myExceptionalThreadWithReadAccessRunnable;
    private int myInEditorPaintCounter;
    private long myStartTime;
    @Nullable
    private Splash mySplash;
    private boolean myDoNotSave;
    private volatile boolean myDisposeInProgress;
    private final Disposable myLastDisposable;
    private final AtomicBoolean mySaveSettingsIsInProgress;
    private static final int ourDumpThreadsOnLongWriteActionWaiting = Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);
    private final AtomicInteger myAliveThreads;
    private static final int ourReasonableThreadPoolSize = Registry.intValue((String)"core.pooled.threads");
    private final ExecutorService ourThreadExecutorsService;
    private boolean myIsFiringLoadingEvent;
    private boolean myLoaded;
    @NonNls
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private Boolean myActive;
    private static final ThreadLocal<Integer> ourEdtSafe = new ThreadLocal();
    @NonNls
    private static final ModalityState ANY = new ModalityState(){

        public boolean dominates(@NotNull ModalityState anotherState) {
            if (anotherState == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl$2", "dominates"));
            }
            return false;
        }

        @NonNls
        public String toString() {
            return "ANY";
        }
    };
    private static Thread ourDispatchThread = null;
    private final Object lock;
    private static volatile boolean exiting = false;
    private static final ThreadLocal<Boolean> exceptionalThreadWithReadAccessFlag = new ThreadLocal();

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "bootstrapPicoContainer"));
        }
        super.bootstrapPicoContainer(name);
        this.getPicoContainer().registerComponentImplementation(IComponentStore.class, StoresFactory.getApplicationStoreClass());
        this.getPicoContainer().registerComponentImplementation(ApplicationPathMacroManager.class);
    }

    @NotNull
    public synchronized IApplicationStore getStateStore() {
        if (this.myComponentStore == null) {
            this.myComponentStore = (IApplicationStore)this.getPicoContainer().getComponentInstance(IComponentStore.class);
        }
        IApplicationStore iApplicationStore = this.myComponentStore;
        if (iApplicationStore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getStateStore"));
        }
        return iApplicationStore;
    }

    @Override
    public void initializeComponent(Object component, boolean service) {
        this.getStateStore().initComponent(component, service);
    }

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine, @NotNull String appName, @Nullable Splash splash) {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/application/impl/ApplicationImpl", "<init>"));
        }
        super(null);
        this.MODALITY_STATE_NONE = ModalityState.NON_MODAL;
        this.myLock = new ReentrantReadWriteLock(false);
        this.myInvokator = new ModalityInvokatorImpl();
        this.myDispatcher = EventDispatcher.create(ApplicationListener.class);
        this.myWriteActionsStack = new Stack();
        this.myInEditorPaintCounter = 0;
        this.myStartTime = 0L;
        this.myDisposeInProgress = false;
        this.myLastDisposable = Disposer.newDisposable();
        this.mySaveSettingsIsInProgress = new AtomicBoolean(false);
        this.myAliveThreads = new AtomicInteger(0);
        this.ourThreadExecutorsService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            int i;

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl$1", "newThread"));
                }
                int count = ApplicationImpl.this.myAliveThreads.incrementAndGet();
                Thread thread = new Thread(r, "ApplicationImpl pooled thread " + this.i++){

                    @Override
                    public void interrupt() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Interrupted worker, will remove from pool");
                        }
                        super.interrupt();
                    }

                    @Override
                    public void run() {
                        block2: {
                            try {
                                super.run();
                            }
                            catch (Throwable t) {
                                if (!LOG.isDebugEnabled()) break block2;
                                LOG.debug("Worker exits due to exception", t);
                            }
                        }
                        ApplicationImpl.this.myAliveThreads.decrementAndGet();
                    }
                };
                if (ApplicationInfoImpl.getShadowInstance().isEAP() && count > ourReasonableThreadPoolSize) {
                    LOG.info("Not enough pooled threads; dumping threads into a file");
                    PerformanceWatcher.getInstance().dumpThreads(true);
                }
                thread.setPriority(4);
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$1", "newThread"));
                }
                return thread2;
            }
        });
        this.myIsFiringLoadingEvent = false;
        this.myLoaded = false;
        this.lock = new Object();
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
        this.getPicoContainer().registerComponentInstance(Application.class, (Object)this);
        IconLoader.STRICT = isUnitTestMode || isInternal;
        BundleBase.assertKeyIsFound = IconLoader.STRICT;
        AWTExceptionHandler.register();
        String debugDisposer = System.getProperty("idea.disposer.debug");
        Disposer.setDebugMode(((isInternal || isUnitTestMode || "on".equals(debugDisposer)) && !"off".equals(debugDisposer) ? 1 : 0) != 0);
        this.myStartTime = System.currentTimeMillis();
        this.mySplash = splash;
        this.myName = appName;
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        this.myDoNotSave = this.myTestModeFlag || this.myHeadlessMode;
        this.loadApplicationComponents();
        if (this.myTestModeFlag) {
            this.registerShutdownHook();
        }
        if (!isUnitTestMode && !isHeadless) {
            Disposer.register((Disposable)this, (Disposable)Disposer.newDisposable(), (String)"ui");
            StartupUtil.addExternalInstanceListener(new Consumer<List<String>>(){

                public void consume(final List<String> args) {
                    ApplicationImpl.this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("ApplicationImpl.externalInstanceListener invocation");
                            String currentDirectory = args.isEmpty() ? null : (String)args.get(0);
                            List realArgs = args.isEmpty() ? args : args.subList(1, args.size());
                            Project project = CommandLineProcessor.processExternalCommandLine(realArgs, currentDirectory);
                            JFrame frame = project != null ? (JFrame)WindowManager.getInstance().getIdeFrame(project) : WindowManager.getInstance().findVisibleFrame();
                            if (frame != null) {
                                frame.requestFocus();
                            }
                        }
                    });
                }
            });
            WindowsCommandLineProcessor.LISTENER = new WindowsCommandLineListener(){

                public void processWindowsLauncherCommandLine(final String currentDirectory, final String commandLine) {
                    LOG.info("Received external Windows command line: current directory " + currentDirectory + ", command line " + commandLine);
                    ApplicationImpl.this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List args = StringUtil.splitHonorQuotes((String)commandLine, (char)' ');
                            args.remove(0);
                            CommandLineProcessor.processExternalCommandLine(args, currentDirectory);
                        }
                    });
                }
            };
        }
    }

    private void registerShutdownHook() {
        ShutDownTracker.getInstance();
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (ApplicationImpl.this.isDisposed() || ApplicationImpl.this.isDisposeInProgress()) {
                    return;
                }
                ShutDownTracker.invokeAndWait((boolean)ApplicationImpl.this.isUnitTestMode(), (boolean)true, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (ApplicationManager.getApplication() != ApplicationImpl.this) {
                            return;
                        }
                        try {
                            ApplicationImpl.this.myDisposeInProgress = true;
                            ApplicationImpl.this.saveAll();
                        }
                        finally {
                            if (!ApplicationImpl.this.disposeSelf(true)) {
                                ApplicationImpl.this.myDisposeInProgress = false;
                            }
                        }
                    }
                });
            }
        });
    }

    private boolean disposeSelf(final boolean checkCanCloseProject) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        final boolean[] canClose = new boolean[]{true};
        for (final Project project : ProjectManagerEx.getInstanceEx().getOpenProjects()) {
            try {
                commandProcessor.executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        ProjectManagerImpl manager = (ProjectManagerImpl)ProjectManagerEx.getInstanceEx();
                        if (!manager.closeProject(project, true, true, checkCanCloseProject)) {
                            canClose[0] = false;
                        }
                    }
                }, ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]), null);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (canClose[0]) continue;
            return false;
        }
        this.runWriteAction(new Runnable(){

            @Override
            public void run() {
                Disposer.dispose((Disposable)ApplicationImpl.this);
            }
        });
        Disposer.assertIsEmpty();
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getName"));
        }
        return string;
    }

    @Override
    public boolean holdsReadLock() {
        return this.myLock.getReadHoldCount() != 0;
    }

    private void loadApplicationComponents() {
        IdeaPluginDescriptor[] plugins;
        PluginManagerCore.initPlugins(this.mySplash);
        for (IdeaPluginDescriptor plugin : plugins = PluginManagerCore.getPlugins()) {
            if (PluginManagerCore.shouldSkipPlugin(plugin)) continue;
            this.loadComponentsConfiguration(plugin.getAppComponents(), (PluginDescriptor)plugin, false);
        }
    }

    @Override
    protected synchronized Object createComponent(Class componentInterface) {
        Object component = super.createComponent(componentInterface);
        if (this.mySplash != null) {
            this.mySplash.showProgress("", 0.65f + this.getPercentageOfComponentsLoaded() * 0.35f);
        }
        return component;
    }

    @Override
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getRootArea().getPicoContainer();
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public void setUnitTestMode(boolean testModeFlag) {
        this.myTestModeFlag = testModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        Future<?> future = this.ourThreadExecutorsService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (ProcessCanceledException e) {
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    Thread.interrupted();
                }
            }
        });
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        return future;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        Future future = this.ourThreadExecutorsService.submit(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() {
                try {
                    Object v = action.call();
                    return v;
                }
                catch (ProcessCanceledException e) {
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    Thread.interrupted();
                }
                return null;
            }
        });
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        return future;
    }

    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getInvokator"));
        }
        return modalityInvokator;
    }

    public void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable);
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable, expired);
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable, state);
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable, state, expired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String path) throws IOException, InvalidDataException {
        this.getStateStore().setOptionsPath(path);
        this.getStateStore().setConfigPath(PathManager.getConfigPath());
        this.myIsFiringLoadingEvent = true;
        try {
            this.fireBeforeApplicationLoaded();
        }
        finally {
            this.myIsFiringLoadingEvent = false;
        }
        HeavyProcessLatch.INSTANCE.processStarted();
        try {
            this.getStateStore().load();
        }
        catch (StateStorageException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            HeavyProcessLatch.INSTANCE.processFinished();
        }
        this.myLoaded = true;
        ApplicationImpl.createLocatorFile();
    }

    private static void createLocatorFile() {
        File locatorFile = new File(PathManager.getSystemPath() + "/" + ".home");
        try {
            byte[] data = PathManager.getHomePath().getBytes("UTF-8");
            FileUtil.writeToFile((File)locatorFile, (byte[])data);
        }
        catch (IOException e) {
            LOG.warn("can't store a location in '" + locatorFile + "'", (Throwable)e);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.myLoaded;
    }

    @Override
    protected <T> T getComponentFromContainer(Class<T> interfaceClass) {
        if (this.myIsFiringLoadingEvent) {
            return null;
        }
        return super.getComponentFromContainer(interfaceClass);
    }

    private void fireBeforeApplicationLoaded() {
        for (ApplicationLoadListener listener : (ApplicationLoadListener[])ApplicationLoadListener.EP_NAME.getExtensions()) {
            try {
                listener.beforeApplicationLoaded(this);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        this.fireApplicationExiting();
        ShutDownTracker.getInstance().ensureStopperThreadsFinished();
        this.disposeComponents();
        this.ourThreadExecutorsService.shutdownNow();
        this.myComponentStore = null;
        super.dispose();
        Disposer.dispose((Disposable)this.myLastDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeChangesVisibleToEDT() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.hashCode();
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, Project project) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, parentComponent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent, String cancelText) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        this.assertIsDispatchThread();
        if (this.myExceptionalThreadWithReadAccessRunnable != null || this.isUnitTestMode() || this.isHeadlessEnvironment()) {
            try {
                ProgressManager.getInstance().runProcess(process, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            return true;
        }
        final ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        try {
            this.myExceptionalThreadWithReadAccessRunnable = process;
            final AtomicBoolean threadStarted = new AtomicBoolean();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable != process) {
                        LOG.error("myExceptionalThreadWithReadAccessRunnable != process, process = " + ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable);
                    }
                    ApplicationImpl.this.executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable != process) {
                                LOG.error("myExceptionalThreadWithReadAccessRunnable != process, process = " + ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable);
                            }
                            boolean old = ApplicationImpl.setExceptionalThreadWithReadAccessFlag(true);
                            LOG.assertTrue(ApplicationImpl.this.isReadAccessAllowed());
                            try {
                                ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progress);
                            }
                            catch (ProcessCanceledException e) {
                                progress.cancel();
                            }
                            catch (RuntimeException e) {
                                progress.cancel();
                                throw e;
                            }
                            finally {
                                ApplicationImpl.setExceptionalThreadWithReadAccessFlag(old);
                                ApplicationImpl.this.makeChangesVisibleToEDT();
                            }
                        }
                    });
                    threadStarted.set(true);
                }
            });
            progress.startBlocking();
            LOG.assertTrue(threadStarted.get());
            LOG.assertTrue(!progress.isRunning());
        }
        finally {
            this.myExceptionalThreadWithReadAccessRunnable = null;
            this.makeChangesVisibleToEDT();
        }
        return !progress.isCanceled();
    }

    public void invokeAndWait(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        if (this.isDispatchThread()) {
            runnable.run();
            return;
        }
        if (!ApplicationImpl.isExceptionalThreadWithReadAccess() && this.holdsReadLock()) {
            LOG.error("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        LaterInvocator.invokeAndWait(runnable, modalityState);
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        Object[] entities = LaterInvocator.getCurrentModalEntities();
        ModalityStateEx modalityStateEx = entities.length > 0 ? new ModalityStateEx(entities) : this.getNoneModalityState();
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getCurrentModalityState"));
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        Window window;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
        }
        Window window2 = window = c instanceof Window ? (Window)c : SwingUtilities.windowForComponent(c);
        if (window == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow(window);
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
        }
        return modalityStateEx;
    }

    public ModalityState getAnyModalityState() {
        return ANY;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        if (EventQueue.isDispatchThread()) {
            ModalityState modalityState = this.getCurrentModalityState();
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getDefaultModalityState"));
            }
            return modalityState;
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        ModalityState modalityState = progress == null ? this.getNoneModalityState() : progress.getModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getDefaultModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = this.MODALITY_STATE_NONE;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getNoneModalityState"));
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        return IdeEventQueue.getInstance().getIdleTime();
    }

    public void exit() {
        this.exit(false);
    }

    @Override
    public void exit(boolean force) {
        this.exit(force, true, false);
    }

    public void restart() {
        this.restart(false);
    }

    @Override
    public void restart(boolean force) {
        this.exit(force, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(final boolean force, final boolean allowListenersToCancel, final boolean restart) {
        if (exiting) {
            return;
        }
        exiting = true;
        try {
            if (!force && this.getDefaultModalityState() != ModalityState.NON_MODAL) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!ApplicationImpl.confirmExitIfNeeded(force)) {
                        ApplicationImpl.this.saveAll();
                        return;
                    }
                    ((AppLifecycleListener)ApplicationImpl.this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).appClosing();
                    ApplicationImpl.this.myDisposeInProgress = true;
                    if (!ApplicationImpl.this.doExit(allowListenersToCancel, restart)) {
                        ApplicationImpl.this.myDisposeInProgress = false;
                    }
                }
            };
            if (!this.isDispatchThread()) {
                this.invokeLater(runnable, ModalityState.NON_MODAL);
            } else {
                runnable.run();
            }
        }
        finally {
            exiting = false;
        }
    }

    private boolean doExit(boolean allowListenersToCancel, boolean restart) {
        this.saveSettings();
        if (allowListenersToCancel && !this.canExit()) {
            return false;
        }
        boolean success = this.disposeSelf(allowListenersToCancel);
        if (!success || this.isUnitTestMode()) {
            return false;
        }
        int exitCode = 0;
        if (restart && Restarter.isSupported()) {
            try {
                exitCode = Restarter.scheduleRestart((String[])new String[0]);
            }
            catch (IOException e) {
                LOG.warn("Cannot restart", (Throwable)e);
            }
        }
        System.exit(exitCode);
        return true;
    }

    private static boolean confirmExitIfNeeded(boolean force) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (force && !hasUnsafeBgTasks) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value, int exitCode) {
                GeneralSettings.getInstance().setConfirmExit(value);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            public String getDoNotShowMessage() {
                return "Do not ask me again";
            }
        };
        if (hasUnsafeBgTasks || option.isToBeShown()) {
            String message = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(option)).show() != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = (ProjectManagerEx)ProjectManager.getInstance();
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReadAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            action.run();
        } else {
            ApplicationImpl.assertReadActionAllowed();
            try {
                this.myLock.readLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            try {
                action.run();
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            return (T)computation.compute();
        }
        ApplicationImpl.assertReadActionAllowed();
        try {
            this.myLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            return (T)computation.compute();
        }
        ApplicationImpl.assertReadActionAllowed();
        try {
            this.myLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private static boolean isExceptionalThreadWithReadAccess() {
        Boolean flag = exceptionalThreadWithReadAccessFlag.get();
        return flag == Boolean.TRUE;
    }

    public static boolean setExceptionalThreadWithReadAccessFlag(boolean flag) {
        boolean old = ApplicationImpl.isExceptionalThreadWithReadAccess();
        if (flag) {
            exceptionalThreadWithReadAccessFlag.set(Boolean.TRUE);
        } else {
            exceptionalThreadWithReadAccessFlag.remove();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriteAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        AccessToken token = this.acquireWriteActionLock(action.getClass());
        try {
            action.run();
        }
        finally {
            token.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        AccessToken token = this.acquireWriteActionLock(computation.getClass());
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            token.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        AccessToken token = this.acquireWriteActionLock(computation.getClass());
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            token.finish();
        }
    }

    public boolean hasWriteAction(@Nullable Class<?> actionClass) {
        ApplicationImpl.assertCanRunWriteAction();
        for (int i = this.myWriteActionsStack.size() - 1; i >= 0; --i) {
            Class action = (Class)this.myWriteActionsStack.get(i);
            if (actionClass != action && (action == null || actionClass == null || !ReflectionUtil.isAssignable(actionClass, (Class)action))) continue;
            return true;
        }
        return false;
    }

    public void assertReadAccessAllowed() {
        if (this.myHeadlessMode) {
            return;
        }
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from event dispatch thread or inside read-action only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "Our dispatch thread:" + ApplicationImpl.describe(ourDispatchThread), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    @NonNls
    private static String describe(Thread o) {
        if (o == null) {
            return "null";
        }
        return o.toString() + " " + System.identityHashCode(o);
    }

    @Nullable
    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = EventQueue.class.getDeclaredMethod("getDispatchThread", new Class[0]);
            method.setAccessible(true);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isReadAccessAllowed() {
        Thread currentThread = Thread.currentThread();
        return ourDispatchThread == currentThread || ApplicationImpl.isExceptionalThreadWithReadAccess() || this.holdsReadLock() || this.isDispatchThread();
    }

    private static void assertCanRunWriteAction() {
        ApplicationImpl.assertIsDispatchThread("Write access is allowed from event dispatch thread only");
    }

    public void assertIsDispatchThread() {
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        Integer safeCounter = ourEdtSafe.get();
        if (safeCounter != null && safeCounter > 0) {
            return;
        }
        ApplicationImpl.assertIsDispatchThread("Access is allowed from event dispatch thread only.");
    }

    private static void assertIsDispatchThread(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "assertIsDispatchThread"));
        }
        Thread currentThread = Thread.currentThread();
        if (ourDispatchThread == currentThread) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            ourDispatchThread = currentThread;
        }
        if (ourDispatchThread == currentThread) {
            return;
        }
        LOG.error(message, new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "Our dispatch thread:" + ApplicationImpl.describe(ourDispatchThread), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runEdtSafeAction(@NotNull Runnable runnable) {
        Integer n;
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "runEdtSafeAction"));
        }
        Integer value = ourEdtSafe.get();
        if (value == null) {
            value = 0;
        }
        ourEdtSafe.set(value + 1);
        try {
            runnable.run();
            int newValue = ourEdtSafe.get() - 1;
            n = newValue >= 1 ? Integer.valueOf(newValue) : null;
        }
        catch (Throwable throwable) {
            int newValue = ourEdtSafe.get() - 1;
            ourEdtSafe.set(newValue >= 1 ? Integer.valueOf(newValue) : null);
            throw throwable;
        }
        ourEdtSafe.set(n);
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component) {
        if (component == null) {
            return;
        }
        Thread curThread = Thread.currentThread();
        if (ourDispatchThread == curThread) {
            return;
        }
        if (Boolean.TRUE.equals(component.getClientProperty(WAS_EVER_SHOWN))) {
            this.assertIsDispatchThread();
        } else {
            JRootPane root = component.getRootPane();
            if (root != null) {
                component.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                this.assertIsDispatchThread();
            }
        }
    }

    @Override
    public void assertTimeConsuming() {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        LOG.assertTrue(!this.isDispatchThread(), (Object)"This operation is time consuming and must not be called on EDT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRunReadAction(@NotNull Runnable action) {
        boolean mustAcquire;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "tryRunReadAction"));
        }
        boolean bl = mustAcquire = !this.isReadAccessAllowed();
        if (mustAcquire) {
            LOG.assertTrue(this.myTestModeFlag || !Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing readAction");
            try {
                if (!this.myLock.readLock().tryLock(0L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
        try {
            action.run();
        }
        finally {
            if (mustAcquire) {
                this.myLock.readLock().unlock();
            }
        }
        return true;
    }

    public boolean tryToApplyActivationState(boolean active, Window window) {
        Component frame = UIUtil.findUltimateParent((Component)window);
        if (frame instanceof IdeFrame) {
            IdeFrame ideFrame = (IdeFrame)frame;
            if (this.isActive() != active) {
                this.myActive = active;
                System.setProperty("idea.active", this.myActive.toString());
                ApplicationActivationListener publisher = (ApplicationActivationListener)this.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC);
                if (active) {
                    publisher.applicationActivated(ideFrame);
                } else {
                    publisher.applicationDeactivated(ideFrame);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        if (this.isUnitTestMode()) {
            return true;
        }
        if (this.myActive == null) {
            Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            return active != null;
        }
        return this.myActive;
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        if (this.isReadAccessAllowed()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireReadActionLock"));
            }
            return accessToken;
        }
        ReadAccessToken readAccessToken = new ReadAccessToken();
        if (readAccessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireReadActionLock"));
        }
        return readAccessToken;
    }

    @NotNull
    public AccessToken acquireWriteActionLock(Class clazz) {
        WriteAccessToken writeAccessToken = new WriteAccessToken(clazz);
        if (writeAccessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireWriteActionLock"));
        }
        return writeAccessToken;
    }

    private static void assertReadActionAllowed() {
        LOG.assertTrue(!Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing readAction");
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.myLock.writeLock().isHeldByCurrentThread();
    }

    public void editorPaintStart() {
        ++this.myInEditorPaintCounter;
    }

    public void editorPaintFinish() {
        --this.myInEditorPaintCounter;
        LOG.assertTrue(this.myInEditorPaintCounter >= 0);
    }

    public void addApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(@NotNull ApplicationListener l, @NotNull Disposable parent) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "removeApplicationListener"));
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireApplicationExiting() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
    }

    private void fireBeforeWriteActionStart(Class action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart((Object)action);
    }

    private void fireWriteActionStarted(Class action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted((Object)action);
    }

    private void fireWriteActionFinished(Class action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished((Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _saveSettings() {
        if (this.mySaveSettingsIsInProgress.compareAndSet(false, true)) {
            try {
                StoreUtil.doSave(this.getStateStore());
            }
            catch (Throwable ex) {
                if (this.isUnitTestMode()) {
                    System.out.println("Saving application settings failed");
                    ex.printStackTrace();
                } else {
                    LOG.info("Saving application settings failed", ex);
                    this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ex instanceof PluginException) {
                                PluginException pluginException = (PluginException)ex;
                                PluginManagerCore.disablePlugin(pluginException.getPluginId().getIdString());
                                Messages.showMessageDialog((String)("The plugin " + pluginException.getPluginId() + " failed to save settings and has been disabled. Please restart " + ApplicationNamesInfo.getInstance().getFullProductName()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                            } else {
                                Messages.showMessageDialog((String)ApplicationBundle.message((String)"application.save.settings.error", (Object[])new Object[]{ex.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                            }
                        }
                    });
                }
            }
            finally {
                this.mySaveSettingsIsInProgress.set(false);
            }
        }
    }

    public void saveSettings() {
        if (this.myDoNotSave) {
            return;
        }
        this._saveSettings();
    }

    public void saveAll() {
        Project[] openProjects;
        if (this.myDoNotSave) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            ProjectEx project = (ProjectEx)openProject;
            project.save();
        }
        this.saveSettings();
    }

    @Override
    public void doNotSave() {
        this.doNotSave(true);
    }

    @Override
    public void doNotSave(boolean value) {
        this.myDoNotSave = value;
    }

    @Override
    public boolean isDoNotSave() {
        return this.myDoNotSave;
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ApplicationImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getRootArea().getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getExtensions"));
        }
        return objectArray;
    }

    public boolean isDisposeInProgress() {
        return this.myDisposeInProgress || ShutDownTracker.isShutdownHookRunning();
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public void setDisposeInProgress(boolean disposeInProgress) {
        this.myDisposeInProgress = disposeInProgress;
    }

    @NonNls
    public String toString() {
        return "Application" + (this.isDisposed() ? " (Disposed)" : "") + (this.isUnitTestMode() ? " (Unit test)" : "") + (this.isInternal() ? " (Internal)" : "") + (this.isHeadlessEnvironment() ? " (Headless)" : "") + (this.isCommandLine() ? " (Command line)" : "");
    }

    private class ReadAccessToken
    extends AccessToken {
        private ReadAccessToken() {
            ApplicationImpl.assertReadActionAllowed();
            try {
                ApplicationImpl.this.myLock.readLock().lockInterruptibly();
                this.acquired();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }

        public void finish() {
            ApplicationImpl.this.myLock.readLock().unlock();
            this.released();
        }
    }

    private class WriteAccessToken
    extends AccessToken {
        private final Class clazz;

        public WriteAccessToken(Class _clazz) {
            this.clazz = _clazz;
            ApplicationImpl.assertCanRunWriteAction();
            ActivityTracker.getInstance().inc();
            ApplicationImpl.this.fireBeforeWriteActionStart(_clazz);
            final AtomicBoolean stopped = new AtomicBoolean(false);
            LOG.assertTrue(ApplicationImpl.this.isWriteAccessAllowed() || !Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing writeAction");
            try {
                if (!ApplicationImpl.this.myLock.writeLock().tryLock()) {
                    if (ourDumpThreadsOnLongWriteActionWaiting > 0) {
                        ApplicationImpl.this.executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                while (!stopped.get()) {
                                    TimeoutUtil.sleep((long)ourDumpThreadsOnLongWriteActionWaiting);
                                    if (stopped.get()) continue;
                                    PerformanceWatcher.getInstance().dumpThreads(true);
                                }
                            }
                        });
                    }
                    ApplicationImpl.this.myLock.writeLock().lockInterruptibly();
                }
                this.acquired();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            stopped.set(true);
            ApplicationImpl.this.myWriteActionsStack.push((Object)_clazz);
            ApplicationImpl.this.fireWriteActionStarted(_clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            try {
                ApplicationImpl.this.fireWriteActionFinished(this.clazz);
                ApplicationImpl.this.myWriteActionsStack.pop();
            }
            finally {
                ApplicationImpl.this.myLock.writeLock().unlock();
                this.released();
            }
        }

        protected void acquired() {
            String id = this.id();
            if (id != null) {
                Thread thread = Thread.currentThread();
                thread.setName(thread.getName() + id);
            }
        }

        protected void released() {
            String id = this.id();
            if (id != null) {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                name = StringUtil.replace((String)name, (String)id, (String)"");
                thread.setName(name);
            }
        }

        private String id() {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            while (name == null) {
                aClass = aClass.getSuperclass();
                name = aClass.getName();
            }
            name = name.substring(name.lastIndexOf(46) + 1);
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
                return " [" + name + "]";
            }
            return null;
        }
    }
}

