/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class ImportOldConfigsPanel
extends JDialog {
    private TextFieldWithBrowseButton myPrevInstallation;
    private JRadioButton myRbDoNotImport;
    private JRadioButton myRbImport;
    private JPanel myRootPanel;
    private File myLastSelection = null;
    private JButton myOkButton;
    private JLabel mySuggestLabel;
    private JLabel myHomeLabel;
    private JRadioButton myRbImportAuto;
    private final File myGuessedOldConfig;
    private final ConfigImportSettings mySettings;

    public ImportOldConfigsPanel(File guessedOldConfig, ConfigImportSettings settings) {
        super((Dialog)null, true);
        this.myGuessedOldConfig = guessedOldConfig;
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.init();
    }

    private void init() {
        String prevInstall;
        new MnemonicHelper().register((Component)this.getContentPane());
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbDoNotImport);
        group.add(this.myRbImport);
        group.add(this.myRbImportAuto);
        this.myRbDoNotImport.setSelected(true);
        String productName = this.mySettings.getProductName(ThreeState.UNSURE);
        this.mySuggestLabel.setText(this.mySettings.getTitleLabel(productName));
        this.myRbDoNotImport.setText(this.mySettings.getDoNotImportLabel(productName));
        if (this.myGuessedOldConfig != null) {
            this.myRbImportAuto.setText(this.mySettings.getAutoImportLabel(this.myGuessedOldConfig));
            this.myRbImportAuto.setSelected(true);
        } else {
            this.myRbImportAuto.setVisible(false);
        }
        this.myHomeLabel.setText(this.mySettings.getHomeLabel(productName));
        this.myRbImport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportOldConfigsPanel.this.update();
            }
        });
        if (this.myGuessedOldConfig != null) {
            this.myPrevInstallation.setText(this.myGuessedOldConfig.getParent());
        } else if (SystemInfo.isMac) {
            this.myPrevInstallation.setText(ImportOldConfigsPanel.findPreviousInstallationMac(productName));
        } else if (SystemInfo.isWindows && (prevInstall = ImportOldConfigsPanel.findPreviousInstallationWindows(productName)) != null) {
            this.myPrevInstallation.setText(prevInstall);
        }
        this.myPrevInstallation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                JFileChooser fc = ImportOldConfigsPanel.this.myLastSelection != null ? new JFileChooser(ImportOldConfigsPanel.this.myLastSelection) : new JFileChooser();
                fc.setFileSelectionMode(SystemInfo.isMac ? 2 : 1);
                fc.setFileHidingEnabled(!SystemInfo.isLinux);
                int returnVal = fc.showOpenDialog(ImportOldConfigsPanel.this);
                if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
                    ImportOldConfigsPanel.this.myLastSelection = file;
                    ImportOldConfigsPanel.this.myPrevInstallation.setText(file.getAbsolutePath());
                }
            }
        });
        this.myOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOldConfigsPanel.this.close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myRootPanel);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.setTitle(ApplicationBundle.message((String)"title.complete.installation", (Object[])new Object[0]));
        this.update();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void update() {
        this.myPrevInstallation.setEnabled(this.myRbImport.isSelected());
    }

    @Nullable
    private static String findPreviousInstallationWindows(String productName) {
        String programFiles = System.getenv("ProgramFiles");
        if (programFiles != null) {
            File[] files;
            File jetbrainsHome = new File(programFiles, "JetBrains");
            File[] fileArray = files = jetbrainsHome.isDirectory() ? jetbrainsHome.listFiles() : null;
            if (files != null) {
                String latestVersion = null;
                File latestFile = null;
                for (File file : files) {
                    if (!file.isDirectory() || !file.getName().startsWith(productName)) continue;
                    String versionName = file.getName().substring(productName.length()).trim();
                    if (latestVersion != null && StringUtil.compareVersionNumbers((String)latestVersion, (String)versionName) <= 0) continue;
                    latestVersion = versionName;
                    latestFile = file;
                }
                if (latestFile != null) {
                    return latestFile.getAbsolutePath();
                }
            }
        }
        return null;
    }

    private static String findPreviousInstallationMac(String productName) {
        String mostProbable = "/Applications/" + productName;
        return new File(mostProbable).exists() ? mostProbable : "/Applications";
    }

    private void close() {
        if (this.myRbImport.isSelected()) {
            String instHome = null;
            if (this.myPrevInstallation.getText() != null) {
                instHome = FileUtil.toSystemDependentName((String)PathUtil.getCanonicalPath((String)this.myPrevInstallation.getText()));
            }
            String productWithVendor = this.mySettings.getProductName(ThreeState.YES);
            if (StringUtil.isEmptyOrSpaces((String)instHome)) {
                this.showError(this.mySettings.getEmptyHomeErrorText(productWithVendor));
                return;
            }
            String thisInstanceHome = PathManager.getHomePath();
            if (SystemInfo.isFileSystemCaseSensitive ? thisInstanceHome.equals(instHome) : thisInstanceHome.equalsIgnoreCase(instHome)) {
                this.showError(this.mySettings.getCurrentHomeErrorText(productWithVendor));
                return;
            }
            if (this.myRbImport.isSelected() && !ConfigImportHelper.isInstallationHomeOrConfig(instHome, this.mySettings)) {
                this.showError(this.mySettings.getInvalidHomeErrorText(productWithVendor, instHome));
                return;
            }
            if (!new File(instHome).canRead()) {
                this.showError(this.mySettings.getInaccessibleHomeErrorText(instHome));
                return;
            }
        }
        this.dispose();
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, this.mySettings.getInstallationHomeRequiredTitle(), 0);
    }

    public boolean isImportEnabled() {
        return this.myRbImport.isSelected() || this.myRbImportAuto.isSelected();
    }

    public File getSelectedFile() {
        return this.myRbImportAuto.isSelected() ? this.myGuessedOldConfig : new File(this.myPrevInstallation.getText());
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ImportOldConfigsPanel dialog = new ImportOldConfigsPanel(null, new ConfigImportSettings());
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JRadioButton jRadioButton3;
        JLabel jLabel2;
        JButton jButton;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.ok"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySuggestLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.you.can.import"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myRbImport = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.import"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myHomeLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.installation.home"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrevInstallation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel3.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(20, 0), null));
        this.myRbImportAuto = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.import.auto"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRbDoNotImport = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.do.not.import"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

