/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.moduleDependencies.ModulesDependenciesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ShowModuleDependenciesAction
extends AnAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(AnActionEvent e) {
        ModulesDependenciesPanel panel;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        AnalysisScope scope = new AnalysisScope(project);
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null) {
            panel = new ModulesDependenciesPanel(project, modules);
            scope = new AnalysisScope(modules);
        } else {
            Module module;
            PsiElement element = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
            Module module2 = module = element != null ? ModuleUtil.findModuleForPsiElement((PsiElement)element) : null;
            if (module != null && ModuleManager.getInstance((Project)project).getModules().length > 1) {
                MyModuleOrProjectScope dlg = new MyModuleOrProjectScope(module.getName());
                dlg.show();
                if (!dlg.isOK()) return;
                if (!dlg.useProjectScope()) {
                    panel = new ModulesDependenciesPanel(project, new Module[]{module});
                    scope = new AnalysisScope(module);
                } else {
                    panel = new ModulesDependenciesPanel(project);
                }
            } else {
                panel = new ModulesDependenciesPanel(project);
            }
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, AnalysisScopeBundle.message((String)"module.dependencies.toolwindow.title", (Object[])new Object[]{StringUtil.capitalize((String)scope.getDisplayName())}), false);
        content.setDisposer((Disposable)panel);
        panel.setContent(content);
        DependenciesAnalyzeManager.getInstance(project).addContent(content);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        e.getPresentation().setEnabled(project != null);
    }

    private static class MyModuleOrProjectScope
    extends DialogWrapper {
        private final JRadioButton myProjectScope;
        private final JRadioButton myModuleScope;

        protected MyModuleOrProjectScope(String moduleName) {
            super(false);
            this.setTitle(AnalysisScopeBundle.message((String)"module.dependencies.scope.dialog.title", (Object[])new Object[0]));
            ButtonGroup group = new ButtonGroup();
            this.myProjectScope = new JRadioButton(AnalysisScopeBundle.message((String)"module.dependencies.scope.dialog.project.button", (Object[])new Object[0]));
            this.myModuleScope = new JRadioButton(AnalysisScopeBundle.message((String)"module.dependencies.scope.dialog.module.button", (Object[])new Object[]{moduleName}));
            group.add(this.myProjectScope);
            group.add(this.myModuleScope);
            this.myProjectScope.setSelected(true);
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new GridLayout(2, 1));
            panel.add(this.myProjectScope);
            panel.add(this.myModuleScope);
            return panel;
        }

        public boolean useProjectScope() {
            return this.myProjectScope.isSelected();
        }
    }
}

