/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockFileManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.util.PsiModificationTracker;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPsiManager
extends PsiManagerEx {
    private final Project myProject;
    private final Map<VirtualFile, PsiDirectory> myDirectories;
    private MockFileManager myMockFileManager;
    private PsiModificationTrackerImpl myPsiModificationTracker;

    public MockPsiManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "<init>"));
        }
        this.myDirectories = new THashMap();
        this.myProject = project;
    }

    public void addPsiDirectory(VirtualFile file, PsiDirectory psiDirectory) {
        this.myDirectories.put(file, psiDirectory);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiManager", "getProject"));
        }
        return project;
    }

    public PsiFile findFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "findFile"));
        }
        return null;
    }

    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "findViewProvider"));
        }
        return null;
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "findDirectory"));
        }
        return this.myDirectories.get(file);
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        return Comparing.equal((Object)element1, (Object)element2);
    }

    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "reloadFromDisk"));
        }
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "addPsiTreeChangeListener"));
        }
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "addPsiTreeChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/mock/MockPsiManager", "addPsiTreeChangeListener"));
        }
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "removePsiTreeChangeListener"));
        }
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        if (this.myPsiModificationTracker == null) {
            this.myPsiModificationTracker = new PsiModificationTrackerImpl(this.myProject);
        }
        PsiModificationTrackerImpl psiModificationTrackerImpl = this.myPsiModificationTracker;
        if (psiModificationTrackerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiManager", "getModificationTracker"));
        }
        return psiModificationTrackerImpl;
    }

    public void startBatchFilesProcessingMode() {
    }

    public void finishBatchFilesProcessingMode() {
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "getUserData"));
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "putUserData"));
        }
    }

    public boolean isDisposed() {
        return false;
    }

    public void dropResolveCaches() {
        this.getFileManager().cleanupForNextTest();
    }

    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "isInProject"));
        }
        return false;
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return false;
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "isAssertOnFileLoading"));
        }
        return false;
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterChange(boolean isPhysical) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRunnableToRunOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "registerRunnableToRunOnChange"));
        }
    }

    @Override
    public void registerRunnableToRunOnAnyChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "registerRunnableToRunOnAnyChange"));
        }
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "registerRunnableToRunAfterAnyChange"));
        }
        throw new UnsupportedOperationException("Method registerRunnableToRunAfterAnyChange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        if (this.myMockFileManager == null) {
            this.myMockFileManager = new MockFileManager(this);
        }
        MockFileManager mockFileManager = this.myMockFileManager;
        if (mockFileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiManager", "getFileManager"));
        }
        return mockFileManager;
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "beforeChildRemoval"));
        }
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "beforeChildReplacement"));
        }
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockPsiManager", "beforeChildAddition"));
        }
    }
}

