/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class MockProject
extends MockComponentManager
implements Project {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.mock.MockProject");
    private VirtualFile myBaseDir;

    public MockProject(PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/mock/MockProject", "<init>"));
        }
        super(parent, parentDisposable);
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.disposeArea((AreaInstance)MockProject.this);
            }
        });
    }

    public boolean isDefault() {
        return false;
    }

    @Override
    @NotNull
    public Condition getDisposed() {
        Condition condition = new Condition(){

            public boolean value(Object o) {
                return MockProject.this.isDisposed();
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getDisposed"));
        }
        return condition;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isInitialized() {
        return true;
    }

    public VirtualFile getProjectFile() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getName"));
        }
        return "";
    }

    @Nullable
    @NonNls
    public String getPresentableUrl() {
        return null;
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        if ("mock" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getLocationHash"));
        }
        return "mock";
    }

    @NotNull
    public String getProjectFilePath() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getProjectFilePath"));
        }
        return "";
    }

    public VirtualFile getWorkspaceFile() {
        return null;
    }

    public void setBaseDir(VirtualFile baseDir) {
        this.myBaseDir = baseDir;
    }

    @Nullable
    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    public String getBasePath() {
        return null;
    }

    public void save() {
    }

    @Override
    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockProject", "getExtensions"));
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getExtensions"));
        }
        return objectArray;
    }

    public void projectOpened() {
        ProjectComponent[] components;
        for (ProjectComponent component : components = this.getComponents(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component.toString(), e);
            }
        }
    }
}

