/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MockInspectionProfile
extends InspectionProfileImpl {
    private InspectionToolWrapper[] myInspectionTools = new InspectionToolWrapper[0];
    private final Set<InspectionToolWrapper> myDisabledTools = new THashSet();

    public MockInspectionProfile() {
        super("a");
    }

    public void setEnabled(@NotNull InspectionToolWrapper tool, boolean enabled) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockInspectionProfile", "setEnabled"));
        }
        if (enabled) {
            this.myDisabledTools.remove(tool);
        } else {
            this.myDisabledTools.add(tool);
        }
    }

    @Override
    public boolean isToolEnabled(final HighlightDisplayKey key, PsiElement element) {
        InspectionToolWrapper entry = (InspectionToolWrapper)ContainerUtil.find((Object[])this.myInspectionTools, (Condition)new Condition<InspectionToolWrapper>(){

            public boolean value(InspectionToolWrapper inspectionProfileEntry) {
                return key.equals(HighlightDisplayKey.find((String)inspectionProfileEntry.getShortName()));
            }
        });
        assert (entry != null);
        return !this.myDisabledTools.contains(entry);
    }

    public void setInspectionTools(InspectionToolWrapper ... entries) {
        this.myInspectionTools = entries;
    }

    @Override
    @NotNull
    public InspectionToolWrapper[] getInspectionTools(PsiElement element) {
        if (this.myInspectionTools == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockInspectionProfile", "getInspectionTools"));
        }
        return this.myInspectionTools;
    }
}

