/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileManager
implements FileManager {
    private final PsiManagerEx myManager;
    private final FactoryMap<VirtualFile, FileViewProvider> myViewProviders = new FactoryMap<VirtualFile, FileViewProvider>(){

        protected FileViewProvider create(VirtualFile key) {
            return new SingleRootFileViewProvider(MockFileManager.this.myManager, key);
        }
    };

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "createFileViewProvider"));
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, file, eventSystemEnabled);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileManager", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }

    public MockFileManager(PsiManagerEx manager) {
        this.myManager = manager;
    }

    public void dispose() {
        throw new UnsupportedOperationException("Method dispose is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "findFile"));
        }
        return this.getCachedPsiFile(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "findDirectory"));
        }
        throw new UnsupportedOperationException("Method findDirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "reloadFromDisk"));
        }
        throw new UnsupportedOperationException("Method reloadFromDisk is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "getCachedPsiFile"));
        }
        FileViewProvider provider = this.findCachedViewProvider(vFile);
        return provider.getPsi(provider.getBaseLanguage());
    }

    @Override
    public void cleanupForNextTest() {
        this.myViewProviders.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "findViewProvider"));
        }
        throw new UnsupportedOperationException("Method findViewProvider is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "findCachedViewProvider"));
        }
        return (FileViewProvider)this.myViewProviders.get((Object)file);
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider fileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileManager", "setViewProvider"));
        }
        this.myViewProviders.put((Object)virtualFile, (Object)fileViewProvider);
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        throw new UnsupportedOperationException("Method getAllCachedFiles is not yet implemented in " + this.getClass().getName());
    }
}

