/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSyntaxHighlighterFactory
extends SyntaxHighlighterFactory
implements SyntaxHighlighterProvider {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
        JavaFileHighlighter javaFileHighlighter = new JavaFileHighlighter(LanguageLevelUtil.getLanguageLevelForFile((VirtualFile)file));
        if (javaFileHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaSyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return javaFileHighlighter;
    }

    @Nullable
    public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file) {
        PsiFile psiFile;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/java/JavaSyntaxHighlighterFactory", "create"));
        }
        if (project != null && file != null && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof ClsFileImpl) {
            LanguageLevel sourceLevel = ((ClsFileImpl)psiFile).getLanguageLevel();
            return new JavaFileHighlighter(sourceLevel);
        }
        return new JavaFileHighlighter();
    }
}

