/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.customFolding.GotoCustomRegionDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;

public class GotoCustomRegionAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        final Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            return;
        }
        if (project != null && editor != null) {
            if (DumbService.getInstance((Project)project).isDumb()) {
                DumbService.getInstance((Project)project).showDumbModeNotification(IdeBundle.message((String)"goto.custom.region.message.dumb.mode", (Object[])new Object[0]));
                return;
            }
            CommandProcessor processor = CommandProcessor.getInstance();
            processor.executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    PsiElement navigationElement;
                    GotoCustomRegionDialog dialog = new GotoCustomRegionDialog(project, editor);
                    dialog.show();
                    if (dialog.isOK() && (navigationElement = dialog.getNavigationElement()) != null) {
                        GotoCustomRegionAction.navigateTo(editor, navigationElement);
                        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                    }
                }
            }, IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0]), null);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setText("Custom Region...");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        boolean isAvailable = editor != null && project != null;
        presentation.setEnabled(isAvailable);
        presentation.setVisible(isAvailable);
    }

    private static void navigateTo(Editor editor, PsiElement element) {
        int offset = element.getTextRange().getStartOffset();
        if (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            editor.getSelectionModel().removeSelection();
        }
    }
}

