/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class HtmlLanguageLevelForm {
    private JRadioButton myHtml4RadioButton;
    private JRadioButton myHtml5RadioButton;
    private JRadioButton myOtherRadioButton;
    private JPanel myContentPanel;
    private JPanel myOtherDoctypeWrapper;
    private final TextFieldWithAutoCompletion myDoctypeTextField;
    private final List<MyListener> myListeners;

    public HtmlLanguageLevelForm(Project project) {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        String[] urls = ExternalResourceManager.getInstance().getResourceUrls(null, true);
        this.myDoctypeTextField = TextFieldWithAutoCompletion.create(project, Arrays.asList(urls), null, true, null);
        this.myOtherDoctypeWrapper.add((Component)((Object)this.myDoctypeTextField));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlLanguageLevelForm.this.myDoctypeTextField.setEnabled(HtmlLanguageLevelForm.this.myOtherRadioButton.isSelected());
                HtmlLanguageLevelForm.this.fireDoctypeChanged();
            }
        };
        this.myHtml4RadioButton.addActionListener(listener);
        this.myHtml5RadioButton.addActionListener(listener);
        this.myOtherRadioButton.addActionListener(listener);
        this.myDoctypeTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                HtmlLanguageLevelForm.this.fireDoctypeChanged();
            }
        });
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    @NotNull
    public String getDoctype() {
        if (this.myHtml4RadioButton.isSelected()) {
            if ("http://www.w3.org/1999/xhtml" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/HtmlLanguageLevelForm", "getDoctype"));
            }
            return "http://www.w3.org/1999/xhtml";
        }
        if (this.myHtml5RadioButton.isSelected()) {
            String string = Html5SchemaProvider.getHtml5SchemaLocation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/HtmlLanguageLevelForm", "getDoctype"));
            }
            return string;
        }
        String string = this.myDoctypeTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/HtmlLanguageLevelForm", "getDoctype"));
        }
        return string;
    }

    public void resetFromDoctype(final String doctype) {
        if (doctype == null || doctype.isEmpty() || doctype.equals(XmlUtil.XHTML4_SCHEMA_LOCATION)) {
            this.myHtml4RadioButton.setSelected(true);
            this.myDoctypeTextField.setEnabled(false);
        } else if (doctype.equals(Html5SchemaProvider.getHtml5SchemaLocation())) {
            this.myHtml5RadioButton.setSelected(true);
            this.myDoctypeTextField.setEnabled(false);
        } else {
            this.myOtherRadioButton.setSelected(true);
            this.myDoctypeTextField.setEnabled(true);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        HtmlLanguageLevelForm.this.myDoctypeTextField.setText(doctype);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    public void addListener(@NotNull MyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/HtmlLanguageLevelForm", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull MyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/HtmlLanguageLevelForm", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    private void fireDoctypeChanged() {
        for (MyListener listener : this.myListeners) {
            listener.doctypeChanged();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Default HTML language level", (int)0, (int)0, null, null));
        this.myHtml4RadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("HTML 4 (\"http://www.w3.org/TR/html4/loose.dtd\")");
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myHtml5RadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("HTML 5");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOtherRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Other doctype:");
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOtherDoctypeWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    public static interface MyListener {
        public void doctypeChanged();
    }
}

