/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.ResourceRegistrarImpl;
import com.intellij.javaee.StandardResourceEP;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.javaee.XMLCatalogManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalResourceManagerExImpl
extends ExternalResourceManagerEx {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.openapi.impl.ExternalResourceManagerImpl");
    @NonNls
    public static final String J2EE_1_3 = "http://java.sun.com/dtd/";
    @NonNls
    public static final String J2EE_1_2 = "http://java.sun.com/j2ee/dtds/";
    @NonNls
    public static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee/";
    @NonNls
    public static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee/";
    private static final String CATALOG_PROPERTIES_ELEMENT = "CATALOG_PROPERTIES";
    private final Map<String, Map<String, String>> myResources = new HashMap();
    private final Set<String> myResourceLocations = new HashSet<String>();
    private final Set<String> myIgnoredResources = new HashSet<String>();
    private final AtomicNotNullLazyValue<Map<String, Map<String, Resource>>> myStdResources = new AtomicNotNullLazyValue<Map<String, Map<String, Resource>>>(){

        @NotNull
        protected Map<String, Map<String, Resource>> compute() {
            Map<String, Map<String, Resource>> map = ExternalResourceManagerExImpl.this.computeStdResources();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourceManagerExImpl$1", "compute"));
            }
            return map;
        }
    };
    private String myDefaultHtmlDoctype = "HTML5";
    private String myCatalogPropertiesFile;
    private XMLCatalogManager myCatalogManager;
    private static final String HTML5_DOCTYPE_ELEMENT = "HTML5";
    private final List<ExternalResourceListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private long myModificationCount = 0L;
    private final PathMacrosImpl myPathMacros;
    @NonNls
    private static final String RESOURCE_ELEMENT = "resource";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String LOCATION_ATTR = "location";
    @NonNls
    private static final String IGNORED_RESOURCE_ELEMENT = "ignored-resource";
    @NonNls
    private static final String HTML_DEFAULT_DOCTYPE_ELEMENT = "default-html-doctype";
    private static final String DEFAULT_VERSION = null;

    protected Map<String, Map<String, Resource>> computeStdResources() {
        StandardResourceEP[] extensions;
        ResourceRegistrarImpl registrar = new ResourceRegistrarImpl();
        for (StandardResourceProvider provider : (StandardResourceProvider[])Extensions.getExtensions((ExtensionPointName)StandardResourceProvider.EP_NAME)) {
            provider.registerResources((ResourceRegistrar)registrar);
        }
        for (StandardResourceEP extension : extensions = (StandardResourceEP[])Extensions.getExtensions((ExtensionPointName)StandardResourceEP.EP_NAME)) {
            registrar.addStdResource(extension.url, extension.version, extension.resourcePath, null, extension.getLoaderForClass());
        }
        this.myIgnoredResources.addAll(registrar.getIgnored());
        return registrar.getResources();
    }

    public ExternalResourceManagerExImpl(PathMacrosImpl pathMacros) {
        this.myPathMacros = pathMacros;
    }

    @Override
    public boolean isStandardResource(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return parent != null && parent.getName().equals("standardSchemas");
    }

    @Override
    public boolean isUserResource(VirtualFile file) {
        return this.myResourceLocations.contains(file.getUrl());
    }

    @Nullable
    static <T> Map<String, T> getMap(@NotNull Map<String, Map<String, T>> resources, @Nullable String version, boolean create) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/ExternalResourceManagerExImpl", "getMap"));
        }
        Map<Object, Object> map = resources.get(version);
        if (map == null) {
            if (create) {
                map = ContainerUtil.newHashMap();
                resources.put(version, map);
            } else if (version == null || !version.equals(DEFAULT_VERSION)) {
                map = resources.get(DEFAULT_VERSION);
            }
        }
        return map;
    }

    public String getResourceLocation(String url) {
        return this.getResourceLocation(url, DEFAULT_VERSION);
    }

    public String getResourceLocation(@NonNls String url, String version) {
        XMLCatalogManager manager;
        String result = this.getUserResource(url, version);
        if (result == null && (manager = this.getCatalogManager()) != null) {
            result = manager.resolve(url);
        }
        if (result == null) {
            result = this.getStdResource(url, version);
        }
        if (result == null) {
            result = url;
        }
        return result;
    }

    @Override
    @Nullable
    public String getUserResource(Project project, String url, String version) {
        String resource = this.getProjectResources(project).getUserResource(url, version);
        return resource == null ? this.getUserResource(url, version) : resource;
    }

    @Override
    @Nullable
    public String getStdResource(String url, String version) {
        Map map = ExternalResourceManagerExImpl.getMap((Map)this.myStdResources.getValue(), version, false);
        if (map != null) {
            Resource resource = (Resource)map.get(url);
            return resource == null ? null : resource.getResourceUrl();
        }
        return null;
    }

    @Nullable
    private String getUserResource(String url, String version) {
        Map map = ExternalResourceManagerExImpl.getMap(this.myResources, version, false);
        return map != null ? (String)map.get(url) : null;
    }

    public String getResourceLocation(@NonNls String url, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/javaee/ExternalResourceManagerExImpl", "getResourceLocation"));
        }
        String location = this.getProjectResources(project).getResourceLocation(url);
        return location == null || location.equals(url) ? this.getResourceLocation(url) : location;
    }

    public String getResourceLocation(@NonNls String url, String version, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/javaee/ExternalResourceManagerExImpl", "getResourceLocation"));
        }
        String location = this.getProjectResources(project).getResourceLocation(url, version);
        return location == null || location.equals(url) ? this.getResourceLocation(url, version) : location;
    }

    @Nullable
    public PsiFile getResourceLocation(@NotNull @NonNls String url, @NotNull PsiFile baseFile, String version) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/ExternalResourceManagerExImpl", "getResourceLocation"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/javaee/ExternalResourceManagerExImpl", "getResourceLocation"));
        }
        XmlFile schema = XmlSchemaProvider.findSchema((String)url, (PsiFile)baseFile);
        if (schema != null) {
            return schema;
        }
        String location = this.getResourceLocation(url, version, baseFile.getProject());
        return XmlUtil.findXmlFile(baseFile, location);
    }

    public String[] getResourceUrls(FileType fileType, boolean includeStandard) {
        return this.getResourceUrls(fileType, DEFAULT_VERSION, includeStandard);
    }

    public String[] getResourceUrls(@Nullable FileType fileType, @NonNls String version, boolean includeStandard) {
        LinkedList<String> result = new LinkedList<String>();
        ExternalResourceManagerExImpl.addResourcesFromMap(result, version, this.myResources);
        if (includeStandard) {
            ExternalResourceManagerExImpl.addResourcesFromMap(result, version, (Map)this.myStdResources.getValue());
        }
        return ArrayUtil.toStringArray(result);
    }

    private static <T> void addResourcesFromMap(List<String> result, String version, Map<String, Map<String, T>> resourcesMap) {
        Map<String, T> resources = ExternalResourceManagerExImpl.getMap(resourcesMap, version, false);
        if (resources == null) {
            return;
        }
        result.addAll(resources.keySet());
    }

    public static void addTestResource(final String url, final String location, Disposable parentDisposable) {
        final ExternalResourceManagerExImpl instance = (ExternalResourceManagerExImpl)ExternalResourceManagerExImpl.getInstance();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                instance.addResource(url, location);
            }
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        instance.removeResource(url);
                    }
                });
            }
        });
    }

    public void addResource(String url, String location) {
        this.addResource(url, DEFAULT_VERSION, location);
    }

    public void addResource(@NonNls String url, @NonNls String version, @NonNls String location) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.addSilently(url, version, location);
        this.fireExternalResourceChanged();
    }

    private void addSilently(String url, String version, String location) {
        Map map = ExternalResourceManagerExImpl.getMap(this.myResources, version, true);
        assert (map != null);
        map.put(url, location);
        this.myResourceLocations.add(location);
        ++this.myModificationCount;
    }

    public void removeResource(String url) {
        this.removeResource(url, DEFAULT_VERSION);
    }

    public void removeResource(String url, String version) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Map map = ExternalResourceManagerExImpl.getMap(this.myResources, version, false);
        if (map != null) {
            String location = (String)map.remove(url);
            if (location != null) {
                this.myResourceLocations.remove(location);
            }
            ++this.myModificationCount;
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void removeResource(String url, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/javaee/ExternalResourceManagerExImpl", "removeResource"));
        }
        this.getProjectResources(project).removeResource(url);
    }

    @Override
    public void addResource(@NonNls String url, @NonNls String location, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/javaee/ExternalResourceManagerExImpl", "addResource"));
        }
        this.getProjectResources(project).addResource(url, location);
    }

    @Override
    public String[] getAvailableUrls() {
        HashSet<String> urls = new HashSet<String>();
        for (Map<String, String> map : this.myResources.values()) {
            urls.addAll(map.keySet());
        }
        return ArrayUtil.toStringArray(urls);
    }

    @Override
    public String[] getAvailableUrls(Project project) {
        return this.getProjectResources(project).getAvailableUrls();
    }

    @Override
    public void clearAllResources() {
        this.myResources.clear();
        this.myIgnoredResources.clear();
    }

    @Override
    public void clearAllResources(Project project) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearAllResources();
        this.getProjectResources(project).clearAllResources();
        ++this.myModificationCount;
        this.fireExternalResourceChanged();
    }

    @Override
    public void addIgnoredResource(String url) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.addIgnoredSilently(url);
        this.fireExternalResourceChanged();
    }

    private void addIgnoredSilently(String url) {
        this.myIgnoredResources.add(url);
        ++this.myModificationCount;
    }

    @Override
    public void removeIgnoredResource(String url) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myIgnoredResources.remove(url)) {
            ++this.myModificationCount;
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public boolean isIgnoredResource(String url) {
        this.myStdResources.getValue();
        return this.myIgnoredResources.contains(url) || ExternalResourceManagerExImpl.isImplicitNamespaceDescriptor(url);
    }

    private static boolean isImplicitNamespaceDescriptor(String url) {
        for (ImplicitNamespaceDescriptorProvider namespaceDescriptorProvider : (ImplicitNamespaceDescriptorProvider[])Extensions.getExtensions(ImplicitNamespaceDescriptorProvider.EP_NAME)) {
            if (namespaceDescriptorProvider.getNamespaceDescriptor(null, url, null) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIgnoredResources() {
        this.myStdResources.getValue();
        return ArrayUtil.toStringArray(this.myIgnoredResources);
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Override
    public long getModificationCount(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/ExternalResourceManagerExImpl", "getModificationCount"));
        }
        return this.getProjectResources(project).getModificationCount();
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element catalogElement;
        Element e;
        ExpandMacroToPathMap macroExpands = new ExpandMacroToPathMap();
        this.myPathMacros.addMacroExpands(macroExpands);
        macroExpands.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        ++this.myModificationCount;
        Iterator i$ = element.getChildren(RESOURCE_ELEMENT).iterator();
        while (i$.hasNext()) {
            Element o1;
            e = o1 = (Element)i$.next();
            this.addSilently(e.getAttributeValue(URL_ATTR), DEFAULT_VERSION, e.getAttributeValue(LOCATION_ATTR).replace('/', File.separatorChar));
        }
        i$ = element.getChildren(IGNORED_RESOURCE_ELEMENT).iterator();
        while (i$.hasNext()) {
            Element o;
            e = o = (Element)i$.next();
            this.addIgnoredSilently(e.getAttributeValue(URL_ATTR));
        }
        Element child = element.getChild(HTML_DEFAULT_DOCTYPE_ELEMENT);
        if (child != null) {
            String text = child.getText();
            if (FileUtil.toSystemIndependentName((String)text).endsWith(".jar!/resources/html5-schema/html5.rnc")) {
                text = HTML5_DOCTYPE_ELEMENT;
            }
            this.myDefaultHtmlDoctype = text;
        }
        if ((catalogElement = element.getChild(CATALOG_PROPERTIES_ELEMENT)) != null) {
            this.myCatalogPropertiesFile = catalogElement.getTextTrim();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String[] ignoredResources;
        Element e;
        String[] urls;
        for (String url : urls = this.getAvailableUrls()) {
            String location;
            if (url == null || (location = this.getResourceLocation(url)) == null) continue;
            e = new Element(RESOURCE_ELEMENT);
            e.setAttribute(URL_ATTR, url);
            e.setAttribute(LOCATION_ATTR, location.replace(File.separatorChar, '/'));
            element.addContent(e);
        }
        for (String ignoredResource : ignoredResources = this.getIgnoredResources()) {
            e = new Element(IGNORED_RESOURCE_ELEMENT);
            e.setAttribute(URL_ATTR, ignoredResource);
            element.addContent(e);
        }
        if (this.myDefaultHtmlDoctype != null && !HTML5_DOCTYPE_ELEMENT.equals(this.myDefaultHtmlDoctype)) {
            Element e2 = new Element(HTML_DEFAULT_DOCTYPE_ELEMENT);
            e2.setText(this.myDefaultHtmlDoctype);
            element.addContent(e2);
        }
        if (this.myCatalogPropertiesFile != null) {
            Element properties = new Element(CATALOG_PROPERTIES_ELEMENT);
            properties.setText(this.myCatalogPropertiesFile);
            element.addContent(properties);
        }
        ReplacePathToMacroMap macroReplacements = new ReplacePathToMacroMap();
        PathMacrosImpl.getInstanceEx().addMacroReplacements(macroReplacements);
        macroReplacements.substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void addExternalResourceListener(ExternalResourceListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeExternalResourceListener(ExternalResourceListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireExternalResourceChanged() {
        for (ExternalResourceListener listener : this.myListeners) {
            listener.externalResourceChanged();
        }
    }

    Collection<Map<String, Resource>> getStandardResources() {
        return ((Map)this.myStdResources.getValue()).values();
    }

    protected ExternalResourceManagerExImpl getProjectResources(Project project) {
        return this;
    }

    @Override
    @NotNull
    public String getDefaultHtmlDoctype(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/ExternalResourceManagerExImpl", "getDefaultHtmlDoctype"));
        }
        String doctype = this.getProjectResources((Project)project).myDefaultHtmlDoctype;
        if ("http://www.w3.org/1999/xhtml".equals(doctype)) {
            String string = XmlUtil.XHTML4_SCHEMA_LOCATION;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourceManagerExImpl", "getDefaultHtmlDoctype"));
            }
            return string;
        }
        if (HTML5_DOCTYPE_ELEMENT.equals(doctype)) {
            String string = Html5SchemaProvider.getHtml5SchemaLocation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourceManagerExImpl", "getDefaultHtmlDoctype"));
            }
            return string;
        }
        String string = doctype;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourceManagerExImpl", "getDefaultHtmlDoctype"));
        }
        return string;
    }

    @Override
    public void setDefaultHtmlDoctype(@NotNull String defaultHtmlDoctype, @NotNull Project project) {
        if (defaultHtmlDoctype == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/javaee/ExternalResourceManagerExImpl", "setDefaultHtmlDoctype"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/javaee/ExternalResourceManagerExImpl", "setDefaultHtmlDoctype"));
        }
        this.getProjectResources(project).setDefaultHtmlDoctype(defaultHtmlDoctype);
    }

    @Override
    public String getCatalogPropertiesFile() {
        return this.myCatalogPropertiesFile;
    }

    @Override
    public void setCatalogPropertiesFile(String filePath) {
        this.myCatalogManager = null;
        this.myCatalogPropertiesFile = filePath;
        ++this.myModificationCount;
    }

    @Nullable
    private XMLCatalogManager getCatalogManager() {
        if (this.myCatalogManager == null && this.myCatalogPropertiesFile != null) {
            this.myCatalogManager = new XMLCatalogManager(this.myCatalogPropertiesFile);
        }
        return this.myCatalogManager;
    }

    private void setDefaultHtmlDoctype(String defaultHtmlDoctype) {
        ++this.myModificationCount;
        this.myDefaultHtmlDoctype = Html5SchemaProvider.getHtml5SchemaLocation().equals(defaultHtmlDoctype) ? HTML5_DOCTYPE_ELEMENT : defaultHtmlDoctype;
        this.fireExternalResourceChanged();
    }

    public static void registerResourceTemporarily(final String url, final String location, Disposable disposable) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ExternalResourceManager.getInstance().addResource(url, location);
            }
        });
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ExternalResourceManager.getInstance().removeResource(url);
                    }
                });
            }
        });
    }

    static class Resource {
        String file;
        ClassLoader classLoader;
        Class clazz;

        Resource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        String getResourceUrl() {
            if (this.classLoader == null && this.clazz == null) {
                return this.file;
            }
            URL resource = this.clazz == null ? this.classLoader.getResource(this.file) : this.clazz.getResource(this.file);
            try {
                if (resource == null) {
                    String message = "Cannot find standard resource. filename:" + this.file + " class=" + this.clazz + ", classLoader:" + this.classLoader;
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error(message);
                    } else {
                        LOG.warn(message);
                    }
                    String string = null;
                    return string;
                }
            }
            finally {
                this.classLoader = null;
                this.clazz = null;
            }
            String path = FileUtil.unquote((String)resource.toString());
            this.file = path = path.replace('\\', '/');
            return path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (this.classLoader != resource.classLoader) {
                return false;
            }
            if (this.clazz != resource.clazz) {
                return false;
            }
            return !(this.file != null ? !this.file.equals(resource.file) : resource.file != null);
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return this.file + " for " + this.classLoader;
        }
    }
}

